/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.org.apache.http.client.protocol;

import java.io.IOException;
import nebula.plugin.metrics.org.apache.http.HttpException;
import nebula.plugin.metrics.org.apache.http.HttpRequest;
import nebula.plugin.metrics.org.apache.http.HttpRequestInterceptor;
import nebula.plugin.metrics.org.apache.http.annotation.Immutable;
import nebula.plugin.metrics.org.apache.http.client.protocol.HttpClientContext;
import nebula.plugin.metrics.org.apache.http.conn.routing.RouteInfo;
import nebula.plugin.metrics.org.apache.http.protocol.HttpContext;
import nebula.plugin.metrics.org.apache.http.util.Args;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Immutable
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            request.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug((Object)"Connection route not set in the context");
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
        if (route.getHopCount() == 2 && !route.isTunnelled() && !request.containsHeader(PROXY_CONN_DIRECTIVE)) {
            request.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

