/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.org.apache.http.client.protocol;

import java.io.IOException;
import nebula.plugin.metrics.org.apache.http.HttpEntity;
import nebula.plugin.metrics.org.apache.http.HttpEntityEnclosingRequest;
import nebula.plugin.metrics.org.apache.http.HttpException;
import nebula.plugin.metrics.org.apache.http.HttpRequest;
import nebula.plugin.metrics.org.apache.http.HttpRequestInterceptor;
import nebula.plugin.metrics.org.apache.http.HttpVersion;
import nebula.plugin.metrics.org.apache.http.ProtocolVersion;
import nebula.plugin.metrics.org.apache.http.annotation.Immutable;
import nebula.plugin.metrics.org.apache.http.client.config.RequestConfig;
import nebula.plugin.metrics.org.apache.http.client.protocol.HttpClientContext;
import nebula.plugin.metrics.org.apache.http.protocol.HttpContext;
import nebula.plugin.metrics.org.apache.http.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

