/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.org.apache.http.impl.conn;

import nebula.plugin.metrics.org.apache.http.HttpHost;
import nebula.plugin.metrics.org.apache.http.annotation.Immutable;
import nebula.plugin.metrics.org.apache.http.conn.SchemePortResolver;
import nebula.plugin.metrics.org.apache.http.conn.UnsupportedSchemeException;
import nebula.plugin.metrics.org.apache.http.util.Args;

@Immutable
public class DefaultSchemePortResolver
implements SchemePortResolver {
    public static final DefaultSchemePortResolver INSTANCE = new DefaultSchemePortResolver();

    @Override
    public int resolve(HttpHost host) throws UnsupportedSchemeException {
        Args.notNull(host, "HTTP host");
        int port = host.getPort();
        if (port > 0) {
            return port;
        }
        String name = host.getSchemeName();
        if (name.equalsIgnoreCase("http")) {
            return 80;
        }
        if (name.equalsIgnoreCase("https")) {
            return 443;
        }
        throw new UnsupportedSchemeException(name + " protocol is not supported");
    }
}

