/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.org.apache.http.impl.nio;

import nebula.plugin.metrics.org.apache.http.HttpRequest;
import nebula.plugin.metrics.org.apache.http.HttpRequestFactory;
import nebula.plugin.metrics.org.apache.http.HttpResponse;
import nebula.plugin.metrics.org.apache.http.annotation.Immutable;
import nebula.plugin.metrics.org.apache.http.config.ConnectionConfig;
import nebula.plugin.metrics.org.apache.http.entity.ContentLengthStrategy;
import nebula.plugin.metrics.org.apache.http.impl.ConnSupport;
import nebula.plugin.metrics.org.apache.http.impl.DefaultHttpRequestFactory;
import nebula.plugin.metrics.org.apache.http.impl.nio.DefaultNHttpServerConnection;
import nebula.plugin.metrics.org.apache.http.impl.nio.codecs.DefaultHttpRequestParserFactory;
import nebula.plugin.metrics.org.apache.http.nio.NHttpConnectionFactory;
import nebula.plugin.metrics.org.apache.http.nio.NHttpMessageParserFactory;
import nebula.plugin.metrics.org.apache.http.nio.NHttpMessageWriterFactory;
import nebula.plugin.metrics.org.apache.http.nio.reactor.IOSession;
import nebula.plugin.metrics.org.apache.http.nio.util.ByteBufferAllocator;
import nebula.plugin.metrics.org.apache.http.nio.util.HeapByteBufferAllocator;
import nebula.plugin.metrics.org.apache.http.params.HttpParamConfig;
import nebula.plugin.metrics.org.apache.http.params.HttpParams;
import nebula.plugin.metrics.org.apache.http.util.Args;

@Immutable
public class DefaultNHttpServerConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpServerConnection> {
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final NHttpMessageParserFactory<HttpRequest> requestParserFactory;
    private final NHttpMessageWriterFactory<HttpResponse> responseWriterFactory;
    private final ByteBufferAllocator allocator;
    private final ConnectionConfig cconfig;

    @Deprecated
    public DefaultNHttpServerConnectionFactory(HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        Args.notNull(requestFactory, "HTTP request factory");
        Args.notNull(allocator, "Byte buffer allocator");
        Args.notNull(params, "HTTP parameters");
        this.incomingContentStrategy = null;
        this.outgoingContentStrategy = null;
        this.requestParserFactory = new DefaultHttpRequestParserFactory(null, requestFactory);
        this.responseWriterFactory = null;
        this.allocator = allocator;
        this.cconfig = HttpParamConfig.getConnectionConfig(params);
    }

    @Deprecated
    public DefaultNHttpServerConnectionFactory(HttpParams params) {
        this(DefaultHttpRequestFactory.INSTANCE, HeapByteBufferAllocator.INSTANCE, params);
    }

    @Deprecated
    protected DefaultNHttpServerConnection createConnection(IOSession session, HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        return new DefaultNHttpServerConnection(session, requestFactory, allocator, params);
    }

    public DefaultNHttpServerConnectionFactory(ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, NHttpMessageParserFactory<HttpRequest> requestParserFactory, NHttpMessageWriterFactory<HttpResponse> responseWriterFactory, ByteBufferAllocator allocator, ConnectionConfig cconfig) {
        this.incomingContentStrategy = incomingContentStrategy;
        this.outgoingContentStrategy = outgoingContentStrategy;
        this.requestParserFactory = requestParserFactory;
        this.responseWriterFactory = responseWriterFactory;
        this.allocator = allocator;
        this.cconfig = cconfig != null ? cconfig : ConnectionConfig.DEFAULT;
    }

    public DefaultNHttpServerConnectionFactory(ByteBufferAllocator allocator, NHttpMessageParserFactory<HttpRequest> requestParserFactory, NHttpMessageWriterFactory<HttpResponse> responseWriterFactory, ConnectionConfig cconfig) {
        this(null, null, requestParserFactory, responseWriterFactory, allocator, cconfig);
    }

    public DefaultNHttpServerConnectionFactory(ConnectionConfig config) {
        this(null, null, null, null, null, config);
    }

    public DefaultNHttpServerConnectionFactory() {
        this(null, null, null, null, null, null);
    }

    @Override
    public DefaultNHttpServerConnection createConnection(IOSession session) {
        return new DefaultNHttpServerConnection(session, this.cconfig.getBufferSize(), this.cconfig.getFragmentSizeHint(), this.allocator, ConnSupport.createDecoder(this.cconfig), ConnSupport.createEncoder(this.cconfig), this.cconfig.getMessageConstraints(), this.incomingContentStrategy, this.outgoingContentStrategy, this.requestParserFactory, this.responseWriterFactory);
    }
}

