/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.org.apache.http.nio.protocol;

import java.io.IOException;
import nebula.plugin.metrics.org.apache.http.ContentTooLongException;
import nebula.plugin.metrics.org.apache.http.HttpEntity;
import nebula.plugin.metrics.org.apache.http.HttpEntityEnclosingRequest;
import nebula.plugin.metrics.org.apache.http.HttpRequest;
import nebula.plugin.metrics.org.apache.http.entity.ContentType;
import nebula.plugin.metrics.org.apache.http.nio.ContentDecoder;
import nebula.plugin.metrics.org.apache.http.nio.IOControl;
import nebula.plugin.metrics.org.apache.http.nio.entity.ContentBufferEntity;
import nebula.plugin.metrics.org.apache.http.nio.protocol.AbstractAsyncRequestConsumer;
import nebula.plugin.metrics.org.apache.http.nio.util.HeapByteBufferAllocator;
import nebula.plugin.metrics.org.apache.http.nio.util.SimpleInputBuffer;
import nebula.plugin.metrics.org.apache.http.protocol.HttpContext;
import nebula.plugin.metrics.org.apache.http.util.Asserts;

public class BasicAsyncRequestConsumer
extends AbstractAsyncRequestConsumer<HttpRequest> {
    private volatile HttpRequest request;
    private volatile SimpleInputBuffer buf;

    @Override
    protected void onRequestReceived(HttpRequest request) throws IOException {
        this.request = request;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: " + len);
        }
        if (len < 0L) {
            len = 4096L;
        }
        this.buf = new SimpleInputBuffer((int)len, new HeapByteBufferAllocator());
        ((HttpEntityEnclosingRequest)this.request).setEntity(new ContentBufferEntity(entity, this.buf));
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Asserts.notNull(this.buf, "Content buffer");
        this.buf.consumeContent(decoder);
    }

    @Override
    protected void releaseResources() {
        this.request = null;
        this.buf = null;
    }

    @Override
    protected HttpRequest buildResult(HttpContext context) {
        return this.request;
    }
}

