/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.metrics.org.apache.http.nio.protocol;

import nebula.plugin.metrics.org.apache.http.HttpRequest;
import nebula.plugin.metrics.org.apache.http.annotation.ThreadSafe;
import nebula.plugin.metrics.org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import nebula.plugin.metrics.org.apache.http.nio.protocol.HttpAsyncRequestHandlerMapper;
import nebula.plugin.metrics.org.apache.http.protocol.UriPatternMatcher;
import nebula.plugin.metrics.org.apache.http.util.Args;

@ThreadSafe
public class UriHttpAsyncRequestHandlerMapper
implements HttpAsyncRequestHandlerMapper {
    private final UriPatternMatcher<HttpAsyncRequestHandler<?>> matcher;

    protected UriHttpAsyncRequestHandlerMapper(UriPatternMatcher<HttpAsyncRequestHandler<?>> matcher) {
        this.matcher = Args.notNull(matcher, "Pattern matcher");
    }

    public UriHttpAsyncRequestHandlerMapper() {
        this(new UriPatternMatcher());
    }

    public void register(String pattern, HttpAsyncRequestHandler<?> handler) {
        this.matcher.register(pattern, handler);
    }

    public void unregister(String pattern) {
        this.matcher.unregister(pattern);
    }

    protected String getRequestPath(HttpRequest request) {
        String uriPath = request.getRequestLine().getUri();
        int index = uriPath.indexOf("?");
        if (index != -1) {
            uriPath = uriPath.substring(0, index);
        } else {
            index = uriPath.indexOf("#");
            if (index != -1) {
                uriPath = uriPath.substring(0, index);
            }
        }
        return uriPath;
    }

    @Override
    public HttpAsyncRequestHandler<?> lookup(HttpRequest request) {
        return this.matcher.lookup(this.getRequestPath(request));
    }
}

