/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.gradle.plugins.deb;

import com.netflix.gradle.plugins.deb.Deb;
import com.netflix.gradle.plugins.deb.DebFileVisitorStrategy;
import com.netflix.gradle.plugins.deb.InstallLineGenerator;
import com.netflix.gradle.plugins.deb.MaintainerScriptsGenerator;
import com.netflix.gradle.plugins.deb.TemplateHelper;
import com.netflix.gradle.plugins.deb.control.MultiArch;
import com.netflix.gradle.plugins.deb.validation.DebTaskPropertiesValidator;
import com.netflix.gradle.plugins.packaging.AbstractPackagingCopyAction;
import com.netflix.gradle.plugins.packaging.Dependency;
import com.netflix.gradle.plugins.packaging.Directory;
import com.netflix.gradle.plugins.packaging.Link;
import com.netflix.gradle.plugins.packaging.SystemPackagingTask;
import com.netflix.gradle.plugins.utils.ApacheCommonsFileSystemActions;
import com.netflix.gradle.plugins.utils.DeprecationLoggerUtils;
import com.netflix.gradle.plugins.utils.GradleUtils;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.ToString;
import java.beans.Transient;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.util.HashCodeHelper;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.redline_rpm.payload.Directive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vafer.jdeb.Compression;
import org.vafer.jdeb.Console;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.DebMaker;
import org.vafer.jdeb.mapping.Mapper;
import org.vafer.jdeb.mapping.PermMapper;
import org.vafer.jdeb.producers.DataProducerLink;
import org.vafer.jdeb.producers.DataProducerPathTemplate;

public class DebCopyAction
extends AbstractPackagingCopyAction<Deb> {
    private static final Logger logger;
    private File debianDir;
    private List<String> dependencies;
    private List<String> conflicts;
    private List<String> recommends;
    private List<String> suggests;
    private List<String> enhances;
    private List<String> preDepends;
    private List<String> breaks;
    private List<String> replaces;
    private List<String> provides;
    private List<DataProducer> dataProducers;
    private List<InstallDir> installDirs;
    private final DebTaskPropertiesValidator debTaskPropertiesValidator;
    private DebFileVisitorStrategy debFileVisitorStrategy;
    private final MaintainerScriptsGenerator maintainerScriptsGenerator;
    private final InstallLineGenerator installLineGenerator;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public DebCopyAction(Deb debTask) {
        super(debTask);
        InstallLineGenerator installLineGenerator;
        MaintainerScriptsGenerator maintainerScriptsGenerator;
        DebFileVisitorStrategy debFileVisitorStrategy;
        File file;
        List list;
        List list2;
        List list3;
        List list4;
        List list5;
        List list6;
        List list7;
        List list8;
        List list9;
        List list10;
        List list11;
        DebTaskPropertiesValidator debTaskPropertiesValidator;
        this.debTaskPropertiesValidator = debTaskPropertiesValidator = new DebTaskPropertiesValidator();
        this.debTaskPropertiesValidator.validate(debTask);
        this.dependencies = list11 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.conflicts = list10 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.recommends = list9 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.suggests = list8 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.enhances = list7 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.preDepends = list6 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.breaks = list5 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.replaces = list4 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.dataProducers = list3 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.installDirs = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.provides = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.debianDir = file = new File((File)ScriptBytecodeAdapter.castToType((Object)((SystemPackagingTask)((Object)this.getTask())).getProject().getLayout().getBuildDirectory().getAsFile().get(), File.class), "debian");
        this.debFileVisitorStrategy = debFileVisitorStrategy = new DebFileVisitorStrategy(this.dataProducers, this.installDirs);
        this.maintainerScriptsGenerator = maintainerScriptsGenerator = new MaintainerScriptsGenerator(debTask, new TemplateHelper(this.debianDir, "/deb"), this.debianDir, new ApacheCommonsFileSystemActions());
        this.installLineGenerator = installLineGenerator = new InstallLineGenerator();
    }

    @Override
    public void startVisit(CopyAction action) {
        super.startVisit(action);
        ResourceGroovyMethods.deleteDir((File)this.debianDir);
        this.debianDir.mkdirs();
    }

    @Override
    public void visitFile(FileCopyDetailsInternal fileDetails, Object specToLookAt) {
        Integer n;
        Integer n2;
        Object t;
        logger.debug("adding file {}", (Object)fileDetails.getRelativePath().getPathString());
        File inputFile = this.extractFile(fileDetails);
        Directive fileType = (Directive)ScriptBytecodeAdapter.castToType(GradleUtils.lookup(specToLookAt, "fileType"), Directive.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)fileType, (Object)"CONFIG")) {
            logger.debug("mark {} as configuration file", (Object)fileDetails.getRelativePath().getPathString());
            ((SystemPackagingTask)((Object)this.getTask())).configurationFile(fileDetails.getRelativePath().getPathString());
        }
        String user = ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox(t = GradleUtils.lookup(specToLookAt, "user")) ? t : ((SystemPackagingTask)((Object)this.getTask())).getUser());
        Integer n3 = (Integer)ScriptBytecodeAdapter.castToType(GradleUtils.lookup(specToLookAt, "uid"), Integer.class);
        Integer uid = DefaultTypeTransformation.booleanUnbox((Object)n3) ? n3 : (DefaultTypeTransformation.booleanUnbox((Object)(n2 = ((SystemPackagingTask)((Object)this.getTask())).getUid())) ? n2 : Integer.valueOf(0));
        Object t2 = GradleUtils.lookup(specToLookAt, "permissionGroup");
        String group = ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox(t2) ? t2 : ((SystemPackagingTask)((Object)this.getTask())).getPermissionGroup());
        Integer n4 = (Integer)ScriptBytecodeAdapter.castToType(GradleUtils.lookup(specToLookAt, "gid"), Integer.class);
        Integer gid = DefaultTypeTransformation.booleanUnbox((Object)n4) ? n4 : (DefaultTypeTransformation.booleanUnbox((Object)(n = ((SystemPackagingTask)((Object)this.getTask())).getGid())) ? n : Integer.valueOf(0));
        int fileMode = fileDetails.getMode();
        this.debFileVisitorStrategy.addFile((FileCopyDetails)fileDetails, inputFile, user, uid, group, gid, fileMode);
    }

    @Override
    public void visitDir(FileCopyDetailsInternal dirDetails, Object specToLookAt) {
        Object specCreateDirectoryEntry = GradleUtils.lookup(specToLookAt, "createDirectoryEntry");
        boolean createDirectoryEntry = DefaultTypeTransformation.booleanUnbox(specCreateDirectoryEntry != null ? specCreateDirectoryEntry : ((SystemPackagingTask)((Object)this.getTask())).getCreateDirectoryEntry());
        if (createDirectoryEntry) {
            Integer n;
            Integer n2;
            logger.debug("adding directory {}", (Object)dirDetails.getRelativePath().getPathString());
            Object t = GradleUtils.lookup(specToLookAt, "user");
            String user = ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox(t) ? t : ((SystemPackagingTask)((Object)this.getTask())).getUser());
            Integer n3 = (Integer)ScriptBytecodeAdapter.castToType(GradleUtils.lookup(specToLookAt, "uid"), Integer.class);
            Integer uid = DefaultTypeTransformation.booleanUnbox((Object)n3) ? n3 : (DefaultTypeTransformation.booleanUnbox((Object)(n2 = ((SystemPackagingTask)((Object)this.getTask())).getUid())) ? n2 : Integer.valueOf(0));
            Object t2 = GradleUtils.lookup(specToLookAt, "permissionGroup");
            String group = ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox(t2) ? t2 : ((SystemPackagingTask)((Object)this.getTask())).getPermissionGroup());
            Integer n4 = (Integer)ScriptBytecodeAdapter.castToType(GradleUtils.lookup(specToLookAt, "gid"), Integer.class);
            Integer gid = DefaultTypeTransformation.booleanUnbox((Object)n4) ? n4 : (DefaultTypeTransformation.booleanUnbox((Object)(n = ((SystemPackagingTask)((Object)this.getTask())).getGid())) ? n : Integer.valueOf(0));
            int fileMode = dirDetails.getMode();
            this.debFileVisitorStrategy.addDirectory((FileCopyDetails)dirDetails, user, uid, group, gid, fileMode);
        }
    }

    @Override
    protected void addLink(Link link) {
        DefaultGroovyMethods.leftShift(this.dataProducers, (Object)new DataProducerLink(link.getPath(), link.getTarget(), true, null, null, null));
    }

    @Override
    protected void addDependency(Dependency dep) {
        DefaultGroovyMethods.leftShift(this.dependencies, (Object)dep.toDebString());
    }

    @Override
    protected void addConflict(Dependency dep) {
        DefaultGroovyMethods.leftShift(this.conflicts, (Object)dep.toDebString());
    }

    @Override
    protected void addProvides(Dependency dep) {
        String providesString = dep.getPackageName();
        if (DefaultTypeTransformation.booleanUnbox((Object)dep.getVersion())) {
            providesString = StringGroovyMethods.plus((String)providesString, (CharSequence)new GStringImpl(new Object[]{dep.getVersion()}, new String[]{" (= ", ")"}));
        }
        DefaultGroovyMethods.leftShift(this.provides, (Object)providesString);
    }

    @Override
    protected void addObsolete(Dependency dep) {
        logger.warn("Obsoletes functionality not implemented for deb files");
    }

    protected void addRecommends(Dependency dep) {
        DefaultGroovyMethods.leftShift(this.recommends, (Object)dep.toDebString());
    }

    protected void addSuggests(Dependency dep) {
        DefaultGroovyMethods.leftShift(this.suggests, (Object)dep.toDebString());
    }

    protected void addEnhances(Dependency dep) {
        DefaultGroovyMethods.leftShift(this.enhances, (Object)dep.toDebString());
    }

    protected void addPreDepends(Dependency dep) {
        DefaultGroovyMethods.leftShift(this.preDepends, (Object)dep.toDebString());
    }

    protected void addBreaks(Dependency dep) {
        DefaultGroovyMethods.leftShift(this.breaks, (Object)dep.toDebString());
    }

    protected void addReplaces(Dependency dep) {
        DefaultGroovyMethods.leftShift(this.replaces, (Object)dep.toDebString());
    }

    @Override
    protected void addDirectory(Directory directory) {
        String user = DefaultTypeTransformation.booleanUnbox((Object)directory.getUser()) ? directory.getUser() : ((SystemPackagingTask)((Object)this.getTask())).getUser();
        String permissionGroup = DefaultTypeTransformation.booleanUnbox((Object)directory.getPermissionGroup()) ? directory.getPermissionGroup() : ((SystemPackagingTask)((Object)this.getTask())).getPermissionGroup();
        DefaultGroovyMethods.leftShift(this.dataProducers, (Object)new DataProducerPathTemplate(new String[]{directory.getPath()}, null, null, new Mapper[]{new PermMapper(-1, -1, user, permissionGroup, directory.getPermissions(), -1, 0, null)}));
    }

    protected String getMultiArch() {
        String archString = ((SystemPackagingTask)((Object)this.getTask())).getArchString();
        MultiArch multiArch = ((SystemPackagingTask)((Object)this.getTask())).getMultiArch();
        if (ScriptBytecodeAdapter.compareEqual((Object)"all", (Object)archString) && ScriptBytecodeAdapter.compareEqual((Object)((Object)MultiArch.SAME), (Object)((Object)multiArch))) {
            throw (Throwable)new IllegalArgumentException("Deb packages with Architecture: all cannot declare Multi-Arch: same");
        }
        MultiArch multiArch2 = multiArch;
        String string = multiArch2 != null ? multiArch2.name() : null;
        String string2 = string != null ? string.toLowerCase() : null;
        String multiArchString = DefaultTypeTransformation.booleanUnbox((Object)string2) ? string2 : "";
        return multiArchString;
    }

    protected Map<String, String> getCustomFields() {
        public final class _getCustomFields_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getCustomFields_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public List<String> doCall(String key, String val) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{StringGroovyMethods.plus((String)"XB-", (CharSequence)StringGroovyMethods.capitalize((CharSequence)key)), val});
            }

            @Generated
            public List<String> call(String key, String val) {
                return this.doCall(key, val);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getCustomFields_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.collectEntries(((Deb)((Object)ScriptBytecodeAdapter.castToType(this.getTask(), Deb.class))).getAllCustomFields(), (Closure)new _getCustomFields_closure1(this, this));
    }

    @Override
    protected void end() {
        List<Dependency> list;
        List<Dependency> list2;
        List<Dependency> list3;
        List<Dependency> list4;
        List<Dependency> list5;
        List<Dependency> list6 = ((Deb)((Object)ScriptBytecodeAdapter.castToType(this.getTask(), Deb.class))).getAllRecommends();
        Iterator<Dependency> iterator = list6 != null ? list6.iterator() : null;
        Dependency recommends = null;
        Iterator<Dependency> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                recommends = (Dependency)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), Dependency.class);
                logger.debug("adding recommends on {} {}", (Object)recommends.getPackageName(), (Object)recommends.getVersion());
                this.addRecommends(recommends);
            }
        }
        Iterator<Dependency> iterator3 = (list5 = ((Deb)((Object)ScriptBytecodeAdapter.castToType(this.getTask(), Deb.class))).getAllSuggests()) != null ? list5.iterator() : null;
        Dependency suggests = null;
        Iterator<Dependency> iterator4 = iterator3;
        if (iterator4 != null) {
            while (iterator4.hasNext()) {
                suggests = (Dependency)ScriptBytecodeAdapter.castToType((Object)iterator4.next(), Dependency.class);
                logger.debug("adding suggests on {} {}", (Object)suggests.getPackageName(), (Object)suggests.getVersion());
                this.addSuggests(suggests);
            }
        }
        Iterator<Dependency> iterator5 = (list4 = ((Deb)((Object)ScriptBytecodeAdapter.castToType(this.getTask(), Deb.class))).getAllEnhances()) != null ? list4.iterator() : null;
        Dependency enhances = null;
        Iterator<Dependency> iterator6 = iterator5;
        if (iterator6 != null) {
            while (iterator6.hasNext()) {
                enhances = (Dependency)ScriptBytecodeAdapter.castToType((Object)iterator6.next(), Dependency.class);
                logger.debug("adding enhances on {} {}", (Object)enhances.getPackageName(), (Object)enhances.getVersion());
                this.addEnhances(enhances);
            }
        }
        Iterator<Dependency> iterator7 = (list3 = ((Deb)((Object)ScriptBytecodeAdapter.castToType(this.getTask(), Deb.class))).getAllPreDepends()) != null ? list3.iterator() : null;
        Dependency preDepends = null;
        Iterator<Dependency> iterator8 = iterator7;
        if (iterator8 != null) {
            while (iterator8.hasNext()) {
                preDepends = (Dependency)ScriptBytecodeAdapter.castToType((Object)iterator8.next(), Dependency.class);
                logger.debug("adding preDepends on {} {}", (Object)preDepends.getPackageName(), (Object)preDepends.getVersion());
                this.addPreDepends(preDepends);
            }
        }
        Iterator<Dependency> iterator9 = (list2 = ((Deb)((Object)ScriptBytecodeAdapter.castToType(this.getTask(), Deb.class))).getAllBreaks()) != null ? list2.iterator() : null;
        Dependency breaks = null;
        Iterator<Dependency> iterator10 = iterator9;
        if (iterator10 != null) {
            while (iterator10.hasNext()) {
                breaks = (Dependency)ScriptBytecodeAdapter.castToType((Object)iterator10.next(), Dependency.class);
                logger.debug("adding breaks on {} {}", (Object)breaks.getPackageName(), (Object)breaks.getVersion());
                this.addBreaks(breaks);
            }
        }
        Iterator<Dependency> iterator11 = (list = ((Deb)((Object)ScriptBytecodeAdapter.castToType(this.getTask(), Deb.class))).getAllReplaces()) != null ? list.iterator() : null;
        Dependency replaces = null;
        Iterator<Dependency> iterator12 = iterator11;
        if (iterator12 != null) {
            while (iterator12.hasNext()) {
                replaces = (Dependency)ScriptBytecodeAdapter.castToType((Object)iterator12.next(), Dependency.class);
                logger.debug("adding replaces on {} {}", (Object)replaces.getPackageName(), (Object)replaces.getVersion());
                this.addReplaces(replaces);
            }
        }
        this.maintainerScriptsGenerator.generate(this.toContext());
        public final class _end_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _end_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public byte[] doCall(Object supControl) {
                File supControlFile = supControl instanceof File ? (File)ScriptBytecodeAdapter.asType((Object)supControl, File.class) : ((SystemPackagingTask)((Object)((DebCopyAction)((AbstractPackagingCopyAction)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractPackagingCopyAction.class))).getTask())).getProject().file(supControl);
                byte[] byArray = ResourceGroovyMethods.getBytes((File)supControlFile);
                ScriptBytecodeAdapter.setProperty((Object)byArray, null, (Object)new File(((DebCopyAction)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), DebCopyAction.class)).getDebianDir(), supControlFile.getName()), (String)"bytes");
                return byArray;
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _end_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(((SystemPackagingTask)((Object)this.getTask())).getAllSupplementaryControlFiles(), (Closure)new _end_closure2(this, this));
        DebMaker maker = new DebMaker((Console)new GradleLoggerConsole(), this.dataProducers, null);
        File debFile = ((RegularFile)((SystemPackagingTask)((Object)this.getTask())).getArchiveFile().get()).getAsFile();
        maker.setControl(this.debianDir);
        maker.setDeb(debFile);
        if (StringUtils.isNotBlank((CharSequence)((SystemPackagingTask)((Object)this.getTask())).getSigningKeyId()) && StringUtils.isNotBlank((CharSequence)((SystemPackagingTask)((Object)this.getTask())).getSigningKeyPassphrase()) && ((SystemPackagingTask)((Object)this.getTask())).getSigningKeyRingFile().exists()) {
            maker.setKey(((SystemPackagingTask)((Object)this.getTask())).getSigningKeyId());
            maker.setPassphrase(((SystemPackagingTask)((Object)this.getTask())).getSigningKeyPassphrase());
            maker.setKeyring(((SystemPackagingTask)((Object)this.getTask())).getSigningKeyRingFile());
            maker.setSignPackage(true);
        }
        try {
            logger.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{debFile}, new String[]{"Creating debian package: ", ""})));
            maker.setCompression(Compression.GZIP.toString());
            maker.makeDeb();
        }
        catch (Exception e) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{debFile}, new String[]{"Can't build debian package ", ""})), (Throwable)e);
        }
        logger.info("Created deb {}", (Object)debFile);
    }

    public Map toContext() {
        String string;
        LinkedHashMap context = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        public final class _toContext_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _toContext_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public LinkedHashMap<String, String> doCall(InstallDir dir) {
                return (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"install", ((DebCopyAction)this.getThisObject()).installLineGenerator.generate(dir)}), LinkedHashMap.class);
            }

            @Generated
            public LinkedHashMap<String, String> call(InstallDir dir) {
                return this.doCall(dir);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _toContext_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        context = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", ((SystemPackagingTask)((Object)this.getTask())).getPackageName(), "version", ((SystemPackagingTask)((Object)this.getTask())).getArchiveVersion().get(), "release", ((SystemPackagingTask)((Object)this.getTask())).getRelease(), "maintainer", ((SystemPackagingTask)((Object)this.getTask())).getMaintainer(), "uploaders", ((SystemPackagingTask)((Object)this.getTask())).getUploaders(), "priority", ((SystemPackagingTask)((Object)this.getTask())).getPriority(), "epoch", ((SystemPackagingTask)((Object)this.getTask())).getEpoch(), "description", DefaultTypeTransformation.booleanUnbox((Object)(string = ((SystemPackagingTask)((Object)this.getTask())).getPackageDescription())) ? string : "", "distribution", ((SystemPackagingTask)((Object)this.getTask())).getDistribution(), "summary", ((SystemPackagingTask)((Object)this.getTask())).getSummary(), "section", ((SystemPackagingTask)((Object)this.getTask())).getPackageGroup(), "time", DateFormatUtils.SMTP_DATETIME_FORMAT.format(new Date()), "provides", StringUtils.join(this.provides, (String)", "), "depends", StringUtils.join(this.dependencies, (String)", "), "url", ((SystemPackagingTask)((Object)this.getTask())).getUrl(), "arch", ((SystemPackagingTask)((Object)this.getTask())).getArchString(), "multiArch", this.getMultiArch(), "conflicts", StringUtils.join(this.conflicts, (String)", "), "recommends", StringUtils.join(this.recommends, (String)", "), "suggests", StringUtils.join(this.suggests, (String)", "), "enhances", StringUtils.join(this.enhances, (String)", "), "preDepends", StringUtils.join(this.preDepends, (String)", "), "breaks", StringUtils.join(this.breaks, (String)", "), "replaces", StringUtils.join(this.replaces, (String)", "), "fullVersion", this.buildFullVersion(), "customFields", this.getCustomFields(), "dirs", DefaultGroovyMethods.collect(this.installDirs, (Closure)new _toContext_closure3(this, this))}), LinkedHashMap.class);
        return context;
    }

    private String buildFullVersion() {
        Reference fullVersion = new Reference((Object)new StringBuilder());
        public final class _buildFullVersion_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference fullVersion;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildFullVersion_closure4(Object _outerInstance, Object _thisObject, Reference fullVersion) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.fullVersion = reference = fullVersion;
            }

            public StringBuilder doCall(Object it) {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)((SystemPackagingTask)((Object)((DebCopyAction)((AbstractPackagingCopyAction)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractPackagingCopyAction.class))).getTask())).getEpoch(), (Object)0)) {
                    StringBuilder stringBuilder = StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.fullVersion.get(), StringBuilder.class)), (Object)((SystemPackagingTask)((Object)((DebCopyAction)((AbstractPackagingCopyAction)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractPackagingCopyAction.class))).getTask())).getEpoch());
                    this.fullVersion.set((Object)stringBuilder);
                    StringBuilder stringBuilder2 = StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.fullVersion.get(), StringBuilder.class)), (Object)":");
                    this.fullVersion.set((Object)stringBuilder2);
                }
                StringBuilder stringBuilder = StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.fullVersion.get(), StringBuilder.class)), (Object)((SystemPackagingTask)((Object)((DebCopyAction)((AbstractPackagingCopyAction)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractPackagingCopyAction.class))).getTask())).getVersion());
                this.fullVersion.set((Object)stringBuilder);
                if (DefaultTypeTransformation.booleanUnbox((Object)((SystemPackagingTask)((Object)((DebCopyAction)((AbstractPackagingCopyAction)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractPackagingCopyAction.class))).getTask())).getRelease())) {
                    StringBuilder stringBuilder3 = StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.fullVersion.get(), StringBuilder.class)), (Object)"-");
                    this.fullVersion.set((Object)stringBuilder3);
                    StringBuilder stringBuilder4 = StringGroovyMethods.leftShift((StringBuilder)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.fullVersion.get(), StringBuilder.class)), (Object)((SystemPackagingTask)((Object)((DebCopyAction)((AbstractPackagingCopyAction)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractPackagingCopyAction.class))).getTask())).getRelease());
                    this.fullVersion.set((Object)stringBuilder4);
                    return stringBuilder4;
                }
                return (StringBuilder)ScriptBytecodeAdapter.castToType(null, StringBuilder.class);
            }

            @Generated
            public StringBuilder getFullVersion() {
                return (StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.fullVersion.get(), StringBuilder.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public StringBuilder doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildFullVersion_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DeprecationLoggerUtils.whileDisabled((Runnable)((Object)new _buildFullVersion_closure4(this, this, fullVersion)));
        return ((StringBuilder)fullVersion.get()).toString();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DebCopyAction.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DebCopyAction.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DebCopyAction.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DebCopyAction.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DebCopyAction.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ Logger pfaccess$0(DebCopyAction $that) {
        return (Logger)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getField(DebCopyAction.class, DebCopyAction.class, (String)"logger"), Logger.class);
    }

    public static /* synthetic */ File pfaccess$1(DebCopyAction $that) {
        return $that.debianDir;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DebCopyAction.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        DebCopyAction.logger = logger = LoggerFactory.getLogger(DebCopyAction.class);
    }

    @Generated
    public static Logger getLogger() {
        return logger;
    }

    @Generated
    public File getDebianDir() {
        return this.debianDir;
    }

    @Generated
    public void setDebianDir(File file) {
        this.debianDir = file;
    }

    @Generated
    public List<String> getDependencies() {
        return this.dependencies;
    }

    @Generated
    public void setDependencies(List<String> list) {
        this.dependencies = list;
    }

    @Generated
    public List<String> getConflicts() {
        return this.conflicts;
    }

    @Generated
    public void setConflicts(List<String> list) {
        this.conflicts = list;
    }

    @Generated
    public List<String> getRecommends() {
        return this.recommends;
    }

    @Generated
    public void setRecommends(List<String> list) {
        this.recommends = list;
    }

    @Generated
    public List<String> getSuggests() {
        return this.suggests;
    }

    @Generated
    public void setSuggests(List<String> list) {
        this.suggests = list;
    }

    @Generated
    public List<String> getEnhances() {
        return this.enhances;
    }

    @Generated
    public void setEnhances(List<String> list) {
        this.enhances = list;
    }

    @Generated
    public List<String> getPreDepends() {
        return this.preDepends;
    }

    @Generated
    public void setPreDepends(List<String> list) {
        this.preDepends = list;
    }

    @Generated
    public List<String> getBreaks() {
        return this.breaks;
    }

    @Generated
    public void setBreaks(List<String> list) {
        this.breaks = list;
    }

    @Generated
    public List<String> getReplaces() {
        return this.replaces;
    }

    @Generated
    public void setReplaces(List<String> list) {
        this.replaces = list;
    }

    @Generated
    public List<String> getProvides() {
        return this.provides;
    }

    @Generated
    public void setProvides(List<String> list) {
        this.provides = list;
    }

    @Generated
    public List<DataProducer> getDataProducers() {
        return this.dataProducers;
    }

    @Generated
    public void setDataProducers(List<DataProducer> list) {
        this.dataProducers = list;
    }

    @Generated
    public List<InstallDir> getInstallDirs() {
        return this.installDirs;
    }

    @Generated
    public void setInstallDirs(List<InstallDir> list) {
        this.installDirs = list;
    }

    @ToString
    @EqualsAndHashCode
    public static class InstallDir
    implements GroovyObject {
        private String name;
        private String user;
        private String group;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public InstallDir(String name, String user, String group) {
            String string;
            String string2;
            String string3;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.name = string3 = name;
            this.user = string2 = user;
            this.group = string = group;
        }

        @Generated
        public InstallDir(String name, String user) {
            CallSite[] callSiteArray = InstallDir.$getCallSiteArray();
            this(name, user, null);
        }

        @Generated
        public InstallDir(String name) {
            CallSite[] callSiteArray = InstallDir.$getCallSiteArray();
            this(name, null, null);
        }

        @Generated
        public InstallDir() {
            CallSite[] callSiteArray = InstallDir.$getCallSiteArray();
            this(null, null, null);
        }

        @Generated
        public String toString() {
            StringBuilder _result = new StringBuilder();
            Boolean $toStringFirst = Boolean.TRUE;
            _result.append("com.netflix.gradle.plugins.deb.DebCopyAction$InstallDir(");
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                $toStringFirst = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString((Object)this.getName()));
            Boolean bl2 = $toStringFirst;
            if (bl2 == null ? false : bl2) {
                $toStringFirst = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString((Object)this.getUser()));
            Boolean bl3 = $toStringFirst;
            if (bl3 == null ? false : bl3) {
                $toStringFirst = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append(InvokerHelper.toString((Object)this.getGroup()));
            _result.append(")");
            return _result.toString();
        }

        @Generated
        public int hashCode() {
            int _result = HashCodeHelper.initHash();
            if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.getName(), (Object)this)) {
                _result = HashCodeHelper.updateHash((int)_result, (Object)this.getName());
            }
            if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.getUser(), (Object)this)) {
                _result = HashCodeHelper.updateHash((int)_result, (Object)this.getUser());
            }
            if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.getGroup(), (Object)this)) {
                _result = HashCodeHelper.updateHash((int)_result, (Object)this.getGroup());
            }
            return _result;
        }

        @Generated
        public boolean canEqual(Object other) {
            return other instanceof InstallDir;
        }

        @Generated
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof InstallDir)) {
                return false;
            }
            InstallDir otherTyped = (InstallDir)other;
            if (!otherTyped.canEqual(this)) {
                return false;
            }
            if (!ScriptBytecodeAdapter.compareEqual((Object)this.getName(), (Object)otherTyped.getName())) {
                return false;
            }
            if (!ScriptBytecodeAdapter.compareEqual((Object)this.getUser(), (Object)otherTyped.getUser())) {
                return false;
            }
            return !(!ScriptBytecodeAdapter.compareEqual((Object)this.getGroup(), (Object)otherTyped.getGroup()));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(InstallDir.class, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(InstallDir.class, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(InstallDir.class, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(InstallDir.class, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(InstallDir.class, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(InstallDir.class, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(InstallDir.class, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(InstallDir.class, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != InstallDir.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public String getUser() {
            return this.user;
        }

        @Generated
        public void setUser(String string) {
            this.user = string;
        }

        @Generated
        public String getGroup() {
            return this.group;
        }

        @Generated
        public void setGroup(String string) {
            this.group = string;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(InstallDir.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = InstallDir.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    private static class GradleLoggerConsole
    implements Console,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        public GradleLoggerConsole() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void debug(String message) {
            DebCopyAction.getLogger().debug(message);
        }

        public void info(String message) {
            DebCopyAction.getLogger().info(message);
        }

        public void warn(String message) {
            DebCopyAction.getLogger().warn(message);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(GradleLoggerConsole.class, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(GradleLoggerConsole.class, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(GradleLoggerConsole.class, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(GradleLoggerConsole.class, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(GradleLoggerConsole.class, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(GradleLoggerConsole.class, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(GradleLoggerConsole.class, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(GradleLoggerConsole.class, DebCopyAction.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != GradleLoggerConsole.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }
}

