/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.resolutionrules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import nebula.plugin.resolutionrules.AlignRule;
import nebula.plugin.resolutionrules.NebulaResolutionRulesExtension;
import nebula.plugin.resolutionrules.Rule;
import nebula.plugin.resolutionrules.RulesKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Specs;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001:\u0001#B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J:\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0016J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010 \u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0016\u0010!\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lnebula/plugin/resolutionrules/AlignRules;", "Lnebula/plugin/resolutionrules/Rule;", "aligns", "", "Lnebula/plugin/resolutionrules/AlignRule;", "(Ljava/util/List;)V", "getAligns", "()Ljava/util/List;", "logger", "Lorg/gradle/api/logging/Logger;", "getLogger", "()Lorg/gradle/api/logging/Logger;", "alignedVersion", "", "rule", "moduleVersions", "Lorg/gradle/api/artifacts/ResolvedModuleVersion;", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "scheme", "Lorg/gradle/api/internal/artifacts/ivyservice/ivyresolve/strategy/VersionSelectorScheme;", "comparator", "Ljava/util/Comparator;", "apply", "", "project", "Lorg/gradle/api/Project;", "resolutionStrategy", "Lorg/gradle/api/artifacts/ResolutionStrategy;", "extension", "Lnebula/plugin/resolutionrules/NebulaResolutionRulesExtension;", "component1", "copy", "matchedVersion", "version", "VersionMatcher", "gradle-resolution-rules-plugin-compileKotlin"})
public final class AlignRules
implements Rule {
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<AlignRule> aligns;

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void apply(@NotNull Project project, @NotNull Configuration configuration, @NotNull ResolutionStrategy resolutionStrategy, @NotNull NebulaResolutionRulesExtension extension) {
        void $receiver$iv;
        Collection destination$iv$iv;
        ResolvedArtifact it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv2;
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)resolutionStrategy, (String)"resolutionStrategy");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        if (this.aligns.size() == 0) {
            return;
        }
        Configuration copy = configuration.copyRecursive();
        String string = project.getGroup().toString();
        String string2 = project.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.name");
        RulesKt.exclude(copy, string, string2);
        ResolvedConfiguration resolvedConfiguration = copy.getResolvedConfiguration();
        if (resolvedConfiguration.hasError()) {
            LenientConfiguration lenientConfiguration = resolvedConfiguration.getLenientConfiguration();
            this.logger.info("Resolution rules could not resolve all dependencies to align in configuration '" + configuration.getName() + "' should also fail to resolve");
            set = lenientConfiguration.getArtifacts(Specs.SATISFIES_ALL);
        } else {
            set = resolvedConfiguration.getResolvedArtifacts();
        }
        Set artifacts = set;
        Iterable iterable = artifacts;
        void var10_10 = $receiver$iv2;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (ResolvedArtifact)element$iv$iv;
            if (!(!(it.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (ResolvedArtifact)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            ResolvedModuleVersion resolvedModuleVersion = it.getModuleVersion();
            collection2.add(resolvedModuleVersion);
        }
        List moduleVersions = (List)destination$iv$iv;
        DefaultVersionComparator comparator = new DefaultVersionComparator();
        DefaultVersionSelectorScheme scheme = new DefaultVersionSelectorScheme((VersionComparator)comparator);
        LinkedHashMap selectedVersion = new LinkedHashMap();
        Iterable iterable2 = this.aligns;
        for (Object element$iv : $receiver$iv) {
            void destination$iv$iv2;
            void $receiver$iv$iv2;
            void $receiver$iv3;
            AlignRule align = (AlignRule)element$iv;
            Iterable $i$f$mapTo = moduleVersions;
            void $i$f$map = $receiver$iv3;
            Collection collection3 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                ResolvedModuleVersion dep = (ResolvedModuleVersion)element$iv$iv;
                if (!align.resolvedMatches(dep)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List matches = (List)destination$iv$iv2;
            Object object = matches;
            if (!(!object.isEmpty())) continue;
            object = selectedVersion;
            VersionSelectorScheme versionSelectorScheme = (VersionSelectorScheme)scheme;
            Comparator comparator2 = comparator.asStringComparator();
            Intrinsics.checkExpressionValueIsNotNull((Object)comparator2, (String)"comparator.asStringComparator()");
            String string3 = this.alignedVersion(align, matches, configuration, versionSelectorScheme, comparator2);
            object.put(align, string3);
        }
        resolutionStrategy.eachDependency((Action)new Action<DependencyResolveDetails>(this, selectedVersion){
            final /* synthetic */ AlignRules this$0;
            final /* synthetic */ LinkedHashMap $selectedVersion;

            /*
             * WARNING - void declaration
             */
            public final void execute(DependencyResolveDetails details) {
                void destination$iv$iv;
                String $receiver$iv$iv;
                Object $receiver$iv = this.$selectedVersion;
                Map map = $receiver$iv;
                Object object = new LinkedHashMap<K, V>();
                Object object2 = $receiver$iv$iv;
                Iterator<Map.Entry<K, V>> iterator = object2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv$iv;
                    Map.Entry<K, V> it = element$iv$iv = iterator.next();
                    AlignRule alignRule = (AlignRule)it.getKey();
                    DependencyResolveDetails dependencyResolveDetails = details;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dependencyResolveDetails, (String)"details");
                    if (!alignRule.dependencyMatches(dependencyResolveDetails)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                void foundMatch = destination$iv$iv;
                $receiver$iv = foundMatch;
                if (!$receiver$iv.isEmpty()) {
                    void rule;
                    void version;
                    object2 = object = (Map.Entry)CollectionsKt.first((Iterable)foundMatch.entrySet());
                    $receiver$iv = (AlignRule)object2.getKey();
                    object2 = object;
                    $receiver$iv$iv = (String)object2.getValue();
                    object = null;
                    String string = details.getRequested().getVersion();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"details.requested.version");
                    if (Intrinsics.areEqual((Object)version, (Object)this.this$0.matchedVersion((AlignRule)rule, string)) ^ true) {
                        this.this$0.getLogger().info("Resolution rule " + rule + " aligning " + details.getRequested().getGroup() + ":" + details.getRequested().getName() + " to " + (String)version);
                        details.useVersion((String)version);
                    }
                }
            }
            {
                this.this$0 = alignRules;
                this.$selectedVersion = linkedHashMap;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String alignedVersion(@NotNull AlignRule rule, @NotNull List<? extends ResolvedModuleVersion> moduleVersions, @NotNull Configuration configuration, @NotNull VersionSelectorScheme scheme, @NotNull Comparator<String> comparator) {
        void destination$iv$iv;
        ModuleVersionSelector $receiver$iv;
        Iterable $receiver$iv$iv;
        Collection $receiver$iv2;
        String string;
        Collection it;
        void var29_12;
        Iterable destination$iv$iv2;
        Object item$iv$iv2;
        void $receiver$iv$iv2;
        void $receiver$iv3;
        Intrinsics.checkParameterIsNotNull((Object)rule, (String)"rule");
        Intrinsics.checkParameterIsNotNull(moduleVersions, (String)"moduleVersions");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)scheme, (String)"scheme");
        Intrinsics.checkParameterIsNotNull(comparator, (String)"comparator");
        Iterable iterable = moduleVersions;
        void var8_7 = $receiver$iv3;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
        for (Object item$iv$iv2 : $receiver$iv$iv2) {
            ResolvedModuleVersion resolvedModuleVersion = (ResolvedModuleVersion)item$iv$iv2;
            var29_12 = destination$iv$iv2;
            String string2 = it.getId().getVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.id.version");
            string = this.matchedVersion(rule, string2);
            var29_12.add(string);
        }
        List versions = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
        Object object = CollectionsKt.maxWith((Iterable)versions, comparator);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        String highestVersion = (String)object;
        destination$iv$iv2 = moduleVersions;
        Iterator iterator = $receiver$iv2;
        item$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            void destination$iv$iv3;
            void $receiver$iv$iv3;
            ResolvedModuleVersion moduleVersion = (ResolvedModuleVersion)element$iv$iv;
            Iterable $i$f$map = configuration.getResolutionStrategy().getForcedModules();
            Iterator iterator2 = $receiver$iv;
            Collection collection2 = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv3) {
                ModuleVersionSelector it2 = (ModuleVersionSelector)element$iv$iv2;
                ModuleVersionIdentifier id = moduleVersion.getId();
                if (!(Intrinsics.areEqual((Object)it2.getGroup(), (Object)id.getGroup()) && Intrinsics.areEqual((Object)it2.getName(), (Object)id.getName()))) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List forced = (List)destination$iv$iv;
        $receiver$iv2 = forced;
        if (!$receiver$iv2.isEmpty()) {
            void staticVersions;
            void dynamicVersions;
            void $receiver$iv4;
            Pair destination$iv$iv4;
            List $receiver$iv$iv4;
            List $receiver$iv5;
            Object element$iv$iv;
            $receiver$iv$iv = forced;
            destination$iv$iv = $receiver$iv5;
            it = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv5, (int)10));
            for (Object item$iv$iv3 : $receiver$iv$iv4) {
                void it3;
                $receiver$iv = (ModuleVersionSelector)item$iv$iv3;
                var29_12 = destination$iv$iv4;
                string = it3.getVersion();
                var29_12.add(string);
            }
            List forcedVersions = CollectionsKt.distinct((Iterable)((List)destination$iv$iv4));
            element$iv$iv = forcedVersions;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $receiver$iv4) {
                VersionSelector selector;
                String version = (String)element$iv;
                if (scheme.parseSelector(version) == null) {
                    Intrinsics.throwNpe();
                }
                if (selector.isDynamic()) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            destination$iv$iv4 = new Pair(first$iv, second$iv);
            $receiver$iv5 = (List)destination$iv$iv4.component1();
            $receiver$iv$iv4 = (List)destination$iv$iv4.component2();
            destination$iv$iv4 = null;
            if (!dynamicVersions.isEmpty()) {
                this.logger.warn("Resolution rule " + rule + " is unable to honor forced versions " + dynamicVersions + ". For a force to take precedence on an align rule, it must use a static version");
            }
            if (!staticVersions.isEmpty()) {
                Object object2 = CollectionsKt.minWith((Iterable)((Iterable)staticVersions), comparator);
                if (object2 == null) {
                    Intrinsics.throwNpe();
                }
                String forcedVersion = (String)object2;
                this.logger.info("Found force(s) " + forced + " that supersede resolution rule " + rule + ". Will use " + forcedVersion + " instead of " + highestVersion);
                return forcedVersion;
            }
            this.logger.warn("No static forces found for rule " + rule + ". Falling back to default alignment logic");
        }
        return highestVersion;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String matchedVersion(@NotNull AlignRule rule, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)rule, (String)"rule");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        String match = rule.getMatch();
        if (match != null) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Collection $receiver$iv;
            Object[] objectArray = (Object[])VersionMatcher.values();
            void var6_5 = $receiver$iv;
            Collection collection = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void element$iv$iv = $receiver$iv$iv[i];
                VersionMatcher it = (VersionMatcher)element$iv$iv;
                if (!Intrinsics.areEqual((Object)it.name(), (Object)match)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            Pattern pattern = !$receiver$iv.isEmpty() ? VersionMatcher.valueOf(match).getPattern() : Pattern.compile(match);
            Matcher matcher = pattern.matcher(version);
            if (matcher.find()) {
                String string = matcher.group();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"matcher.group()");
                return string;
            }
            this.logger.warn("Resolution rule " + rule + " is unable to honor match. " + match + " does not match " + version + ". Will use " + version);
        }
        return version;
    }

    @NotNull
    public final List<AlignRule> getAligns() {
        return this.aligns;
    }

    public AlignRules(@NotNull List<AlignRule> aligns) {
        Intrinsics.checkParameterIsNotNull(aligns, (String)"aligns");
        this.aligns = aligns;
        Logger logger = Logging.getLogger(AlignRules.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(AlignRules::class.java)");
        this.logger = logger;
    }

    @NotNull
    public final List<AlignRule> component1() {
        return this.aligns;
    }

    @NotNull
    public final AlignRules copy(@NotNull List<AlignRule> aligns) {
        Intrinsics.checkParameterIsNotNull(aligns, (String)"aligns");
        return new AlignRules(aligns);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ AlignRules copy$default(AlignRules alignRules, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n & 1) != 0) {
            list = alignRules.aligns;
        }
        return alignRules.copy(list);
    }

    public String toString() {
        return "AlignRules(aligns=" + this.aligns + ")";
    }

    public int hashCode() {
        List<AlignRule> list = this.aligns;
        return list != null ? ((Object)list).hashCode() : 0;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof AlignRules)) break block3;
                AlignRules alignRules = (AlignRules)object;
                if (!Intrinsics.areEqual(this.aligns, alignRules.aligns)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lnebula/plugin/resolutionrules/AlignRules$VersionMatcher;", "", "regex", "", "(Ljava/lang/String;ILjava/lang/String;)V", "pattern", "Ljava/util/regex/Pattern;", "getPattern", "()Ljava/util/regex/Pattern;", "getRegex", "()Ljava/lang/String;", "EXCLUDE_SUFFIXES", "gradle-resolution-rules-plugin-compileKotlin"})
    public static final class VersionMatcher
    extends Enum<VersionMatcher> {
        public static final /* enum */ VersionMatcher EXCLUDE_SUFFIXES;
        private static final /* synthetic */ VersionMatcher[] $VALUES;
        @NotNull
        private final Pattern pattern;
        @NotNull
        private final String regex;

        static {
            VersionMatcher[] versionMatcherArray = new VersionMatcher[1];
            VersionMatcher[] versionMatcherArray2 = versionMatcherArray;
            versionMatcherArray[0] = EXCLUDE_SUFFIXES = new VersionMatcher("^(\\d+\\.)?(\\d+\\.)?(\\*|\\d+)");
            $VALUES = versionMatcherArray;
        }

        @NotNull
        public final Pattern getPattern() {
            return this.pattern;
        }

        @NotNull
        public final String getRegex() {
            return this.regex;
        }

        protected VersionMatcher(String regex) {
            Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
            String string = this.regex = regex;
            VersionMatcher versionMatcher = this;
            Regex regex2 = new Regex(string);
            versionMatcher.pattern = regex2.toPattern();
        }

        public static VersionMatcher[] values() {
            return (VersionMatcher[])$VALUES.clone();
        }

        public static VersionMatcher valueOf(String string) {
            return Enum.valueOf(VersionMatcher.class, string);
        }
    }
}

