/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.resolutionrules;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import nebula.plugin.resolutionrules.AlignRules;
import nebula.plugin.resolutionrules.BasicRule;
import nebula.plugin.resolutionrules.JsonKt;
import nebula.plugin.resolutionrules.NebulaResolutionRulesExtension;
import nebula.plugin.resolutionrules.ResolutionRulesPlugin;
import nebula.plugin.resolutionrules.RuleSet;
import nebula.plugin.resolutionrules.RulesKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 62\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020.J\u0016\u0010/\u001a\u00020!2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203J\u000e\u00104\u001a\u00020+2\u0006\u0010*\u001a\u00020+J\u0016\u00105\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0002X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\u00020!8F\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b\"\u0010#\u00a8\u00067"}, d2={"Lnebula/plugin/resolutionrules/ResolutionRulesPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "getConfiguration", "()Lorg/gradle/api/artifacts/Configuration;", "setConfiguration", "(Lorg/gradle/api/artifacts/Configuration;)V", "extension", "Lnebula/plugin/resolutionrules/NebulaResolutionRulesExtension;", "getExtension", "()Lnebula/plugin/resolutionrules/NebulaResolutionRulesExtension;", "setExtension", "(Lnebula/plugin/resolutionrules/NebulaResolutionRulesExtension;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/gradle/api/logging/Logger;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "setMapper", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "project", "getProject", "()Lorg/gradle/api/Project;", "setProject", "(Lorg/gradle/api/Project;)V", "ruleSet", "Lnebula/plugin/resolutionrules/RuleSet;", "getRuleSet", "()Lnebula/plugin/resolutionrules/RuleSet;", "ruleSet$delegate", "Lkotlin/Lazy;", "apply", "", "isIncludedRuleFile", "", "filename", "", "parseJsonFile", "file", "Ljava/io/File;", "parseJsonStream", "zip", "Ljava/util/zip/ZipFile;", "entry", "Ljava/util/zip/ZipEntry;", "ruleSetName", "rulesFromConfiguration", "Constants", "gradle-resolution-rules-plugin-compileKotlin"})
public final class ResolutionRulesPlugin
implements Plugin<Project> {
    private final Logger logger = Logging.getLogger(ResolutionRulesPlugin.class);
    @NotNull
    public Project project;
    @NotNull
    public Configuration configuration;
    @NotNull
    public NebulaResolutionRulesExtension extension;
    @NotNull
    public ObjectMapper mapper;
    @NotNull
    private final Lazy ruleSet$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RuleSet>(this){
        final /* synthetic */ ResolutionRulesPlugin this$0;

        @NotNull
        public final RuleSet invoke() {
            return this.this$0.rulesFromConfiguration(this.this$0.getConfiguration(), this.this$0.getExtension());
        }
        {
            this.this$0 = resolutionRulesPlugin;
            super(0);
        }
    }));
    @NotNull
    public static final String RESOLUTION_RULES_CONFIG_NAME = "resolutionRules";
    @NotNull
    public static final String SPRING_VERSION_MANAGEMENT_CONFIG_NAME = "versionManagement";
    @NotNull
    public static final String JSON_EXT = ".json";
    @NotNull
    public static final String JAR_EXT = ".jar";
    @NotNull
    public static final String ZIP_EXT = ".zip";
    @NotNull
    public static final String OPTIONAL_PREFIX = "optional-";
    private static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final Constants Constants = new Constants(null);

    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        return project;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @NotNull
    public final Configuration getConfiguration() {
        Configuration configuration = this.configuration;
        if (configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configuration");
        }
        return configuration;
    }

    public final void setConfiguration(@NotNull Configuration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"<set-?>");
        this.configuration = configuration;
    }

    @NotNull
    public final NebulaResolutionRulesExtension getExtension() {
        NebulaResolutionRulesExtension nebulaResolutionRulesExtension = this.extension;
        if (nebulaResolutionRulesExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extension");
        }
        return nebulaResolutionRulesExtension;
    }

    public final void setExtension(@NotNull NebulaResolutionRulesExtension nebulaResolutionRulesExtension) {
        Intrinsics.checkParameterIsNotNull((Object)nebulaResolutionRulesExtension, (String)"<set-?>");
        this.extension = nebulaResolutionRulesExtension;
    }

    @NotNull
    public final ObjectMapper getMapper() {
        ObjectMapper objectMapper = this.mapper;
        if (objectMapper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mapper");
        }
        return objectMapper;
    }

    public final void setMapper(@NotNull ObjectMapper objectMapper) {
        Intrinsics.checkParameterIsNotNull((Object)objectMapper, (String)"<set-?>");
        this.mapper = objectMapper;
    }

    @NotNull
    public final RuleSet getRuleSet() {
        Lazy lazy = this.ruleSet$delegate;
        ResolutionRulesPlugin resolutionRulesPlugin = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (RuleSet)lazy.getValue();
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        Object object = project.getConfigurations().create(RESOLUTION_RULES_CONFIG_NAME);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.configurations.c\u2026LUTION_RULES_CONFIG_NAME)");
        this.configuration = (Configuration)object;
        Object object2 = project.getExtensions().create("nebulaResolutionRules", NebulaResolutionRulesExtension.class, new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"project.extensions.creat\u2026lesExtension::class.java)");
        this.extension = (NebulaResolutionRulesExtension)object2;
        this.mapper = JsonKt.objectMapper();
        project.getConfigurations().all((Action)new Action<Configuration>(this, project){
            final /* synthetic */ ResolutionRulesPlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(Configuration config) {
                if (Intrinsics.areEqual((Object)config.getName(), (Object)ResolutionRulesPlugin.RESOLUTION_RULES_CONFIG_NAME) || Intrinsics.areEqual((Object)config.getName(), (Object)ResolutionRulesPlugin.SPRING_VERSION_MANAGEMENT_CONFIG_NAME)) {
                    return;
                }
                this.$project.afterEvaluate((Action)new Action<Project>(this, config){
                    final /* synthetic */ apply.1 this$0;
                    final /* synthetic */ Configuration $config;

                    public final void execute(Project it) {
                        if (Intrinsics.areEqual((Object)this.$config.getState(), (Object)Configuration.State.UNRESOLVED) ^ true) {
                            this.this$0.this$0.getLogger().warn("Configuration '{}' has been resolved. Dependency resolution rules will not be applied", (Object)this.$config.getName());
                        } else {
                            Iterable $receiver$iv = this.this$0.this$0.getRuleSet().afterEvaluateRules();
                            for (T element$iv : $receiver$iv) {
                                BasicRule rule = (BasicRule)element$iv;
                                Project project = this.this$0.$project;
                                Configuration configuration = this.$config;
                                Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"config");
                                ResolutionStrategy resolutionStrategy = this.$config.getResolutionStrategy();
                                Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStrategy, (String)"config.resolutionStrategy");
                                rule.apply(project, configuration, resolutionStrategy, this.this$0.this$0.getExtension());
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$config = configuration;
                    }
                });
                config.getIncoming().beforeResolve((Action)new Action<ResolvableDependencies>(this, config){
                    final /* synthetic */ apply.1 this$0;
                    final /* synthetic */ Configuration $config;

                    public final void execute(ResolvableDependencies it) {
                        Iterable $receiver$iv = this.this$0.this$0.getRuleSet().beforeResolveRules();
                        for (T element$iv : $receiver$iv) {
                            AlignRules rule = (AlignRules)element$iv;
                            Project project = this.this$0.$project;
                            Configuration configuration = this.$config;
                            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"config");
                            ResolutionStrategy resolutionStrategy = this.$config.getResolutionStrategy();
                            Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStrategy, (String)"config.resolutionStrategy");
                            rule.apply(project, configuration, resolutionStrategy, this.this$0.this$0.getExtension());
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$config = configuration;
                    }
                });
            }
            {
                this.this$0 = resolutionRulesPlugin;
                this.$project = project;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RuleSet rulesFromConfiguration(@NotNull Configuration configuration, @NotNull NebulaResolutionRulesExtension extension) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        ArrayList<RuleSet> rules = new ArrayList<RuleSet>();
        Set files = configuration.resolve();
        if (files.isEmpty()) {
            this.logger.warn("No resolution rules have been added to the '{}' configuration", (Object)configuration.getName());
        }
        for (File file : files) {
            String string = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
            if (this.isIncludedRuleFile(string, extension)) {
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                rules.add(this.parseJsonFile(file2));
                continue;
            }
            if (StringsKt.endsWith$default((String)file.getName(), (String)JAR_EXT, (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)file.getName(), (String)ZIP_EXT, (boolean)false, (int)2, null)) {
                ZipFile zip = new ZipFile(file);
                try {
                    Enumeration<? extends ZipEntry> entries = zip.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        String string2 = entry.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"entry.name");
                        if (!this.isIncludedRuleFile(string2, extension)) continue;
                        ZipEntry zipEntry = entry;
                        Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry, (String)"entry");
                        rules.add(this.parseJsonStream(zip, zipEntry));
                    }
                    continue;
                }
                finally {
                    zip.close();
                    continue;
                }
            }
            this.logger.debug("Unsupported rules file extension for " + file);
        }
        return RulesKt.flatten((List<RuleSet>)rules);
    }

    public final boolean isIncludedRuleFile(@NotNull String filename, @NotNull NebulaResolutionRulesExtension extension) {
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        if (StringsKt.endsWith$default((String)filename, (String)JSON_EXT, (boolean)false, (int)2, null)) {
            String ruleSet2 = this.ruleSetName(filename);
            if (StringsKt.startsWith$default((String)ruleSet2, (String)OPTIONAL_PREFIX, (boolean)false, (int)2, null)) {
                String string = ruleSet2;
                int n = OPTIONAL_PREFIX.length();
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                String ruleSetWithoutPrefix = string3;
                return extension.getOptional().contains(ruleSetWithoutPrefix);
            }
            if (!extension.getInclude().isEmpty()) {
                return extension.getInclude().contains(ruleSet2);
            }
            return !extension.getExclude().contains(ruleSet2);
        }
        return false;
    }

    @NotNull
    public final String ruleSetName(@NotNull String filename) {
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        String string = filename;
        int n = 0;
        int n2 = StringsKt.lastIndexOf$default((CharSequence)filename, (String)JSON_EXT, (int)0, (boolean)false, (int)6, null);
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @NotNull
    public final RuleSet parseJsonFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
        String ruleSetName = this.ruleSetName(string);
        this.logger.info("Using " + ruleSetName + " (" + file.getName() + ") a dependency rules source");
        ObjectMapper objectMapper = this.mapper;
        if (objectMapper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mapper");
        }
        ObjectMapper $receiver$iv = objectMapper;
        Object object = $receiver$iv.readValue(file, (TypeReference)new TypeReference<RuleSet>(){});
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"readValue(src, object: TypeReference<T>() {})");
        return RulesKt.withName((RuleSet)object, ruleSetName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RuleSet parseJsonStream(@NotNull ZipFile zip, @NotNull ZipEntry entry) {
        void src$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)zip, (String)"zip");
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        String string = new File(entry.getName()).getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File(entry.name).name");
        String ruleSetName = this.ruleSetName(string);
        this.logger.info("Using " + ruleSetName + " (" + zip.getName() + ") a dependency rules source");
        ObjectMapper objectMapper = this.mapper;
        if (objectMapper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mapper");
        }
        ObjectMapper objectMapper2 = objectMapper;
        InputStream inputStream = zip.getInputStream(entry);
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"zip.getInputStream(entry)");
        InputStream inputStream2 = inputStream;
        Object object = $receiver$iv.readValue((InputStream)src$iv, (TypeReference)new TypeReference<RuleSet>(){});
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"readValue(src, object: TypeReference<T>() {})");
        return RulesKt.withName((RuleSet)object, ruleSetName);
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ResolutionRulesPlugin.class), "ruleSet", "getRuleSet()Lnebula/plugin/resolutionrules/RuleSet;"))};
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnebula/plugin/resolutionrules/ResolutionRulesPlugin$Constants;", "", "()V", "JAR_EXT", "", "JSON_EXT", "OPTIONAL_PREFIX", "RESOLUTION_RULES_CONFIG_NAME", "SPRING_VERSION_MANAGEMENT_CONFIG_NAME", "ZIP_EXT", "gradle-resolution-rules-plugin-compileKotlin"})
    public static final class Constants {
        private Constants() {
        }

        public /* synthetic */ Constants(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

