/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import netflix.nebula.dependency.recommender.provider.RecommendationProviderContainer;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.DependencyConstraintSet;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.configurations.DefaultConfiguration;
import org.gradle.api.internal.artifacts.dependencies.DependencyConstraintInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class ExtendRecommenderConfigurationAction
implements Action<Configuration> {
    private Logger logger = Logging.getLogger(ExtendRecommenderConfigurationAction.class);
    private final Configuration bom;
    private final Project project;
    private final RecommendationProviderContainer container;
    private final AtomicInteger copyCount = new AtomicInteger();

    public ExtendRecommenderConfigurationAction(Configuration bom, Project project, RecommendationProviderContainer container) {
        this.bom = bom;
        this.project = project;
        this.container = container;
    }

    public void execute(Configuration configuration) {
        if (!this.isClasspathConfiguration(configuration) || this.container.getExcludedConfigurations().contains(configuration.getName()) || this.isCopyOfBomConfiguration(configuration)) {
            return;
        }
        if (configuration.getState() == Configuration.State.UNRESOLVED) {
            Configuration toExtend = this.bom;
            if (!this.project.getRootProject().equals(this.project)) {
                toExtend = this.createCopy((Set<Dependency>)this.bom.getDependencies(), (Set<DependencyConstraint>)this.bom.getDependencyConstraints());
                this.project.getConfigurations().add((Object)toExtend);
            }
            configuration.extendsFrom(new Configuration[]{toExtend});
        } else {
            this.logger.info("Configuration '" + configuration.getName() + "' has already been resolved and cannot be included for recommendation");
        }
    }

    private DefaultConfiguration createCopy(Set<Dependency> dependencies, Set<DependencyConstraint> dependencyConstraints) {
        DefaultConfiguration copiedConfiguration = (DefaultConfiguration)this.project.getConfigurations().create(this.getNameWithCopySuffix());
        copiedConfiguration.setVisible(false);
        copiedConfiguration.setCanBeResolved(false);
        copiedConfiguration.setCanBeConsumed(this.bom.isCanBeConsumed());
        copiedConfiguration.setTransitive(this.bom.isTransitive());
        copiedConfiguration.setDescription(this.bom.getDescription());
        copiedConfiguration.getArtifacts().addAll((Collection)this.bom.getAllArtifacts());
        for (Object excludeRule : this.bom.getExcludeRules()) {
            copiedConfiguration.getExcludeRules().add(new DefaultExcludeRule(excludeRule.getGroup(), excludeRule.getModule()));
        }
        DependencySet copiedDependencies = copiedConfiguration.getDependencies();
        for (Dependency dependency : dependencies) {
            copiedDependencies.add((Object)dependency.copy());
        }
        DependencyConstraintSet copiedDependencyConstraints = copiedConfiguration.getDependencyConstraints();
        for (DependencyConstraint dependencyConstraint : dependencyConstraints) {
            copiedDependencyConstraints.add((Object)((DependencyConstraintInternal)dependencyConstraint).copy());
        }
        return copiedConfiguration;
    }

    private String getNameWithCopySuffix() {
        int count = this.copyCount.incrementAndGet();
        String copyName = this.bom.getName() + "Copy";
        return count == 1 ? copyName : copyName + count;
    }

    private boolean isClasspathConfiguration(Configuration configuration) {
        return configuration.getName().endsWith("Classpath") || configuration.getName().toLowerCase().endsWith("annotationprocessor");
    }

    private boolean isCopyOfBomConfiguration(Configuration configuration) {
        return configuration.getName().startsWith(this.bom.getName());
    }
}

