/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender;

import com.netflix.nebula.interop.ConfigurationsKt;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import netflix.nebula.dependency.recommender.ExtendRecommenderConfigurationAction;
import netflix.nebula.dependency.recommender.RecommendationStrategy;
import netflix.nebula.dependency.recommender.RecommendationStrategyFactory;
import netflix.nebula.dependency.recommender.RecommendationsConflictResolvedStrategy;
import netflix.nebula.dependency.recommender.RecommendationsOverrideTransitivesStrategy;
import netflix.nebula.dependency.recommender.provider.RecommendationProviderContainer;
import netflix.nebula.dependency.recommender.provider.RecommendationResolver;
import netflix.nebula.dependency.recommender.publisher.MavenBomXmlGenerator;
import netflix.nebula.dependency.recommender.util.BomResolutionUtil;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.runtime.MethodClosure;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.util.GradleVersion;

public class DependencyRecommendationsPlugin
implements Plugin<Project> {
    public static final String NEBULA_RECOMMENDER_BOM = "nebulaRecommenderBom";
    public static final boolean CORE_BOM_SUPPORT_ENABLED = Boolean.getBoolean("nebula.features.coreBomSupport");
    private static final GradleVersion GRADLE_9_0 = GradleVersion.version((String)"9.0");
    private Logger logger = Logging.getLogger(DependencyRecommendationsPlugin.class);
    private RecommendationProviderContainer recommendationProviderContainer;
    private final String SCALA_ANALYSIS_CONFIGURATION_PREFIX = "incrementalScalaAnalysis";

    public void apply(Project project) {
        Configuration bomConfiguration = (Configuration)project.getConfigurations().create(NEBULA_RECOMMENDER_BOM);
        this.recommendationProviderContainer = (RecommendationProviderContainer)project.getExtensions().create("dependencyRecommendations", RecommendationProviderContainer.class, new Object[]{project});
        if (CORE_BOM_SUPPORT_ENABLED) {
            this.logger.info(project.getName() + ":coreBomSupport feature enabled");
            this.recommendationProviderContainer.excludeConfigurations("archives", NEBULA_RECOMMENDER_BOM, "provided", "versionManagement", "resolutionRules", "bootArchives", "webapp", "checkstyle", "jacocoAgent", "jacocoAnt", "pmd", "cobertura", "zinc");
            this.recommendationProviderContainer.excludeConfigurationPrefixes("incrementalScalaAnalysis", "spotbugs", "findbugs");
            this.applyRecommendationsDirectly(project, bomConfiguration);
        } else {
            this.recommendationProviderContainer.excludeConfigurations("zinc", "checkstyle", "jacocoAgent", "jacocoAnt");
            this.recommendationProviderContainer.excludeConfigurationPrefixes("incrementalScalaAnalysis", "spotbugs", "findbugs");
            this.applyRecommendations(project);
            this.enhanceDependenciesWithRecommender(project);
        }
        this.enhancePublicationsWithBomProducer(project);
    }

    private void applyRecommendationsDirectly(Project project, final Configuration bomConfiguration) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project p) {
                if (DependencyRecommendationsPlugin.this.shouldUseBuildService(p) && BomResolutionUtil.shouldEagerlyResolveBoms(p, DependencyRecommendationsPlugin.this.recommendationProviderContainer)) {
                    BomResolutionUtil.eagerlyResolveBoms(p, DependencyRecommendationsPlugin.this.recommendationProviderContainer, DependencyRecommendationsPlugin.NEBULA_RECOMMENDER_BOM);
                }
                p.getConfigurations().all((Action)new ExtendRecommenderConfigurationAction(bomConfiguration, p, DependencyRecommendationsPlugin.this.recommendationProviderContainer));
                p.subprojects((Action)new Action<Project>(){

                    public void execute(Project sub) {
                        if (DependencyRecommendationsPlugin.this.shouldUseBuildService(sub) && BomResolutionUtil.shouldEagerlyResolveBoms(sub, DependencyRecommendationsPlugin.this.recommendationProviderContainer)) {
                            BomResolutionUtil.eagerlyResolveBoms(sub, DependencyRecommendationsPlugin.this.recommendationProviderContainer, DependencyRecommendationsPlugin.NEBULA_RECOMMENDER_BOM);
                        }
                        sub.getConfigurations().all((Action)new ExtendRecommenderConfigurationAction(bomConfiguration, sub, DependencyRecommendationsPlugin.this.recommendationProviderContainer));
                    }
                });
            }
        });
    }

    private void applyRecommendations(final Project project) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project p) {
                if (DependencyRecommendationsPlugin.this.shouldUseBuildService(p) && BomResolutionUtil.shouldEagerlyResolveBoms(p, DependencyRecommendationsPlugin.this.recommendationProviderContainer)) {
                    BomResolutionUtil.eagerlyResolveBoms(p, DependencyRecommendationsPlugin.this.recommendationProviderContainer, DependencyRecommendationsPlugin.NEBULA_RECOMMENDER_BOM);
                }
            }
        });
        project.getConfigurations().all((Action)new Action<Configuration>(){

            public void execute(final Configuration conf) {
                final RecommendationStrategyFactory rsFactory = new RecommendationStrategyFactory(project);
                if (conf.getState() == Configuration.State.UNRESOLVED) {
                    ConfigurationsKt.onResolve((Configuration)conf, (Function1)new Function1<ResolvableDependencies, Unit>(){

                        public Unit invoke(ResolvableDependencies resolvableDependencies) {
                            boolean isExcluded = DependencyRecommendationsPlugin.this.isExcludedConfiguration(conf.getName());
                            if (isExcluded) {
                                return Unit.INSTANCE;
                            }
                            for (Dependency dependency : resolvableDependencies.getDependencies()) {
                                DependencyRecommendationsPlugin.this.applyRecommendationToDependency(rsFactory, dependency, new ArrayList(), project);
                            }
                            conf.getResolutionStrategy().eachDependency((Action)new Action<DependencyResolveDetails>(){

                                public void execute(DependencyResolveDetails details) {
                                    ModuleVersionSelector requested = details.getTarget();
                                    for (ModuleVersionSelector force : conf.getResolutionStrategy().getForcedModules()) {
                                        if (!requested.getGroup().equals(force.getGroup()) || !requested.getName().equals(force.getName())) continue;
                                        details.because("Would have recommended a version for " + requested.getGroup() + ":" + requested.getName() + ", but a force is in place");
                                        return;
                                    }
                                    RecommendationStrategy strategy = rsFactory.getRecommendationStrategy();
                                    if (strategy.canRecommendVersion(requested)) {
                                        String version = DependencyRecommendationsPlugin.this.getRecommendedVersionRecursive(project, requested);
                                        if (strategy.recommendVersion(details, version)) {
                                            String coordinate = requested.getGroup() + ":" + requested.getName();
                                            String strategyText = DependencyRecommendationsPlugin.this.whichStrategy(strategy);
                                            DependencyRecommendationsPlugin.this.logger.debug("Recommending version " + version + " for dependency " + coordinate);
                                            details.because("Recommending version " + version + " for dependency " + coordinate + " via " + strategyText + "\n\twith reasons: " + StringUtils.join(DependencyRecommendationsPlugin.this.getReasonsRecursive(project), (String)", "));
                                        } else if (DependencyRecommendationsPlugin.this.recommendationProviderContainer.getStrictMode().booleanValue()) {
                                            String errorMessage = "Dependency " + details.getRequested().getGroup() + ":" + details.getRequested().getName() + " omitted version with no recommended version. General causes include a dependency being removed from the recommendation source or not applying a recommendation source to a project that depends on another project using a recommender.";
                                            project.getLogger().error(errorMessage);
                                            throw new GradleException(errorMessage);
                                        }
                                    }
                                }
                            });
                            return Unit.INSTANCE;
                        }
                    });
                }
            }
        });
    }

    private boolean isExcludedConfiguration(String confName) {
        if (this.recommendationProviderContainer.getExcludedConfigurations().contains(confName)) {
            return true;
        }
        for (String prefix : this.recommendationProviderContainer.getExcludedConfigurationPrefixes()) {
            if (!confName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private void applyRecommendationToDependency(RecommendationStrategyFactory factory, Dependency dependency, List<ProjectDependency> visited, Project rootProject) {
        ProjectDependency projectDependency;
        if (dependency instanceof ExternalModuleDependency) {
            factory.getRecommendationStrategy().inspectDependency(dependency);
        } else if (dependency instanceof ProjectDependency && !visited.contains(projectDependency = (ProjectDependency)dependency)) {
            visited.add(projectDependency);
            Configuration[] configuration = new Configuration[1];
            try {
                ProjectDependency.class.getMethod("getTargetConfiguration", new Class[0]);
                String targetConfiguration = projectDependency.getTargetConfiguration() == null ? "default" : projectDependency.getTargetConfiguration();
                Project dependencyProject = rootProject.findProject(projectDependency.getPath());
                if (dependencyProject != null) {
                    configuration[0] = dependencyProject.getConfigurations().getByName(targetConfiguration);
                }
            }
            catch (NoSuchMethodException ignore) {
                try {
                    Method method = ProjectDependency.class.getMethod("getProjectConfiguration", new Class[0]);
                    configuration[0] = (Configuration)method.invoke((Object)dependency, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to retrieve configuration for project dependency", e);
                }
            }
            if (configuration[0] != null) {
                DependencySet dependencies = configuration[0].getAllDependencies();
                for (Dependency dep : dependencies) {
                    this.applyRecommendationToDependency(factory, dep, visited, rootProject);
                }
            }
        }
    }

    protected String whichStrategy(RecommendationStrategy strategy) {
        if (strategy instanceof RecommendationsConflictResolvedStrategy) {
            return "conflict resolution recommendation";
        }
        if (strategy instanceof RecommendationsOverrideTransitivesStrategy) {
            return "override transitive recommendation";
        }
        return "nebula.dependency-recommender";
    }

    protected void enhanceDependenciesWithRecommender(Project project) {
        RecommendationResolver resolver = new RecommendationResolver(project);
        ((ExtraPropertiesExtension)Objects.requireNonNull(project.getExtensions().findByType(ExtraPropertiesExtension.class))).set("recommend", (Object)new MethodClosure((Object)resolver, "recommend"));
    }

    protected void enhancePublicationsWithBomProducer(Project project) {
        project.getExtensions().create("nebulaDependencyManagement", MavenBomXmlGenerator.class, new Object[]{project});
    }

    public String getRecommendedVersionRecursive(Project project, ModuleVersionSelector mvSelector) {
        String version = ((RecommendationProviderContainer)Objects.requireNonNull(project.getExtensions().findByType(RecommendationProviderContainer.class))).getRecommendedVersion(mvSelector.getGroup(), mvSelector.getName());
        if (version != null) {
            return version;
        }
        if (project.getParent() != null) {
            return this.getRecommendedVersionRecursive(project.getParent(), mvSelector);
        }
        return null;
    }

    public Set<String> getReasonsRecursive(Project project) {
        Set<String> reasons = ((RecommendationProviderContainer)Objects.requireNonNull(project.getExtensions().findByType(RecommendationProviderContainer.class))).getReasons();
        if (!reasons.isEmpty()) {
            return reasons;
        }
        if (project.getParent() != null) {
            return this.getReasonsRecursive(project.getParent());
        }
        return Collections.emptySet();
    }

    private boolean shouldUseBuildService(Project project) {
        Object property;
        if (project.hasProperty("nebula.dependency-recommender.useBuildService") && Boolean.parseBoolean((property = project.property("nebula.dependency-recommender.useBuildService")).toString())) {
            return true;
        }
        GradleVersion currentVersion = GradleVersion.current();
        return currentVersion.compareTo(GRADLE_9_0) >= 0;
    }

    public void eagerlyResolveBoms(Project project, RecommendationProviderContainer container) {
        BomResolutionUtil.eagerlyResolveBoms(project, container, NEBULA_RECOMMENDER_BOM);
    }
}

