/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender.provider;

import java.io.File;
import java.util.Map;
import java.util.Set;
import netflix.nebula.dependency.recommender.provider.AbstractRecommendationProvider;
import netflix.nebula.dependency.recommender.service.BomResolverService;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.provider.Provider;
import org.gradle.util.GradleVersion;

public abstract class ClasspathBasedRecommendationProvider
extends AbstractRecommendationProvider {
    protected Project project;
    protected Configuration configuration;
    protected String configName;
    protected Provider<BomResolverService> bomResolverService;
    private static final GradleVersion GRADLE_9_0 = GradleVersion.version((String)"9.0");

    ClasspathBasedRecommendationProvider(Project project, String configName) {
        this.project = project;
        this.configName = configName;
        this.configuration = project.getConfigurations().getByName(configName);
        if (this.shouldUseBuildService()) {
            this.bomResolverService = project.getGradle().getSharedServices().registerIfAbsent("bomResolver", BomResolverService.class, spec -> {});
        }
    }

    Set<File> getFilesOnConfiguration() {
        return this.configuration.resolve();
    }

    protected Map<String, String> getBomRecommendations(Set<String> reasons) {
        if (this.bomResolverService == null) {
            throw new RuntimeException("BomResolverService not available - build service approach not enabled");
        }
        return ((BomResolverService)this.bomResolverService.get()).getRecommendations(this.project, this.configName, reasons);
    }

    private boolean shouldUseBuildService() {
        Object property;
        if (this.project.hasProperty("nebula.dependency-recommender.useBuildService") && Boolean.parseBoolean((property = this.project.property("nebula.dependency-recommender.useBuildService")).toString())) {
            return true;
        }
        GradleVersion currentVersion = GradleVersion.current();
        return currentVersion.compareTo(GRADLE_9_0) >= 0;
    }
}

