/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.ModelSource2;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.interpolation.StringSearchModelInterpolator;
import org.apache.maven.model.path.DefaultPathTranslator;
import org.apache.maven.model.path.DefaultUrlNormalizer;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.path.UrlNormalizer;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.ValueSource;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;

public abstract class BomResolverService
implements BuildService<BuildServiceParameters.None> {
    private final ConcurrentHashMap<String, Map<String, String>> bomRecommendations = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<String>> bomReasons = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Object> locks = new ConcurrentHashMap();

    public Map<String, String> getRecommendations(Project project, String configName, Set<String> reasons) {
        Configuration configuration = project.getConfigurations().getByName(configName);
        return this.getCachedRecommendationsFromConfiguration(configuration, reasons);
    }

    public Map<String, String> getCachedRecommendationsFromConfiguration(Configuration configuration, Set<String> reasons) {
        String bomKey = this.createBomKeyFromConfiguration(configuration);
        Map<String, String> cached = this.bomRecommendations.get(bomKey);
        if (cached != null) {
            Set<String> cachedReasons = this.bomReasons.get(bomKey);
            if (cachedReasons != null) {
                reasons.addAll(cachedReasons);
            }
            return cached;
        }
        throw new RuntimeException("BOM not cached and no project context available for resolution");
    }

    public void eagerlyResolveAndCacheBoms(Project project, String configName) {
        try {
            Configuration configuration = project.getConfigurations().getByName(configName);
            HashSet<String> reasons = new HashSet<String>();
            this.getRecommendationsFromConfiguration(configuration, project, reasons);
        }
        catch (Exception e) {
            String bomKey = this.createBomKey(project, configName);
            this.bomRecommendations.put(bomKey, new HashMap());
            this.bomReasons.put(bomKey, new HashSet());
        }
    }

    public Map<String, String> getRecommendationsFromConfiguration(Configuration configuration, Project project, Set<String> reasons) {
        String bomKey = this.createBomKeyFromConfiguration(configuration);
        Object lock = this.locks.computeIfAbsent(bomKey, k -> new Object());
        Map<String, String> cached = this.bomRecommendations.get(bomKey);
        if (cached != null) {
            Set<String> cachedReasons = this.bomReasons.get(bomKey);
            if (cachedReasons != null) {
                reasons.addAll(cachedReasons);
            }
            return cached;
        }
        Object object = lock;
        synchronized (object) {
            cached = this.bomRecommendations.get(bomKey);
            if (cached != null) {
                Set<String> cachedReasons = this.bomReasons.get(bomKey);
                if (cachedReasons != null) {
                    reasons.addAll(cachedReasons);
                }
                return cached;
            }
            try {
                HashMap<String, String> recommendations = new HashMap<String, String>();
                HashSet<String> currentReasons = new HashSet<String>();
                Set bomFiles = configuration.resolve();
                for (File bomFile : bomFiles) {
                    if (!bomFile.getName().endsWith("pom")) continue;
                    Map<String, String> bomRecommendations = this.parseBom(bomFile, project, currentReasons);
                    recommendations.putAll(bomRecommendations);
                }
                this.bomRecommendations.put(bomKey, recommendations);
                this.bomReasons.put(bomKey, currentReasons);
                reasons.addAll(currentReasons);
                return recommendations;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String createBomKey(Project project, String configName) {
        try {
            Configuration configuration = project.getConfigurations().getByName(configName);
            return this.createBomKeyFromConfiguration(configuration);
        }
        catch (Exception e) {
            return project.getPath() + ":" + configName;
        }
    }

    private String createBomKeyFromConfiguration(Configuration configuration) {
        StringBuilder keyBuilder = new StringBuilder();
        configuration.getAllDependencies().forEach(dep -> keyBuilder.append(dep.getGroup()).append(":").append(dep.getName()).append(":").append(dep.getVersion()).append(";"));
        return keyBuilder.toString();
    }

    private Map<String, String> parseBom(File bomFile, Project project, Set<String> reasons) throws Exception {
        HashMap<String, String> recommendations = new HashMap<String, String>();
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
        request.setModelResolver((ModelResolver)new ProjectModelResolver(project));
        request.setModelSource((ModelSource)new SimpleModelSource(new FileInputStream(bomFile)));
        request.setSystemProperties(System.getProperties());
        DefaultModelBuilder modelBuilder = new DefaultModelBuilderFactory().newInstance();
        modelBuilder.setModelInterpolator((ModelInterpolator)new ProjectPropertiesModelInterpolator(project));
        ModelBuildingResult result = modelBuilder.build((ModelBuildingRequest)request);
        reasons.add("nebula.dependency-recommender uses mavenBom: " + result.getEffectiveModel().getId());
        Model model = result.getEffectiveModel();
        if (model != null && model.getDependencyManagement() != null) {
            for (org.apache.maven.model.Dependency d : model.getDependencyManagement().getDependencies()) {
                recommendations.put(d.getGroupId() + ":" + d.getArtifactId(), d.getVersion());
            }
        }
        return recommendations;
    }

    private static class ProjectPropertiesModelInterpolator
    extends StringSearchModelInterpolator {
        private final Project project;

        ProjectPropertiesModelInterpolator(Project project) {
            this.project = project;
            this.setUrlNormalizer((UrlNormalizer)new DefaultUrlNormalizer());
            this.setPathTranslator((PathTranslator)new DefaultPathTranslator());
        }

        public List<ValueSource> createValueSources(Model model, File projectDir, ModelBuildingRequest request, ModelProblemCollector collector) {
            ArrayList<ValueSource> sources = new ArrayList<ValueSource>();
            sources.addAll(super.createValueSources(model, projectDir, request, collector));
            sources.add((ValueSource)new PropertiesBasedValueSource(System.getProperties()));
            sources.add((ValueSource)new MapBasedValueSource(this.project.getProperties()));
            return sources;
        }
    }

    private static class ProjectModelResolver
    implements ModelResolver {
        private final Project project;

        public ProjectModelResolver(Project project) {
            this.project = project;
        }

        public ModelSource2 resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
            String notation = groupId + ":" + artifactId + ":" + version + "@pom";
            Dependency dependency = this.project.getDependencies().create((Object)notation);
            Configuration configuration = this.project.getConfigurations().detachedConfiguration(new Dependency[]{dependency});
            try {
                File file = (File)configuration.getFiles().iterator().next();
                return new SimpleModelSource(new FileInputStream(file));
            }
            catch (Exception e) {
                throw new UnresolvableModelException((Throwable)e, groupId, artifactId, version);
            }
        }

        public ModelSource2 resolveModel(org.apache.maven.model.Dependency dependency) throws UnresolvableModelException {
            return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
        }

        public ModelSource2 resolveModel(Parent parent) throws UnresolvableModelException {
            return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
        }

        public void addRepository(Repository repository) throws InvalidRepositoryException {
        }

        public void addRepository(Repository repository, boolean bool) throws InvalidRepositoryException {
        }

        public ModelResolver newCopy() {
            return this;
        }
    }

    private static class SimpleModelSource
    implements ModelSource2 {
        InputStream in;

        public SimpleModelSource(InputStream in) {
            this.in = in;
        }

        public InputStream getInputStream() throws IOException {
            return this.in;
        }

        public String getLocation() {
            return null;
        }

        public ModelSource2 getRelatedSource(String relPath) {
            return null;
        }

        public URI getLocationURI() {
            return null;
        }
    }
}

