/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender.provider;

import java.util.Map;
import java.util.Set;
import netflix.nebula.dependency.recommender.provider.AbstractRecommendationProvider;
import netflix.nebula.dependency.recommender.service.BomResolverService;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.provider.Provider;

public abstract class ClasspathBasedRecommendationProvider
extends AbstractRecommendationProvider {
    protected Project project;
    protected Configuration configuration;
    protected String configName;
    protected Provider<BomResolverService> bomResolverService;

    ClasspathBasedRecommendationProvider(Project project, String configName) {
        this.project = project;
        this.configName = configName;
        this.configuration = project.getConfigurations().getByName(configName);
        this.bomResolverService = project.getGradle().getSharedServices().registerIfAbsent("bomResolver", BomResolverService.class, spec -> {});
    }

    protected Map<String, String> getBomRecommendations(Set<String> reasons) {
        return ((BomResolverService)this.bomResolverService.get()).getRecommendations(this.project, this.configName, reasons);
    }
}

