/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import netflix.nebula.dependency.recommender.provider.ClasspathBasedRecommendationProvider;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.ModelSource2;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.interpolation.StringSearchModelInterpolator;
import org.apache.maven.model.path.DefaultPathTranslator;
import org.apache.maven.model.path.DefaultUrlNormalizer;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.path.UrlNormalizer;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.ValueSource;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;

public class MavenBomRecommendationProvider
extends ClasspathBasedRecommendationProvider {
    private volatile Map<String, String> recommendations = null;
    private Set<String> reasons = new HashSet<String>();

    public MavenBomRecommendationProvider(Project project, String configName) {
        super(project, configName);
    }

    public MavenBomRecommendationProvider(Project project, String configName, Set<String> reasons) {
        super(project, configName);
        this.reasons = reasons;
    }

    @Override
    public String getVersion(String org, String name) throws Exception {
        return this.getRecommendations().get(org + ":" + name);
    }

    public Map<String, String> getRecommendations() {
        if (this.recommendations == null) {
            try {
                this.recommendations = this.getBomRecommendations(this.reasons);
            }
            catch (Exception e) {
                try {
                    this.recommendations = this.getMavenRecommendationsDirectly();
                }
                catch (Exception fallbackException) {
                    this.recommendations = new HashMap<String, String>();
                }
            }
        }
        return this.recommendations;
    }

    private Map<String, String> getMavenRecommendationsDirectly() {
        HashMap<String, String> recommendations = new HashMap<String, String>();
        try {
            Set recommendationFiles = this.configuration.resolve();
            for (File recommendation : recommendationFiles) {
                if (!recommendation.getName().endsWith("pom")) continue;
                DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
                request.setModelResolver((ModelResolver)new SimpleModelResolver());
                request.setModelSource((ModelSource)new SimpleModelSource(new FileInputStream(recommendation)));
                request.setSystemProperties(System.getProperties());
                DefaultModelBuilder modelBuilder = new DefaultModelBuilderFactory().newInstance();
                if (this.project != null) {
                    modelBuilder.setModelInterpolator((ModelInterpolator)new ProjectPropertiesModelInterpolator());
                }
                ModelBuildingResult result = modelBuilder.build((ModelBuildingRequest)request);
                this.reasons.add("nebula.dependency-recommender uses mavenBom: " + result.getEffectiveModel().getId());
                Model model = result.getEffectiveModel();
                if (model == null || model.getDependencyManagement() == null) continue;
                for (org.apache.maven.model.Dependency d : model.getDependencyManagement().getDependencies()) {
                    recommendations.put(d.getGroupId() + ":" + d.getArtifactId(), d.getVersion());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return recommendations;
    }

    private class SimpleModelResolver
    implements ModelResolver {
        private SimpleModelResolver() {
        }

        public ModelSource2 resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
            try {
                String notation = groupId + ":" + artifactId + ":" + version + "@pom";
                Dependency dependency = MavenBomRecommendationProvider.this.project.getDependencies().create((Object)notation);
                Configuration configuration = MavenBomRecommendationProvider.this.project.getConfigurations().detachedConfiguration(new Dependency[]{dependency});
                File file = (File)configuration.getFiles().iterator().next();
                return new SimpleModelSource(new FileInputStream(file));
            }
            catch (Exception e) {
                throw new UnresolvableModelException((Throwable)e, groupId, artifactId, version);
            }
        }

        public ModelSource2 resolveModel(org.apache.maven.model.Dependency dependency) throws UnresolvableModelException {
            return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
        }

        public ModelSource2 resolveModel(Parent parent) throws UnresolvableModelException {
            return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
        }

        public void addRepository(Repository repository) throws InvalidRepositoryException {
        }

        public void addRepository(Repository repository, boolean bool) throws InvalidRepositoryException {
        }

        public ModelResolver newCopy() {
            return this;
        }
    }

    private static class SimpleModelSource
    implements ModelSource2 {
        InputStream in;

        public SimpleModelSource(InputStream in) {
            this.in = in;
        }

        public InputStream getInputStream() throws IOException {
            return this.in;
        }

        public String getLocation() {
            return null;
        }

        public ModelSource2 getRelatedSource(String relPath) {
            return null;
        }

        public URI getLocationURI() {
            return null;
        }
    }

    private class ProjectPropertiesModelInterpolator
    extends StringSearchModelInterpolator {
        ProjectPropertiesModelInterpolator() {
            this.setUrlNormalizer((UrlNormalizer)new DefaultUrlNormalizer());
            this.setPathTranslator((PathTranslator)new DefaultPathTranslator());
        }

        public List<ValueSource> createValueSources(Model model, File projectDir, ModelBuildingRequest request, ModelProblemCollector collector) {
            ArrayList<ValueSource> sources = new ArrayList<ValueSource>();
            sources.addAll(super.createValueSources(model, projectDir, request, collector));
            sources.add((ValueSource)new PropertiesBasedValueSource(System.getProperties()));
            if (MavenBomRecommendationProvider.this.project != null) {
                sources.add((ValueSource)new MapBasedValueSource(MavenBomRecommendationProvider.this.project.getProperties()));
            }
            return sources;
        }
    }
}

