/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender.provider;

import groovy.lang.Closure;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import netflix.nebula.dependency.recommender.ConfigureUtil;
import netflix.nebula.dependency.recommender.DependencyRecommendationsPlugin;
import netflix.nebula.dependency.recommender.RecommendationStrategies;
import netflix.nebula.dependency.recommender.provider.CustomRecommendationProvider;
import netflix.nebula.dependency.recommender.provider.DependencyLockProvider;
import netflix.nebula.dependency.recommender.provider.IvyRecommendationProvider;
import netflix.nebula.dependency.recommender.provider.MapRecommendationProvider;
import netflix.nebula.dependency.recommender.provider.MavenBomRecommendationProvider;
import netflix.nebula.dependency.recommender.provider.PropertyFileRecommendationProvider;
import netflix.nebula.dependency.recommender.provider.RecommendationProvider;
import netflix.nebula.dependency.recommender.service.BomResolverService;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.Namer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.internal.ConfigureByMapAction;
import org.gradle.api.model.ObjectFactory;

public class RecommendationProviderContainer {
    private Project project;
    private NamedDomainObjectList<RecommendationProvider> providers;
    private RecommendationStrategies strategy = RecommendationStrategies.ConflictResolved;
    private MavenBomRecommendationProvider mavenBomProvider;
    private Boolean strictMode = false;
    private Set<String> excludedConfigurations = new HashSet<String>();
    private Set<String> excludedConfigurationPrefixes = new HashSet<String>();
    private Set<String> reasons = new HashSet<String>();
    private Boolean eagerlyResolve = true;
    public static final RecommendationStrategies OverrideTransitives = RecommendationStrategies.OverrideTransitives;
    public static final RecommendationStrategies ConflictResolved = RecommendationStrategies.ConflictResolved;

    public RecommendationProviderContainer(Project project) {
        this.createList(project);
        this.project = project;
        this.mavenBomProvider = this.getMavenBomRecommendationProvider();
        this.providers.add((Object)this.mavenBomProvider);
    }

    private void createList(Project project) {
        ObjectFactory objects = project.getObjects();
        try {
            Method factoryMethod = objects.getClass().getDeclaredMethod("namedDomainObjectList", Class.class);
            this.providers = (NamedDomainObjectList)factoryMethod.invoke((Object)objects, RecommendationProvider.class);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("NamedDomainObjectList couldn't be created", e);
        }
    }

    private MavenBomRecommendationProvider getMavenBomRecommendationProvider() {
        MavenBomRecommendationProvider mavenBomRecommendationProvider = DependencyRecommendationsPlugin.CORE_BOM_SUPPORT_ENABLED ? new CoreBomSupportProvider(this.project, "nebulaRecommenderBom", this.reasons) : new MavenBomRecommendationProvider(this.project, "nebulaRecommenderBom", this.reasons);
        return mavenBomRecommendationProvider;
    }

    public <T extends RecommendationProvider> T addProvider(T provider, Action<? super T> configureAction) {
        configureAction.execute(provider);
        this.providers.add(provider);
        return provider;
    }

    public <T extends RecommendationProvider> T addFirst(T provider) {
        this.providers.remove(provider);
        this.providers.add(0, provider);
        return provider;
    }

    public RecommendationProvider getByName(String name) {
        return (RecommendationProvider)this.providers.getByName(name);
    }

    public PropertyFileRecommendationProvider propertiesFile(Map<String, ?> args) {
        RecommendationProviderContainer.ensureCoreBomSupportNotEnabled("propertiesFile");
        String message = "nebula.dependency-recommender uses a properties file: " + String.valueOf(args.get("file"));
        this.reasons.add(message);
        HashMap modifiedArgs = new HashMap(args);
        return this.addProvider((RecommendationProvider)new PropertyFileRecommendationProvider(this.project), (Action)new ConfigureByMapAction(modifiedArgs));
    }

    public PropertyFileRecommendationProvider propertiesFile(Closure closure) {
        RecommendationProviderContainer.ensureCoreBomSupportNotEnabled("propertiesFile");
        String message = "nebula.dependency-recommender uses a properties file";
        this.reasons.add(message);
        return this.addProvider(new PropertyFileRecommendationProvider(this.project), ConfigureUtil.configureUsing(closure));
    }

    public MavenBomRecommendationProvider mavenBom(Map<String, ?> args) {
        Object dependencyNotation = args.get("module");
        Object isEnforced = args.get("enforced");
        if (dependencyNotation == null) {
            throw new IllegalArgumentException("Module may not be null");
        }
        if (!DependencyRecommendationsPlugin.CORE_BOM_SUPPORT_ENABLED) {
            if (Map.class.isAssignableFrom(dependencyNotation.getClass())) {
                ((Map)dependencyNotation).put("ext", "pom");
            } else if (!dependencyNotation.toString().endsWith("@pom")) {
                dependencyNotation = dependencyNotation.toString() + "@pom";
            }
            this.project.getDependencies().add("nebulaRecommenderBom", dependencyNotation);
        } else {
            Dependency platform = isEnforced != null && Boolean.valueOf(isEnforced.toString()) != false ? this.project.getDependencies().enforcedPlatform(dependencyNotation) : this.project.getDependencies().platform(dependencyNotation);
            this.project.getDependencies().add("nebulaRecommenderBom", (Object)platform);
        }
        return this.mavenBomProvider;
    }

    public IvyRecommendationProvider ivyXml(Map<String, ?> args) {
        RecommendationProviderContainer.ensureCoreBomSupportNotEnabled("ivyXml");
        String message = "nebula.dependency-recommender uses a ivyXml: " + String.valueOf(args.get("module"));
        this.reasons.add(message);
        HashMap modifiedArgs = new HashMap(args);
        return this.addProvider((RecommendationProvider)new IvyRecommendationProvider(this.project), (Action)new ConfigureByMapAction(modifiedArgs));
    }

    public IvyRecommendationProvider ivyXml(Closure closure) {
        RecommendationProviderContainer.ensureCoreBomSupportNotEnabled("ivyXml");
        String message = "nebula.dependency-recommender uses a ivyXml";
        this.reasons.add(message);
        return this.addProvider(new IvyRecommendationProvider(this.project), ConfigureUtil.configureUsing(closure));
    }

    public DependencyLockProvider dependencyLock(Map<String, ?> args) {
        RecommendationProviderContainer.ensureCoreBomSupportNotEnabled("dependencyLock");
        String message = "nebula.dependency-recommender uses a dependency lock: " + String.valueOf(args.get("module"));
        this.reasons.add(message);
        HashMap modifiedArgs = new HashMap(args);
        return this.addProvider((RecommendationProvider)new DependencyLockProvider(this.project), (Action)new ConfigureByMapAction(modifiedArgs));
    }

    public DependencyLockProvider dependencyLock(Closure closure) {
        RecommendationProviderContainer.ensureCoreBomSupportNotEnabled("dependencyLock");
        String message = "nebula.dependency-recommender uses a dependency lock for recommendations";
        this.reasons.add(message);
        return this.addProvider(new DependencyLockProvider(this.project), ConfigureUtil.configureUsing(closure));
    }

    public MapRecommendationProvider map(Map<String, ?> args) {
        RecommendationProviderContainer.ensureCoreBomSupportNotEnabled("map");
        String message = "nebula.dependency-recommender uses a provided map for recommendations";
        this.reasons.add(message);
        HashMap modifiedArgs = new HashMap(args);
        return this.addProvider((RecommendationProvider)new MapRecommendationProvider(), (Action)new ConfigureByMapAction(modifiedArgs));
    }

    public MapRecommendationProvider map(Closure closure) {
        RecommendationProviderContainer.ensureCoreBomSupportNotEnabled("map");
        String message = "nebula.dependency-recommender uses a provided map for recommendations";
        this.reasons.add(message);
        return this.addProvider(new MapRecommendationProvider(), ConfigureUtil.configureUsing(closure));
    }

    public CustomRecommendationProvider addProvider(Closure closure) {
        RecommendationProviderContainer.ensureCoreBomSupportNotEnabled("addProvider");
        String message = "nebula.dependency-recommender uses a CustomRecommendationProvider";
        this.reasons.add(message);
        return this.addProvider(new CustomRecommendationProvider(closure), new Action<CustomRecommendationProvider>(){

            public void execute(CustomRecommendationProvider customRecommendationProvider) {
            }
        });
    }

    public MavenBomRecommendationProvider getMavenBomProvider() {
        return this.mavenBomProvider;
    }

    public String getRecommendedVersion(String group, String name) {
        for (int i = this.providers.size() - 1; i >= 0; --i) {
            try {
                String version = ((RecommendationProvider)this.providers.get(i)).getVersion(group, name);
                if (version == null) continue;
                return version;
            }
            catch (Exception e) {
                this.project.getLogger().error("Exception while polling provider " + ((RecommendationProvider)this.providers.get(i)).getName() + " for version", (Throwable)e);
            }
        }
        return null;
    }

    public RecommendationStrategies getStrategy() {
        return this.strategy;
    }

    public void setStrategy(RecommendationStrategies strategy) {
        this.strategy = strategy;
    }

    @Deprecated
    public Boolean isStrictMode() {
        return this.getStrictMode();
    }

    public Boolean getStrictMode() {
        return this.strictMode;
    }

    public void setStrictMode(Boolean strict) {
        this.strictMode = strict;
    }

    public void setEagerlyResolve(Boolean eagerlyResolve) {
        this.eagerlyResolve = eagerlyResolve;
    }

    public Boolean shouldEagerlyResolve() {
        return this.eagerlyResolve;
    }

    public void excludeConfigurations(String ... names) {
        this.excludedConfigurations.addAll(Arrays.asList(names));
    }

    public void excludeConfigurationPrefixes(String ... names) {
        this.excludedConfigurationPrefixes.addAll(Arrays.asList(names));
    }

    public Set<String> getExcludedConfigurations() {
        return this.excludedConfigurations;
    }

    public Set<String> getExcludedConfigurationPrefixes() {
        return this.excludedConfigurationPrefixes;
    }

    public Set<String> getReasons() {
        return this.reasons;
    }

    private static void ensureCoreBomSupportNotEnabled(String feature) {
        if (DependencyRecommendationsPlugin.CORE_BOM_SUPPORT_ENABLED) {
            throw new GradleException("dependencyRecommender." + feature + " is not available with 'systemProp.nebula.features.coreBomSupport=true'");
        }
    }

    private static class CoreBomSupportProvider
    extends MavenBomRecommendationProvider {
        CoreBomSupportProvider(Project project, String configName, Set<String> reasons) {
            super(project, configName, reasons);
        }

        @Override
        protected Map<String, String> getBomRecommendations(Set<String> reasons) {
            ArrayList<Dependency> rawPomDependencies = new ArrayList<Dependency>();
            for (Dependency dependency : this.configuration.getDependencies()) {
                rawPomDependencies.add(this.project.getDependencies().create((Object)(dependency.getGroup() + ":" + dependency.getName() + ":" + dependency.getVersion() + "@pom")));
            }
            Configuration detachedConfig = this.project.getConfigurations().detachedConfiguration(rawPomDependencies.toArray(new Dependency[0]));
            return ((BomResolverService)this.bomResolverService.get()).getCachedRecommendationsFromConfiguration(detachedConfig, reasons);
        }
    }

    private static class RecommendationProviderNamer
    implements Namer<RecommendationProvider> {
        private RecommendationProviderNamer() {
        }

        public String determineName(RecommendationProvider r) {
            return r.getName();
        }
    }
}

