/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender.util;

import netflix.nebula.dependency.recommender.provider.MavenBomRecommendationProvider;
import netflix.nebula.dependency.recommender.provider.RecommendationProviderContainer;
import netflix.nebula.dependency.recommender.service.BomResolverService;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;

public final class BomResolutionUtil {
    private static final Logger logger = Logging.getLogger(BomResolutionUtil.class);

    private BomResolutionUtil() {
    }

    public static void eagerlyResolveBoms(Project project, RecommendationProviderContainer container, String bomConfigurationName) {
        block8: {
            if (project == null) {
                throw new IllegalArgumentException("Project cannot be null");
            }
            if (container == null) {
                throw new IllegalArgumentException("RecommendationProviderContainer cannot be null");
            }
            if (bomConfigurationName == null || bomConfigurationName.trim().isEmpty()) {
                throw new IllegalArgumentException("BOM configuration name cannot be null or empty");
            }
            try {
                Provider bomResolverService = project.getGradle().getSharedServices().registerIfAbsent("bomResolver", BomResolverService.class, spec -> {});
                ((BomResolverService)bomResolverService.get()).eagerlyResolveAndCacheBoms(project, bomConfigurationName);
                MavenBomRecommendationProvider mavenBomProvider = container.getMavenBomProvider();
                if (mavenBomProvider != null) {
                    try {
                        mavenBomProvider.getVersion("dummy", "dummy");
                    }
                    catch (Exception e) {
                        logger.debug("Triggered BOM resolution for maven BOM provider", (Throwable)e);
                    }
                }
                logger.debug("Successfully resolved BOMs for project {} using configuration {}", (Object)project.getPath(), (Object)bomConfigurationName);
            }
            catch (Exception e) {
                logger.warn("Failed to eagerly resolve BOMs for project {} using configuration {}: {}", new Object[]{project.getPath(), bomConfigurationName, e.getMessage()});
                if (!logger.isDebugEnabled()) break block8;
                logger.debug("BOM resolution failure details", (Throwable)e);
            }
        }
    }

    public static boolean shouldEagerlyResolveBoms(Project project, RecommendationProviderContainer container) {
        if (project == null) {
            throw new IllegalArgumentException("Project cannot be null");
        }
        if (container == null) {
            throw new IllegalArgumentException("RecommendationProviderContainer cannot be null");
        }
        if (!container.shouldEagerlyResolve().booleanValue()) {
            logger.debug("Eager BOM resolution disabled for project {} via container setting", (Object)project.getPath());
            return false;
        }
        logger.debug("Eager BOM resolution enabled for project {}", (Object)project.getPath());
        return true;
    }
}

