/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import netflix.nebula.dependency.recommender.provider.AbstractRecommendationProvider;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.internal.typeconversion.NotationConvertResult;

public abstract class FileBasedRecommendationProvider
extends AbstractRecommendationProvider {
    protected Project project;
    protected InputStreamProvider inputProvider = new InputStreamProvider(){

        @Override
        public InputStream getInputStream() throws Exception {
            throw new InvalidUserDataException("No recommender input source has been defined");
        }
    };

    protected FileBasedRecommendationProvider() {
    }

    public FileBasedRecommendationProvider(Project project) {
        this.project = project;
    }

    protected InputStream getInput() {
        try {
            return this.inputProvider.getInputStream();
        }
        catch (Exception e) {
            throw new InvalidUserDataException("Unable to open recommender input source", (Throwable)e);
        }
    }

    public InputStreamProvider setFile(final File f) {
        this.inputProvider = new InputStreamProvider(){

            @Override
            public InputStream getInputStream() throws Exception {
                return new FileInputStream(f);
            }
        };
        return this.inputProvider;
    }

    public InputStreamProvider setInputStream(final InputStream in) {
        this.inputProvider = new InputStreamProvider(){

            @Override
            public InputStream getInputStream() {
                return in;
            }
        };
        return this.inputProvider;
    }

    public InputStreamProvider setUri(final URI uri) {
        this.inputProvider = new InputStreamProvider(){

            @Override
            public InputStream getInputStream() throws Exception {
                return uri.toURL().openStream();
            }
        };
        return this.inputProvider;
    }

    public InputStreamProvider setUri(String uri) {
        return this.setUri(URI.create(uri));
    }

    public InputStreamProvider setUrl(final URL url) {
        this.inputProvider = new InputStreamProvider(){

            @Override
            public InputStream getInputStream() throws Exception {
                return url.openStream();
            }
        };
        return this.inputProvider;
    }

    public InputStreamProvider setUrl(final String url) {
        this.inputProvider = new InputStreamProvider(){

            @Override
            public InputStream getInputStream() throws Exception {
                return new URL(url).openStream();
            }
        };
        return this.inputProvider;
    }

    public InputStreamProvider setModule(final Object dependencyNotation) {
        this.inputProvider = new InputStreamProvider(){

            @Override
            public InputStream getInputStream() throws Exception {
                Configuration conf = FileBasedRecommendationProvider.this.project.getConfigurations().detachedConfiguration(new Dependency[]{FileBasedRecommendationProvider.this.project.getDependencies().create(dependencyNotation)});
                return new FileInputStream((File)conf.resolve().iterator().next());
            }
        };
        return this.inputProvider;
    }

    private class ProviderNotationConvertResult
    implements NotationConvertResult<DefaultExternalModuleDependency> {
        ExternalModuleDependency dependency;

        private ProviderNotationConvertResult() {
        }

        public boolean hasResult() {
            return this.dependency != null;
        }

        public void converted(DefaultExternalModuleDependency result) {
            this.dependency = result;
        }
    }

    public static interface InputStreamProvider {
        public InputStream getInputStream() throws Exception;
    }
}

