/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender;

import java.util.ArrayList;
import netflix.nebula.dependency.recommender.provider.RecommendationProviderContainer;
import netflix.nebula.dependency.recommender.provider.RecommendationResolver;
import netflix.nebula.dependency.recommender.publisher.MavenBomXmlGenerator;
import org.codehaus.groovy.runtime.MethodClosure;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.JavaPlugin;

public class DependencyRecommendationsPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getExtensions().create("dependencyRecommendations", RecommendationProviderContainer.class, new Object[]{project});
        this.applyRecommendations(project);
        this.enhanceDependenciesWithRecommender(project);
        this.enhancePublicationsWithBomProducer(project);
    }

    private void applyRecommendations(final Project project) {
        project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                project.getConfigurations().all((Action)new Action<Configuration>(){

                    public void execute(final Configuration conf) {
                        final ArrayList firstOrderDepsWithoutVersions = new ArrayList();
                        conf.getIncoming().beforeResolve((Action)new Action<ResolvableDependencies>(){

                            public void execute(ResolvableDependencies resolvableDependencies) {
                                for (Dependency dependency : resolvableDependencies.getDependencies()) {
                                    if (dependency.getVersion() != null && !dependency.getVersion().isEmpty()) continue;
                                    firstOrderDepsWithoutVersions.add(dependency.getGroup() + ":" + dependency.getName());
                                }
                            }
                        });
                        conf.getResolutionStrategy().eachDependency((Action)new Action<DependencyResolveDetails>(){

                            public void execute(DependencyResolveDetails details) {
                                ModuleVersionSelector requested = details.getRequested();
                                String coord = requested.getGroup() + ":" + requested.getName();
                                for (ModuleVersionSelector force : conf.getResolutionStrategy().getForcedModules()) {
                                    if (!requested.getGroup().equals(force.getGroup()) || !requested.getName().equals(force.getName())) continue;
                                    return;
                                }
                                String version = DependencyRecommendationsPlugin.this.getRecommendedVersionRecursive(project, requested);
                                if (version != null && firstOrderDepsWithoutVersions.contains(coord)) {
                                    details.useVersion(version);
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    protected void enhanceDependenciesWithRecommender(Project project) {
        RecommendationResolver resolver = new RecommendationResolver(project);
        ((ExtraPropertiesExtension)project.getExtensions().getByType(ExtraPropertiesExtension.class)).set("recommend", (Object)new MethodClosure((Object)resolver, "recommend"));
    }

    protected void enhancePublicationsWithBomProducer(Project project) {
        project.getExtensions().create("dependencyManagement", MavenBomXmlGenerator.class, new Object[]{project});
    }

    protected String getRecommendedVersionRecursive(Project project, ModuleVersionSelector mvSelector) {
        String version = ((RecommendationProviderContainer)((Object)project.getExtensions().getByType(RecommendationProviderContainer.class))).getRecommendedVersion(mvSelector.getGroup(), mvSelector.getName());
        if (version != null) {
            return version;
        }
        if (project.getParent() != null) {
            return this.getRecommendedVersionRecursive(project.getParent(), mvSelector);
        }
        return null;
    }
}

