/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender.provider;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import netflix.nebula.dependency.recommender.RecommendationStrategies;
import netflix.nebula.dependency.recommender.provider.CustomRecommendationProvider;
import netflix.nebula.dependency.recommender.provider.DependencyLockProvider;
import netflix.nebula.dependency.recommender.provider.IvyRecommendationProvider;
import netflix.nebula.dependency.recommender.provider.MapRecommendationProvider;
import netflix.nebula.dependency.recommender.provider.MavenBomRecommendationProvider;
import netflix.nebula.dependency.recommender.provider.PropertyFileRecommendationProvider;
import netflix.nebula.dependency.recommender.provider.RecommendationProvider;
import org.gradle.api.Action;
import org.gradle.api.Namer;
import org.gradle.api.Project;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.ConfigureByMapAction;
import org.gradle.api.internal.DefaultNamedDomainObjectList;

public class RecommendationProviderContainer
extends DefaultNamedDomainObjectList<RecommendationProvider> {
    private Project project;
    private RecommendationStrategies strategy = RecommendationStrategies.OverrideTransitives;
    public static final RecommendationStrategies OverrideTransitives = RecommendationStrategies.OverrideTransitives;
    public static final RecommendationStrategies ConflictResolved = RecommendationStrategies.ConflictResolved;
    private final Action<? super RecommendationProvider> addLastAction = new Action<RecommendationProvider>(){

        public void execute(RecommendationProvider r) {
            RecommendationProviderContainer.super.add(r);
        }
    };

    public RecommendationProviderContainer(Project project) {
        super(RecommendationProvider.class, null, (Namer)new RecommendationProviderNamer());
        this.project = project;
    }

    public <T extends RecommendationProvider> T add(T provider, Action<? super T> configureAction) {
        configureAction.execute(provider);
        this.assertCanAdd(provider.getName());
        this.addLastAction.execute(provider);
        return provider;
    }

    public <T extends RecommendationProvider> T addFirst(T provider) {
        this.remove(provider);
        super.add(0, provider);
        return provider;
    }

    public PropertyFileRecommendationProvider propertiesFile(Map<String, ?> args) {
        HashMap modifiedArgs = new HashMap(args);
        return this.add((RecommendationProvider)new PropertyFileRecommendationProvider(this.project), (Action)new ConfigureByMapAction(modifiedArgs));
    }

    public PropertyFileRecommendationProvider propertiesFile(Closure closure) {
        return this.add((RecommendationProvider)new PropertyFileRecommendationProvider(this.project), (Action)new ClosureBackedAction(closure));
    }

    public MavenBomRecommendationProvider mavenBom(Map<String, ?> args) {
        HashMap modifiedArgs = new HashMap(args);
        return this.add((RecommendationProvider)new MavenBomRecommendationProvider(this.project), (Action)new ConfigureByMapAction(modifiedArgs));
    }

    public MavenBomRecommendationProvider mavenBom(Closure closure) {
        return this.add((RecommendationProvider)new MavenBomRecommendationProvider(this.project), (Action)new ClosureBackedAction(closure));
    }

    public IvyRecommendationProvider ivyXml(Map<String, ?> args) {
        HashMap modifiedArgs = new HashMap(args);
        return this.add((RecommendationProvider)new IvyRecommendationProvider(this.project), (Action)new ConfigureByMapAction(modifiedArgs));
    }

    public IvyRecommendationProvider ivyXml(Closure closure) {
        return this.add((RecommendationProvider)new IvyRecommendationProvider(this.project), (Action)new ClosureBackedAction(closure));
    }

    public DependencyLockProvider dependencyLock(Map<String, ?> args) {
        HashMap modifiedArgs = new HashMap(args);
        return this.add((RecommendationProvider)new DependencyLockProvider(this.project), (Action)new ConfigureByMapAction(modifiedArgs));
    }

    public DependencyLockProvider dependencyLock(Closure closure) {
        return this.add((RecommendationProvider)new DependencyLockProvider(this.project), (Action)new ClosureBackedAction(closure));
    }

    public MapRecommendationProvider map(Map<String, ?> args) {
        HashMap modifiedArgs = new HashMap(args);
        return this.add((RecommendationProvider)new MapRecommendationProvider(), (Action)new ConfigureByMapAction(modifiedArgs));
    }

    public MapRecommendationProvider map(Closure closure) {
        return this.add((RecommendationProvider)new MapRecommendationProvider(), (Action)new ClosureBackedAction(closure));
    }

    public CustomRecommendationProvider add(Closure closure) {
        return this.add(new CustomRecommendationProvider(closure), new Action<CustomRecommendationProvider>(){

            public void execute(CustomRecommendationProvider customRecommendationProvider) {
            }
        });
    }

    public String getRecommendedVersion(String group, String name) {
        for (int i = this.size() - 1; i >= 0; --i) {
            try {
                String version = ((RecommendationProvider)this.get(i)).getVersion(group, name);
                if (version == null) continue;
                return version;
            }
            catch (Exception e) {
                this.project.getLogger().error("Exception while polling provider " + ((RecommendationProvider)this.get(i)).getName() + " for version", (Throwable)e);
            }
        }
        return null;
    }

    public RecommendationStrategies getStrategy() {
        return this.strategy;
    }

    public void setStrategy(RecommendationStrategies strategy) {
        this.strategy = strategy;
    }

    private static class RecommendationProviderNamer
    implements Namer<RecommendationProvider> {
        private RecommendationProviderNamer() {
        }

        public String determineName(RecommendationProvider r) {
            return r.getName();
        }
    }
}

