/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender;

import java.util.ArrayList;
import java.util.List;
import netflix.nebula.dependency.recommender.RecommendationStrategy;
import netflix.nebula.dependency.recommender.RecommendationStrategyFactory;
import netflix.nebula.dependency.recommender.provider.RecommendationProviderContainer;
import netflix.nebula.dependency.recommender.provider.RecommendationResolver;
import netflix.nebula.dependency.recommender.publisher.MavenBomXmlGenerator;
import org.codehaus.groovy.runtime.MethodClosure;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtraPropertiesExtension;

public class DependencyRecommendationsPlugin
implements Plugin<Project> {
    public static final String NEBULA_RECOMMENDER_BOM = "nebulaRecommenderBom";
    private Logger logger = Logging.getLogger(DependencyRecommendationsPlugin.class);

    public void apply(Project project) {
        project.getConfigurations().create(NEBULA_RECOMMENDER_BOM);
        project.getExtensions().create("dependencyRecommendations", RecommendationProviderContainer.class, new Object[]{project});
        this.applyRecommendations(project);
        this.enhanceDependenciesWithRecommender(project);
        this.enhancePublicationsWithBomProducer(project);
    }

    private void applyRecommendationToDependency(RecommendationStrategyFactory factory, Dependency dependency, List<ProjectDependency> visited) {
        ProjectDependency projectDependency;
        if (dependency instanceof ExternalModuleDependency) {
            factory.getRecommendationStrategy().inspectDependency(dependency);
        } else if (dependency instanceof ProjectDependency && !visited.contains(projectDependency = (ProjectDependency)dependency)) {
            Configuration configuration;
            visited.add(projectDependency);
            try {
                ProjectDependency.class.getMethod("getTargetConfiguration", new Class[0]);
                String targetConfiguration = projectDependency.getTargetConfiguration() == null ? "default" : projectDependency.getTargetConfiguration();
                configuration = projectDependency.getDependencyProject().getConfigurations().getByName(targetConfiguration);
            }
            catch (NoSuchMethodException e) {
                configuration = projectDependency.getProjectConfiguration();
            }
            DependencySet dependencies = configuration.getAllDependencies();
            for (Dependency dep : dependencies) {
                this.applyRecommendationToDependency(factory, dep, visited);
            }
        }
    }

    private void applyRecommendations(final Project project) {
        project.getConfigurations().all((Action)new Action<Configuration>(){

            public void execute(final Configuration conf) {
                final RecommendationStrategyFactory rsFactory = new RecommendationStrategyFactory(project);
                if (conf.getState() == Configuration.State.UNRESOLVED) {
                    conf.getIncoming().beforeResolve((Action)new Action<ResolvableDependencies>(){

                        public void execute(ResolvableDependencies resolvableDependencies) {
                            for (Dependency dependency : resolvableDependencies.getDependencies()) {
                                DependencyRecommendationsPlugin.this.applyRecommendationToDependency(rsFactory, dependency, new ArrayList());
                            }
                            conf.getResolutionStrategy().eachDependency((Action)new Action<DependencyResolveDetails>(){

                                public void execute(DependencyResolveDetails details) {
                                    String version;
                                    ModuleVersionSelector requested = details.getRequested();
                                    for (ModuleVersionSelector force : conf.getResolutionStrategy().getForcedModules()) {
                                        if (!requested.getGroup().equals(force.getGroup()) || !requested.getName().equals(force.getName())) continue;
                                        return;
                                    }
                                    RecommendationStrategy strategy = rsFactory.getRecommendationStrategy();
                                    if (strategy.canRecommendVersion(requested) && strategy.recommendVersion(details, version = DependencyRecommendationsPlugin.this.getRecommendedVersionRecursive(project, requested))) {
                                        DependencyRecommendationsPlugin.this.logger.info("Recommending version " + version + " for dependency " + requested.getGroup() + ":" + requested.getName());
                                    }
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    protected void enhanceDependenciesWithRecommender(Project project) {
        RecommendationResolver resolver = new RecommendationResolver(project);
        ((ExtraPropertiesExtension)project.getExtensions().getByType(ExtraPropertiesExtension.class)).set("recommend", (Object)new MethodClosure((Object)resolver, "recommend"));
    }

    protected void enhancePublicationsWithBomProducer(Project project) {
        project.getExtensions().create("nebulaDependencyManagement", MavenBomXmlGenerator.class, new Object[]{project});
    }

    protected String getRecommendedVersionRecursive(Project project, ModuleVersionSelector mvSelector) {
        String version = ((RecommendationProviderContainer)((Object)project.getExtensions().getByType(RecommendationProviderContainer.class))).getRecommendedVersion(mvSelector.getGroup(), mvSelector.getName());
        if (version != null) {
            return version;
        }
        if (project.getParent() != null) {
            return this.getRecommendedVersionRecursive(project.getParent(), mvSelector);
        }
        return null;
    }
}

