/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender;

import java.util.ArrayList;
import java.util.List;
import netflix.nebula.dependency.recommender.RecommendationStrategy;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.ModuleVersionSelector;

public class RecommendationsConflictResolvedStrategy
extends RecommendationStrategy {
    private List<String> firstOrderDepsWithoutVersions = new ArrayList<String>();

    @Override
    public void inspectDependency(Dependency dependency) {
        if (this.isVersionMissing(dependency.getVersion())) {
            this.firstOrderDepsWithoutVersions.add(dependency.getGroup() + ":" + dependency.getName());
        }
    }

    @Override
    public boolean canRecommendVersion(ModuleVersionSelector selector) {
        return this.firstOrderDepsWithoutVersions.contains(this.getCoord(selector));
    }

    @Override
    public boolean recommendVersion(DependencyResolveDetails details, String version) {
        boolean recommenderHasValidVersion;
        boolean bl = recommenderHasValidVersion = version != null;
        if (recommenderHasValidVersion && this.isFirstOrderMissingVersion(details)) {
            details.useVersion(version);
            return true;
        }
        return false;
    }

    private boolean isVersionMissing(String version) {
        return version == null || version.isEmpty();
    }

    private boolean isFirstOrderMissingVersion(DependencyResolveDetails details) {
        boolean dependencyInFirstOrderList = this.firstOrderDepsWithoutVersions.contains(this.getCoord(details));
        boolean versionMissing = this.isVersionMissing(details.getRequested().getVersion());
        return dependencyInFirstOrderList && versionMissing;
    }
}

