/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender.provider;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class FuzzyVersionResolver {
    private Map<Pattern, String> globs;

    protected abstract Collection<String> propertyNames();

    protected abstract String propertyValue(String var1);

    private String resolveVersion(String value) {
        if (value == null) {
            return null;
        }
        if (!value.startsWith("$")) {
            return value;
        }
        return this.resolveVersion(this.versionOf(value.substring(1)));
    }

    public String versionOf(String key) {
        String version = this.propertyValue(key);
        if (version != null) {
            return this.resolveVersion(version);
        }
        if (this.globs == null) {
            this.globs = new HashMap<Pattern, String>();
            for (String string : this.propertyNames()) {
                if (!string.contains("*")) continue;
                this.globs.put(Pattern.compile(string.replaceAll("\\*", ".*?")), this.propertyValue(string));
            }
        }
        for (Map.Entry entry : this.globs.entrySet()) {
            if (!((Pattern)entry.getKey()).matcher(key).matches()) continue;
            return this.resolveVersion((String)entry.getValue());
        }
        return null;
    }
}

