/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender.provider;

import com.netflix.nebula.dependencybase.DependencyManagement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import netflix.nebula.dependency.recommender.provider.ClasspathBasedRecommendationProvider;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.interpolation.StringSearchModelInterpolator;
import org.apache.maven.model.path.DefaultPathTranslator;
import org.apache.maven.model.path.DefaultUrlNormalizer;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.path.UrlNormalizer;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.ValueSource;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;

public class MavenBomRecommendationProvider
extends ClasspathBasedRecommendationProvider {
    private Map<String, String> recommendations;
    private DependencyManagement insight;

    public MavenBomRecommendationProvider(Project project, String configName) {
        super(project, configName);
        this.insight = new DependencyManagement();
    }

    public MavenBomRecommendationProvider(Project project, String configName, DependencyManagement insight) {
        super(project, configName);
        this.insight = insight;
    }

    @Override
    public String getVersion(String org, String name) throws Exception {
        if (this.recommendations == null) {
            this.recommendations = new HashMap<String, String>();
            Set<File> recommendationFiles = this.getFilesOnConfiguration();
            for (File recommendation : recommendationFiles) {
                if (!recommendation.getName().endsWith("pom")) break;
                DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
                request.setModelResolver(new ModelResolver(){

                    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
                        String relativeUrl = "";
                        for (String groupIdPart : groupId.split("\\.")) {
                            relativeUrl = relativeUrl + groupIdPart + "/";
                        }
                        relativeUrl = relativeUrl + artifactId + "/" + version + "/" + artifactId + "-" + version + ".pom";
                        try {
                            for (ArtifactRepository repo : MavenBomRecommendationProvider.this.project.getRepositories()) {
                                if (!(repo instanceof MavenArtifactRepository)) continue;
                                URL url = new URL(((MavenArtifactRepository)repo).getUrl().toString() + "/" + relativeUrl);
                                try {
                                    return new SimpleModelSource(url.openStream());
                                }
                                catch (IOException e) {
                                }
                            }
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                        return null;
                    }

                    public void addRepository(Repository repository) throws InvalidRepositoryException {
                    }

                    public ModelResolver newCopy() {
                        return this;
                    }
                });
                request.setModelSource((ModelSource)new SimpleModelSource(new FileInputStream(recommendation)));
                DefaultModelBuilder modelBuilder = new DefaultModelBuilderFactory().newInstance();
                modelBuilder.setModelInterpolator((ModelInterpolator)new ProjectPropertiesModelInterpolator(this.project));
                ModelBuildingResult result = modelBuilder.build((ModelBuildingRequest)request);
                this.insight.addPluginMessage("nebula.dependency-recommender uses mavenBom: " + result.getEffectiveModel().getId());
                for (Dependency d : result.getEffectiveModel().getDependencyManagement().getDependencies()) {
                    this.recommendations.put(d.getGroupId() + ":" + d.getArtifactId(), d.getVersion());
                }
            }
        }
        return this.recommendations.get(org + ":" + name);
    }

    private static class ProjectPropertiesModelInterpolator
    extends StringSearchModelInterpolator {
        private final Project project;

        ProjectPropertiesModelInterpolator(Project project) {
            this.project = project;
            this.setUrlNormalizer((UrlNormalizer)new DefaultUrlNormalizer());
            this.setPathTranslator((PathTranslator)new DefaultPathTranslator());
        }

        public List<ValueSource> createValueSources(Model model, File projectDir, ModelBuildingRequest request, ModelProblemCollector collector) {
            ArrayList<ValueSource> sources = new ArrayList<ValueSource>();
            sources.addAll(super.createValueSources(model, projectDir, request, collector));
            sources.add((ValueSource)new PropertiesBasedValueSource(System.getProperties()));
            sources.add((ValueSource)new MapBasedValueSource(this.project.getProperties()));
            return sources;
        }
    }

    private class SimpleModelSource
    implements ModelSource {
        InputStream in;

        public SimpleModelSource(InputStream in) {
            this.in = in;
        }

        public InputStream getInputStream() throws IOException {
            return this.in;
        }

        public String getLocation() {
            return null;
        }
    }
}

