/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender;

import java.util.ArrayList;
import java.util.List;
import netflix.nebula.dependency.recommender.RecommendationStrategy;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.ModuleVersionSelector;

public class RecommendationsOverrideTransitivesStrategy
extends RecommendationStrategy {
    private List<String> firstOrderDepsWithVersions = new ArrayList<String>();

    @Override
    public void inspectDependency(Dependency dependency) {
        if (dependency.getVersion() != null && !dependency.getVersion().isEmpty()) {
            this.firstOrderDepsWithVersions.add(dependency.getGroup() + ":" + dependency.getName());
        }
    }

    @Override
    public boolean canRecommendVersion(ModuleVersionSelector selector) {
        return !this.firstOrderDepsWithVersions.contains(this.getCoord(selector));
    }

    @Override
    public boolean recommendVersion(DependencyResolveDetails details, String version) {
        if (version != null && !this.firstOrderDepsWithVersions.contains(this.getCoord(details))) {
            details.useVersion(version);
            return true;
        }
        return false;
    }
}

