/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public abstract class FuzzyVersionResolver {
    private volatile List<Glob> globs;

    protected abstract Collection<String> propertyNames();

    protected abstract String propertyValue(String var1);

    private String resolveVersion(String value) {
        if (value == null) {
            return null;
        }
        if (!value.startsWith("$")) {
            return value;
        }
        return this.resolveVersion(this.versionOf(value.substring(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String versionOf(String key) {
        String version = this.propertyValue(key);
        if (version != null) {
            return this.resolveVersion(version);
        }
        if (this.globs == null) {
            FuzzyVersionResolver fuzzyVersionResolver = this;
            synchronized (fuzzyVersionResolver) {
                if (this.globs == null) {
                    this.globs = this.createGlobCache();
                }
            }
        }
        for (Glob glob : this.globs) {
            if (!glob.matches(key)) continue;
            return this.resolveVersion(glob.version);
        }
        return null;
    }

    private List<Glob> createGlobCache() {
        ArrayList<Glob> cache = new ArrayList<Glob>();
        for (String name : this.propertyNames()) {
            if (!name.contains("*")) continue;
            cache.add(Glob.compile(name, this.propertyValue(name)));
        }
        Collections.sort(cache);
        return cache;
    }

    private static class Glob
    implements Comparable<Glob> {
        private final Pattern pattern;
        private final String version;
        private final int weight;

        private Glob(Pattern pattern, String version, int weight) {
            this.pattern = pattern;
            this.version = version;
            this.weight = weight;
        }

        private static Glob compile(String glob, String version) {
            StringBuilder patternBuilder = new StringBuilder();
            boolean first = true;
            int weight = 0;
            for (String token : glob.split("\\*", -1)) {
                if (first) {
                    first = false;
                } else {
                    patternBuilder.append(".*?");
                }
                weight += token.length();
                patternBuilder.append(Pattern.quote(token));
            }
            Pattern pattern = Pattern.compile(patternBuilder.toString());
            return new Glob(pattern, version, weight);
        }

        private boolean matches(String key) {
            return this.pattern.matcher(key).matches();
        }

        @Override
        public int compareTo(Glob o) {
            return Integer.compare(o.weight, this.weight);
        }
    }
}

