/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender;

import com.netflix.nebula.interop.ConfigurationsKt;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import netflix.nebula.dependency.recommender.ExtendRecommenderConfigurationAction;
import netflix.nebula.dependency.recommender.RecommendationStrategy;
import netflix.nebula.dependency.recommender.RecommendationStrategyFactory;
import netflix.nebula.dependency.recommender.RecommendationsConflictResolvedStrategy;
import netflix.nebula.dependency.recommender.RecommendationsOverrideTransitivesStrategy;
import netflix.nebula.dependency.recommender.provider.RecommendationProviderContainer;
import netflix.nebula.dependency.recommender.provider.RecommendationResolver;
import netflix.nebula.dependency.recommender.publisher.MavenBomXmlGenerator;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.runtime.MethodClosure;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtraPropertiesExtension;

public class DependencyRecommendationsPlugin
implements Plugin<Project> {
    public static final String NEBULA_RECOMMENDER_BOM = "nebulaRecommenderBom";
    public static final boolean CORE_BOM_SUPPORT_ENABLED = Boolean.getBoolean("nebula.features.coreBomSupport");
    private Logger logger = Logging.getLogger(DependencyRecommendationsPlugin.class);
    private RecommendationProviderContainer recommendationProviderContainer;

    public void apply(Project project) {
        Configuration bomConfiguration = (Configuration)project.getConfigurations().create(NEBULA_RECOMMENDER_BOM);
        this.recommendationProviderContainer = (RecommendationProviderContainer)((Object)project.getExtensions().create("dependencyRecommendations", RecommendationProviderContainer.class, new Object[]{project}));
        if (CORE_BOM_SUPPORT_ENABLED) {
            this.logger.warn("coreBomSupport feature enabled");
            this.recommendationProviderContainer.excludeConfigurations("archives", NEBULA_RECOMMENDER_BOM, "provided", "versionManagement", "resolutionRules", "bootArchives", "webapp", "protolock");
            bomConfiguration.setCanBeResolved(false);
            this.applyRecommendationsDirectly(project, bomConfiguration);
        } else {
            this.applyRecommendations(project);
            this.enhanceDependenciesWithRecommender(project);
            this.enhancePublicationsWithBomProducer(project);
        }
    }

    private void applyRecommendationsDirectly(Project project, final Configuration bomConfiguration) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project p) {
                p.getConfigurations().all((Action)new ExtendRecommenderConfigurationAction(bomConfiguration, p, DependencyRecommendationsPlugin.this.recommendationProviderContainer));
                p.subprojects((Action)new Action<Project>(){

                    public void execute(Project sub) {
                        sub.getConfigurations().all((Action)new ExtendRecommenderConfigurationAction(bomConfiguration, sub, DependencyRecommendationsPlugin.this.recommendationProviderContainer));
                    }
                });
            }
        });
    }

    private void applyRecommendations(final Project project) {
        project.getConfigurations().all((Action)new Action<Configuration>(){

            public void execute(final Configuration conf) {
                final RecommendationStrategyFactory rsFactory = new RecommendationStrategyFactory(project);
                if (conf.getState() == Configuration.State.UNRESOLVED) {
                    ConfigurationsKt.onResolve((Configuration)conf, (Function1)new Function1<ResolvableDependencies, Unit>(){

                        public Unit invoke(ResolvableDependencies resolvableDependencies) {
                            if (DependencyRecommendationsPlugin.this.recommendationProviderContainer.getExcludedConfigurations().contains(conf.getName())) {
                                return Unit.INSTANCE;
                            }
                            for (Dependency dependency : resolvableDependencies.getDependencies()) {
                                DependencyRecommendationsPlugin.this.applyRecommendationToDependency(rsFactory, dependency, new ArrayList());
                            }
                            conf.getResolutionStrategy().eachDependency((Action)new Action<DependencyResolveDetails>(){

                                public void execute(DependencyResolveDetails details) {
                                    ModuleVersionSelector requested = details.getTarget();
                                    for (ModuleVersionSelector force : conf.getResolutionStrategy().getForcedModules()) {
                                        if (!requested.getGroup().equals(force.getGroup()) || !requested.getName().equals(force.getName())) continue;
                                        details.because("Would have recommended a version for " + requested.getGroup() + ":" + requested.getName() + ", but a force is in place");
                                        return;
                                    }
                                    RecommendationStrategy strategy = rsFactory.getRecommendationStrategy();
                                    if (strategy.canRecommendVersion(requested)) {
                                        String version = DependencyRecommendationsPlugin.this.getRecommendedVersionRecursive(project, requested);
                                        if (strategy.recommendVersion(details, version)) {
                                            String coordinate = requested.getGroup() + ":" + requested.getName();
                                            String strategyText = DependencyRecommendationsPlugin.this.whichStrategy(strategy);
                                            DependencyRecommendationsPlugin.this.logger.debug("Recommending version " + version + " for dependency " + coordinate);
                                            details.because("Recommending version " + version + " for dependency " + coordinate + " via " + strategyText + "\n\twith reasons: " + StringUtils.join(DependencyRecommendationsPlugin.this.recommendationProviderContainer.getReasons(), (String)", "));
                                        } else if (DependencyRecommendationsPlugin.this.recommendationProviderContainer.isStrictMode().booleanValue()) {
                                            String errorMessage = "Dependency " + details.getRequested().getGroup() + ":" + details.getRequested().getName() + " omitted version with no recommended version. General causes include a dependency being removed from the recommendation source or not applying a recommendation source to a project that depends on another project using a recommender.";
                                            project.getLogger().error(errorMessage);
                                            throw new GradleException(errorMessage);
                                        }
                                    }
                                }
                            });
                            return Unit.INSTANCE;
                        }
                    });
                }
            }
        });
    }

    private void applyRecommendationToDependency(RecommendationStrategyFactory factory, Dependency dependency, List<ProjectDependency> visited) {
        ProjectDependency projectDependency;
        if (dependency instanceof ExternalModuleDependency) {
            factory.getRecommendationStrategy().inspectDependency(dependency);
        } else if (dependency instanceof ProjectDependency && !visited.contains(projectDependency = (ProjectDependency)dependency)) {
            Configuration configuration;
            visited.add(projectDependency);
            try {
                ProjectDependency.class.getMethod("getTargetConfiguration", new Class[0]);
                String targetConfiguration = projectDependency.getTargetConfiguration() == null ? "default" : projectDependency.getTargetConfiguration();
                configuration = projectDependency.getDependencyProject().getConfigurations().getByName(targetConfiguration);
            }
            catch (NoSuchMethodException ignore) {
                try {
                    Method method = ProjectDependency.class.getMethod("getProjectConfiguration", new Class[0]);
                    configuration = (Configuration)method.invoke((Object)dependency, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to retrieve configuration for project dependency", e);
                }
            }
            DependencySet dependencies = configuration.getAllDependencies();
            for (Dependency dep : dependencies) {
                this.applyRecommendationToDependency(factory, dep, visited);
            }
        }
    }

    protected String whichStrategy(RecommendationStrategy strategy) {
        if (strategy instanceof RecommendationsConflictResolvedStrategy) {
            return "conflict resolution recommendation";
        }
        if (strategy instanceof RecommendationsOverrideTransitivesStrategy) {
            return "override transitive recommendation";
        }
        return "nebula.dependency-recommender";
    }

    protected void enhanceDependenciesWithRecommender(Project project) {
        RecommendationResolver resolver = new RecommendationResolver(project);
        ((ExtraPropertiesExtension)project.getExtensions().getByType(ExtraPropertiesExtension.class)).set("recommend", (Object)new MethodClosure((Object)resolver, "recommend"));
    }

    protected void enhancePublicationsWithBomProducer(Project project) {
        project.getExtensions().create("nebulaDependencyManagement", MavenBomXmlGenerator.class, new Object[]{project});
    }

    protected String getRecommendedVersionRecursive(Project project, ModuleVersionSelector mvSelector) {
        String version = ((RecommendationProviderContainer)((Object)project.getExtensions().getByType(RecommendationProviderContainer.class))).getRecommendedVersion(mvSelector.getGroup(), mvSelector.getName());
        if (version != null) {
            return version;
        }
        if (project.getParent() != null) {
            return this.getRecommendedVersionRecursive(project.getParent(), mvSelector);
        }
        return null;
    }
}

