/*
 * Decompiled with CFR 0.152.
 */
package netflix.nebula.dependency.recommender.provider;

import java.util.Collection;
import java.util.Map;
import netflix.nebula.dependency.recommender.provider.AbstractRecommendationProvider;
import netflix.nebula.dependency.recommender.provider.FuzzyVersionResolver;
import org.gradle.api.InvalidUserDataException;

public class MapRecommendationProvider
extends AbstractRecommendationProvider {
    private Map<String, String> recommendations;
    private FuzzyVersionResolver fuzzyResolver = new FuzzyVersionResolver(){

        @Override
        protected Collection<String> propertyNames() {
            return MapRecommendationProvider.this.recommendations.keySet();
        }

        @Override
        protected String propertyValue(String name) {
            return (String)MapRecommendationProvider.this.recommendations.get(name);
        }
    };

    @Override
    public String getVersion(String org, String name) {
        if (this.recommendations == null) {
            throw new InvalidUserDataException("No recommender of dependencies to versions was provided");
        }
        return this.fuzzyResolver.versionOf(org + ":" + name);
    }

    public void setRecommendations(Map<String, String> recommendations) {
        this.recommendations = recommendations;
    }
}

