/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.hollow;

import com.netflix.hollow.api.codegen.HollowAPIGenerator;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.objectmapper.HollowObjectMapper;
import com.netflix.nebula.hollow.ApiGeneratorExtension;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.tasks.TaskAction;

public class ApiGeneratorTask
extends DefaultTask {
    private final File projectDirFile = this.getProject().getProjectDir();
    private final String projectDirPath = this.projectDirFile.getAbsolutePath();
    private final String relativeJavaSourcesPath = "/src/main/java/";
    private final String javaSourcesPath = this.projectDirPath + "/src/main/java/";
    private final String[] compiledClassesPaths = new String[]{this.projectDirPath + "/build/classes/main/", this.projectDirPath + "/build/classes/java/main/"};
    private URLClassLoader urlClassLoader;

    @TaskAction
    public void generateApi() throws IOException {
        ApiGeneratorExtension extension = (ApiGeneratorExtension)this.getProject().getExtensions().getByType(ApiGeneratorExtension.class);
        this.validatePluginConfiguration(extension);
        this.initClassLoader();
        HollowWriteStateEngine writeEngine = new HollowWriteStateEngine();
        HollowObjectMapper mapper = new HollowObjectMapper(writeEngine);
        Collection<Class<?>> datamodelClasses = this.extractClasses(extension.packagesToScan);
        for (Class<?> clazz : datamodelClasses) {
            this.getLogger().debug("Initialize schema for class {}", (Object)clazz.getName());
            mapper.initializeTypeState(clazz);
        }
        String apiTargetPath = extension.destinationPath != null && extension.destinationPath.isEmpty() ? extension.destinationPath : this.buildPathToApiTargetFolder(extension.apiPackageName);
        HollowAPIGenerator generator = this.buildHollowAPIGenerator(extension, writeEngine, apiTargetPath);
        this.cleanupAndCreateFolders(apiTargetPath);
        generator.generateSourceFiles();
    }

    private HollowAPIGenerator buildHollowAPIGenerator(ApiGeneratorExtension extension, HollowWriteStateEngine writeStateEngine, String apiTargetPath) {
        HollowAPIGenerator.Builder builder = (HollowAPIGenerator.Builder)((HollowAPIGenerator.Builder)((HollowAPIGenerator.Builder)((HollowAPIGenerator.Builder)((HollowAPIGenerator.Builder)((HollowAPIGenerator.Builder)((HollowAPIGenerator.Builder)((HollowAPIGenerator.Builder)((HollowAPIGenerator.Builder)((HollowAPIGenerator.Builder)new HollowAPIGenerator.Builder().withAPIClassname(extension.apiClassName)).withPackageName(extension.apiPackageName)).withDataModel((HollowDataset)writeStateEngine)).withDestination(apiTargetPath)).withParameterizeAllClassNames(extension.parameterizeAllClassNames)).withAggressiveSubstitutions(extension.useAggressiveSubstitutions)).withBooleanFieldErgonomics(extension.useBooleanFieldErgonomics)).reservePrimaryKeyIndexForTypeWithPrimaryKey(extension.reservePrimaryKeyIndexForTypeWithPrimaryKey)).withHollowPrimitiveTypes(extension.useHollowPrimitiveTypes)).withVerboseToString(extension.useVerboseToString);
        if (extension.getterPrefix != null && !extension.getterPrefix.isEmpty()) {
            builder.withGetterPrefix(extension.getterPrefix);
        }
        if (extension.classPostfix != null && !extension.classPostfix.isEmpty()) {
            builder.withClassPostfix(extension.classPostfix);
        }
        if (extension.useErgonomicShortcuts) {
            builder.withErgonomicShortcuts();
        }
        if (extension.usePackageGrouping) {
            builder.withPackageGrouping();
        }
        if (extension.restrictApiToFieldType) {
            builder.withRestrictApiToFieldType();
        }
        return builder.build();
    }

    private Collection<Class<?>> extractClasses(List<String> packagesToScan) {
        HashSet classes = new HashSet();
        for (String packageToScan : packagesToScan) {
            File packageFile = this.buildPackageFile(packageToScan);
            List<File> allFilesInPackage = this.findFilesRecursively(packageFile);
            ArrayList<String> classNames = new ArrayList<String>();
            for (File file : allFilesInPackage) {
                String filePath = file.getAbsolutePath();
                this.getLogger().debug("Candidate for schema initialization {}", (Object)filePath);
                if (!filePath.endsWith(".java") || filePath.endsWith("package-info.java") || filePath.endsWith("module-info.java")) continue;
                String relativeFilePath = this.removeSubstrings(filePath, this.projectDirPath, "/src/main/java/");
                classNames.add(this.convertFolderPathToPackageName(this.removeSubstrings(relativeFilePath, ".java")));
            }
            for (String fqdn : classNames) {
                try {
                    Class<?> clazz = this.urlClassLoader.loadClass(fqdn);
                    classes.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    this.getLogger().warn("{} class not found", (Object)fqdn);
                }
            }
        }
        return classes;
    }

    private List<File> findFilesRecursively(File packageFile) {
        ArrayList<File> foundFiles = new ArrayList<File>();
        if (packageFile.exists()) {
            for (File file : packageFile.listFiles()) {
                if (file.isDirectory()) {
                    foundFiles.addAll(this.findFilesRecursively(file));
                    continue;
                }
                foundFiles.add(file);
            }
        }
        return foundFiles;
    }

    private File buildPackageFile(String packageName) {
        return new File(this.javaSourcesPath + this.convertPackageNameToFolderPath(packageName));
    }

    private String buildPathToApiTargetFolder(String apiPackageName) {
        return this.javaSourcesPath + this.convertPackageNameToFolderPath(apiPackageName);
    }

    private String convertPackageNameToFolderPath(String packageName) {
        return packageName.replaceAll("\\.", "/");
    }

    private String convertFolderPathToPackageName(String folderName) {
        return folderName.replaceAll("/", "\\.");
    }

    private String removeSubstrings(String result, String ... substrings) {
        for (String substring : substrings) {
            result = result.replace(substring, "");
        }
        return result;
    }

    private void cleanupAndCreateFolders(String generatedApiTarget) {
        File apiCodeFolder = new File(generatedApiTarget);
        apiCodeFolder.mkdirs();
        for (File f : apiCodeFolder.listFiles()) {
            f.delete();
        }
    }

    private void initClassLoader() throws MalformedURLException {
        URL[] urls = new URL[this.compiledClassesPaths.length];
        for (int i = 0; i < this.compiledClassesPaths.length; ++i) {
            urls[i] = new File(this.compiledClassesPaths[i]).toURI().toURL();
        }
        this.urlClassLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
    }

    private void validatePluginConfiguration(ApiGeneratorExtension extension) {
        if (extension.apiClassName == null || extension.apiPackageName == null || extension.packagesToScan.isEmpty()) {
            throw new InvalidUserDataException("Specify buildscript as per plugin readme | apiClassName, apiPackageName and packagesToScan configuration values must be present");
        }
    }
}

