/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.hollow;

import com.netflix.nebula.hollow.ApiGeneratorExtension;
import com.netflix.nebula.hollow.ApiGeneratorTask;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.JavaCompile;

public class ApiGeneratorPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        PluginContainer plugins = project.getPlugins();
        if (plugins.hasPlugin(JavaPlugin.class)) {
            HashMap<String, Object> taskPropertiesMap = new HashMap<String, Object>();
            taskPropertiesMap.put("name", "generateHollowConsumerApi");
            taskPropertiesMap.put("group", "hollow");
            taskPropertiesMap.put("type", ApiGeneratorTask.class);
            Task generateTask = project.getTasks().create(taskPropertiesMap);
            ApiGeneratorExtension extension = (ApiGeneratorExtension)project.getExtensions().create("hollow", ApiGeneratorExtension.class, new Object[0]);
            JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            SourceSet mainSourceSet = (SourceSet)javaPluginConvention.getSourceSets().getByName("main");
            project.getTasks().register("compileDataModel", JavaCompile.class, javaCompile -> {
                List packages = extension.packagesToScan.stream().map(pkg -> pkg.replace(".", "/") + "/**").collect(Collectors.toList());
                File destinationDir = mainSourceSet.getOutput().getClassesDirs().filter(file -> file.toString().contains("java")).getSingleFile();
                javaCompile.setSource((Object)mainSourceSet.getJava().getSrcDirs());
                javaCompile.include(packages);
                javaCompile.setClasspath(mainSourceSet.getCompileClasspath());
                javaCompile.getDestinationDirectory().set(destinationDir);
            });
            project.getTasks().register("cleanDataModelApi", Delete.class, deleteTask -> {
                if (!extension.destinationPath.isEmpty()) {
                    deleteTask.delete(new Object[]{extension.destinationPath});
                    return;
                }
                String dataModelApiPath = extension.apiPackageName.replace(".", "/");
                List paths = mainSourceSet.getJava().getSrcDirs().stream().map(srcDir -> srcDir.toPath().resolve(dataModelApiPath).toString()).collect(Collectors.toList());
                deleteTask.delete(new Object[]{paths});
            });
            generateTask.dependsOn(new Object[]{"compileDataModel"});
            project.getTasks().getByName("compileJava").dependsOn(new Object[]{generateTask});
            project.getTasks().getByName("clean").dependsOn(new Object[]{"cleanDataModelApi"});
        }
    }
}

