/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.publishing;

import io.github.gradlenexus.publishplugin.NexusPublishExtension;
import io.github.gradlenexus.publishplugin.NexusPublishPlugin;
import io.github.gradlenexus.publishplugin.NexusRepository;
import java.net.URI;
import java.util.Set;
import java.util.SortedMap;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nebula.plugin.publishing.EnvironmentReader;
import nebula.plugin.publishing.NebulaOssPublishingExtension;
import nebula.plugin.publishing.pom.VerifyPomForMavenCentralTask;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnebula/plugin/publishing/MavenCentralPublishingPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/provider/ProviderFactory;)V", "apply", "", "project", "checkPublishCandidateToMavenCentral", "", "configureMavenCentralPomVerification", "getStagingProfileId", "", "isCandidateReleaseAndPublishingToMavenCentralIsEnabled", "isFinalRelease", "Companion", "nebula-oss-publishing-plugin"})
@SourceDebugExtension(value={"SMAP\nMavenCentralPublishingPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenCentralPublishingPlugin.kt\nnebula/plugin/publishing/MavenCentralPublishingPlugin\n+ 2 GradleApiKotlinDslExtensions29.kt\norg/gradle/kotlin/dsl/GradleApiKotlinDslExtensions29Kt\n+ 3 GradleApiKotlinDslExtensions24.kt\norg/gradle/kotlin/dsl/GradleApiKotlinDslExtensions24Kt\n+ 4 GradleApiKotlinDslExtensions33.kt\norg/gradle/kotlin/dsl/GradleApiKotlinDslExtensions33Kt\n*L\n1#1,165:1\n41#2:166\n86#3:167\n86#3:168\n77#4:169\n*S KotlinDebug\n*F\n+ 1 MavenCentralPublishingPlugin.kt\nnebula/plugin/publishing/MavenCentralPublishingPlugin\n*L\n60#1:166\n64#1:167\n113#1:168\n122#1:169\n*E\n"})
public final class MavenCentralPublishingPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProviderFactory providerFactory;
    @NotNull
    public static final String closeAndPromoteRepositoryTaskName = "closeAndReleaseSonatypeStagingRepository";
    @NotNull
    public static final String sonatypeOssRepositoryUrl = "https://oss.sonatype.org/service/local/";
    @NotNull
    public static final String nebulaMavenPublishPluginId = "com.netflix.nebula.maven-publish";
    @NotNull
    public static final String nebulaPublicationName = "nebula";

    @Inject
    public MavenCentralPublishingPlugin(@NotNull ProviderFactory providerFactory) {
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        this.providerFactory = providerFactory;
    }

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull Project project) {
        void $this$findByType$iv;
        void $this$apply$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project project2 = project.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.rootProject");
        if (!this.isFinalRelease(project2)) {
            Project project3 = project.getRootProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project.rootProject");
            if (!this.isCandidateReleaseAndPublishingToMavenCentralIsEnabled(project3)) {
                return;
            }
        }
        if (!Intrinsics.areEqual((Object)project.getRootProject(), (Object)project)) {
            project.afterEvaluate(new Action(project, this){
                final /* synthetic */ Project $project;
                final /* synthetic */ MavenCentralPublishingPlugin this$0;
                {
                    this.$project = $project;
                    this.this$0 = $receiver;
                }

                public final void execute(@NotNull Project $this$afterEvaluate) {
                    Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$this$afterEvaluate");
                    this.$project.getPlugins().withId("com.netflix.nebula.maven-publish", new Action(this.this$0, this.$project){
                        final /* synthetic */ MavenCentralPublishingPlugin this$0;
                        final /* synthetic */ Project $project;
                        {
                            this.this$0 = $receiver;
                            this.$project = $project;
                        }

                        public final void execute(@NotNull Plugin<?> $this$withId) {
                            Intrinsics.checkNotNullParameter($this$withId, (String)"$this$withId");
                            MavenCentralPublishingPlugin.access$configureMavenCentralPomVerification(this.this$0, this.$project);
                        }
                    });
                }
            });
            return;
        }
        PluginManager pluginManager = project.getPluginManager();
        Intrinsics.checkNotNullExpressionValue((Object)pluginManager, (String)"project.pluginManager");
        PluginManager pluginManager2 = pluginManager;
        Class<NexusPublishPlugin> type$iv = NexusPublishPlugin.class;
        boolean $i$f$apply22 = false;
        $this$apply$iv.apply(type$iv);
        NebulaOssPublishingExtension nebulaOssPublishingExtension = (NebulaOssPublishingExtension)project.getRootProject().getExtensions().findByType(NebulaOssPublishingExtension.class);
        if (nebulaOssPublishingExtension == null) {
            nebulaOssPublishingExtension = (NebulaOssPublishingExtension)project.getRootProject().getExtensions().create("nebulaOssPublishing", NebulaOssPublishingExtension.class, new Object[0]);
        }
        Intrinsics.checkNotNullExpressionValue((Object)nebulaOssPublishingExtension, (String)"project.rootProject.exte\u2026ingExtension::class.java)");
        NebulaOssPublishingExtension nebulaOssPublishingExtension2 = nebulaOssPublishingExtension;
        ExtensionContainer extensionContainer = project.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"project.extensions");
        ExtensionContainer $i$f$apply22 = extensionContainer;
        Class<NexusPublishExtension> type$iv2 = NexusPublishExtension.class;
        boolean $i$f$findByType = false;
        NexusPublishExtension nexusPublishExtension = (NexusPublishExtension)$this$findByType$iv.findByType(type$iv2);
        if (nexusPublishExtension == null) {
            throw new GradleException("Could not find registered NexusPublishExtension");
        }
        nexusPublishExtension.getPackageGroup().set(nebulaOssPublishingExtension2.getPackageGroup().get());
        nexusPublishExtension.getRepositories().sonatype(new Action(nebulaOssPublishingExtension2, this, project){
            final /* synthetic */ NebulaOssPublishingExtension $nebulaOssPublishingExtension;
            final /* synthetic */ MavenCentralPublishingPlugin this$0;
            final /* synthetic */ Project $project;
            {
                this.$nebulaOssPublishingExtension = $nebulaOssPublishingExtension;
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public final void execute(@NotNull NexusRepository $this$sonatype) {
                Intrinsics.checkNotNullParameter((Object)$this$sonatype, (String)"$this$sonatype");
                $this$sonatype.getNexusUrl().set((Object)new URI("https://oss.sonatype.org/service/local/"));
                $this$sonatype.getUsername().set(this.$nebulaOssPublishingExtension.getSonatypeUsername().get());
                $this$sonatype.getPassword().set(this.$nebulaOssPublishingExtension.getSonatypePassword().get());
                $this$sonatype.getStagingProfileId().set((Object)MavenCentralPublishingPlugin.access$getStagingProfileId(this.this$0, this.$project));
            }
        });
        project.afterEvaluate(new Action(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ MavenCentralPublishingPlugin this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(@NotNull Project $this$afterEvaluate) {
                void type$iv;
                void $this$withType$iv;
                Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$this$afterEvaluate");
                this.$project.getPlugins().withId("com.netflix.nebula.maven-publish", new Action(this.this$0, this.$project){
                    final /* synthetic */ MavenCentralPublishingPlugin this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                    }

                    public final void execute(@NotNull Plugin<?> $this$withId) {
                        Intrinsics.checkNotNullParameter($this$withId, (String)"$this$withId");
                        MavenCentralPublishingPlugin.access$configureMavenCentralPomVerification(this.this$0, this.$project);
                        this.$project.getRootProject().getTasks().named("postRelease").configure(new Action(this.$project){
                            final /* synthetic */ Project $project;
                            {
                                this.$project = $project;
                            }

                            public final void execute(@NotNull Task $this$configure) {
                                Intrinsics.checkNotNullParameter((Object)$this$configure, (String)"$this$configure");
                                Set set = this.$project.getSubprojects();
                                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"project.subprojects");
                                Iterable $this$forEach$iv = set;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    Project subproject = (Project)element$iv;
                                    boolean bl = false;
                                    Object[] objectArray = new Object[]{subproject.getTasks().withType(PublishToMavenRepository.class)};
                                    $this$configure.dependsOn(objectArray);
                                }
                            }
                        });
                    }
                });
                PluginContainer pluginContainer = this.$project.getRootProject().getPlugins();
                Intrinsics.checkNotNullExpressionValue((Object)pluginContainer, (String)"project.rootProject.plugins");
                DomainObjectCollection domainObjectCollection = (DomainObjectCollection)pluginContainer;
                Class<NexusPublishPlugin> clazz = NexusPublishPlugin.class;
                Action configureAction$iv = new Action(this.$project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                    }

                    public final void execute(@NotNull NexusPublishPlugin $this$withType) {
                        Intrinsics.checkNotNullParameter((Object)$this$withType, (String)"$this$withType");
                        this.$project.getRootProject().getTasks().named("postRelease").configure(new Action(this.$project){
                            final /* synthetic */ Project $project;
                            {
                                this.$project = $project;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void execute(@NotNull Task $this$configure) {
                                void $this$forEach$iv;
                                Intrinsics.checkNotNullParameter((Object)$this$configure, (String)"$this$configure");
                                Object object = new Object[]{this.$project.getRootProject().getTasks().named("closeAndReleaseSonatypeStagingRepository")};
                                $this$configure.dependsOn(object);
                                Set set = this.$project.getSubprojects();
                                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"project.subprojects");
                                object = set;
                                Project project = this.$project;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    Project subproject = (Project)element$iv;
                                    boolean bl = false;
                                    Set set2 = project.getSubprojects();
                                    Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"project.subprojects");
                                    Iterable $this$forEach$iv2 = set2;
                                    boolean $i$f$forEach2 = false;
                                    for (T element$iv2 : $this$forEach$iv2) {
                                        Project subproject2 = (Project)element$iv2;
                                        boolean bl2 = false;
                                        Object[] objectArray = new Object[]{subproject2.getTasks().withType(PublishToMavenRepository.class)};
                                        $this$configure.mustRunAfter(objectArray);
                                    }
                                }
                            }
                        });
                    }
                };
                boolean $i$f$withType = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$withType$iv.withType((Class)type$iv, configureAction$iv), (String)"`withType`(`type`.java, `configureAction`)");
            }
        });
    }

    private final String getStagingProfileId(Project project) {
        String string = new EnvironmentReader(this.providerFactory).findPropertyValue(project, "NETFLIX_OSS_SONATYPE_STAGING_PROFILE_ID", "sonatype.stagingProfileId", "sonatypeStagingProfileId");
        if (string == null) {
            string = "e84fb1d021017";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void configureMavenCentralPomVerification(Project project) {
        void type$iv;
        void name$iv;
        void $this$register$iv;
        void $this$findByType$iv;
        ExtensionContainer extensionContainer = project.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"project.extensions");
        ExtensionContainer extensionContainer2 = extensionContainer;
        Class<PublishingExtension> type$iv2 = PublishingExtension.class;
        boolean $i$f$findByType = false;
        PublishingExtension publishingExtension = (PublishingExtension)$this$findByType$iv.findByType(type$iv2);
        if (publishingExtension == null) {
            return;
        }
        PublishingExtension publishingExtension2 = publishingExtension;
        SortedMap sortedMap = publishingExtension2.getPublications().getAsMap();
        Intrinsics.checkNotNullExpressionValue((Object)sortedMap, (String)"publishingExtension.publications.asMap");
        SortedMap publications = sortedMap;
        if (!publications.containsKey(nebulaPublicationName)) {
            return;
        }
        Publication nebulaPublication = (Publication)publications.get(nebulaPublicationName);
        Task task = (Task)project.getTasks().findByName("generatePomFileFor" + StringsKt.capitalize((String)nebulaPublicationName) + "Publication");
        if (task == null) {
            return;
        }
        Task generateMavenPomTask = task;
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "verify" + StringsKt.capitalize((String)nebulaPublicationName) + "PublicationPomForMavenCentral";
        Class<VerifyPomForMavenCentralTask> clazz = VerifyPomForMavenCentralTask.class;
        Action configurationAction$iv = new Action(nebulaPublication, generateMavenPomTask){
            final /* synthetic */ Publication $nebulaPublication;
            final /* synthetic */ Task $generateMavenPomTask;
            {
                this.$nebulaPublication = $nebulaPublication;
                this.$generateMavenPomTask = $generateMavenPomTask;
            }

            public final void execute(@NotNull VerifyPomForMavenCentralTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                $this$register.setGroup("Publishing");
                $this$register.setDescription("Verifies " + this.$nebulaPublication + " POM can be published to Maven Central");
                RegularFileProperty regularFileProperty = $this$register.getPomFile();
                Task task = this.$generateMavenPomTask;
                Intrinsics.checkNotNull((Object)task, (String)"null cannot be cast to non-null type org.gradle.api.publish.maven.tasks.GenerateMavenPom");
                regularFileProperty.set(((GenerateMavenPom)task).getDestination());
                Object[] objectArray = new Object[]{this.$generateMavenPomTask};
                $this$register.dependsOn(objectArray);
            }
        };
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, (Class)type$iv, configurationAction$iv);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"`register`(`name`, `type\u2026a, `configurationAction`)");
        TaskProvider verifyPomForMavenCentralTask2 = taskProvider;
        project.getRootProject().getTasks().named("release").configure(new Action((TaskProvider<VerifyPomForMavenCentralTask>)verifyPomForMavenCentralTask2){
            final /* synthetic */ TaskProvider<VerifyPomForMavenCentralTask> $verifyPomForMavenCentralTask;
            {
                this.$verifyPomForMavenCentralTask = $verifyPomForMavenCentralTask;
            }

            public final void execute(@NotNull Task $this$configure) {
                Intrinsics.checkNotNullParameter((Object)$this$configure, (String)"$this$configure");
                Object[] objectArray = new Object[]{this.$verifyPomForMavenCentralTask};
                $this$configure.dependsOn(objectArray);
            }
        });
        project.getPlugins().withId("com.gradle.plugin-publish", new Action(project, (TaskProvider<VerifyPomForMavenCentralTask>)verifyPomForMavenCentralTask2){
            final /* synthetic */ Project $project;
            final /* synthetic */ TaskProvider<VerifyPomForMavenCentralTask> $verifyPomForMavenCentralTask;
            {
                this.$project = $project;
                this.$verifyPomForMavenCentralTask = $verifyPomForMavenCentralTask;
            }

            public final void execute(@NotNull Plugin<?> $this$withId) {
                Intrinsics.checkNotNullParameter($this$withId, (String)"$this$withId");
                this.$project.getTasks().named("publishPlugins").configure(new Action(this.$verifyPomForMavenCentralTask){
                    final /* synthetic */ TaskProvider<VerifyPomForMavenCentralTask> $verifyPomForMavenCentralTask;
                    {
                        this.$verifyPomForMavenCentralTask = $verifyPomForMavenCentralTask;
                    }

                    public final void execute(@NotNull Task $this$configure) {
                        Intrinsics.checkNotNullParameter((Object)$this$configure, (String)"$this$configure");
                        Object[] objectArray = new Object[]{this.$verifyPomForMavenCentralTask};
                        $this$configure.dependsOn(objectArray);
                    }
                });
            }
        });
    }

    private final boolean isFinalRelease(Project project) {
        return project.getGradle().getStartParameter().getTaskNames().contains("final") || project.getGradle().getStartParameter().getTaskNames().contains(":final");
    }

    private final boolean isCandidateReleaseAndPublishingToMavenCentralIsEnabled(Project project) {
        boolean isCandidate = project.getGradle().getStartParameter().getTaskNames().contains("candidate") || project.getGradle().getStartParameter().getTaskNames().contains(":candidate");
        boolean publishCandidateToMavenCentral = this.checkPublishCandidateToMavenCentral(project);
        return isCandidate && publishCandidateToMavenCentral;
    }

    private final boolean checkPublishCandidateToMavenCentral(Project project) {
        boolean netflixossAltCandidateRepo;
        if (project.hasProperty("netflixossAltCandidateRepo") && !(netflixossAltCandidateRepo = Boolean.parseBoolean(String.valueOf(project.property("netflixossAltCandidateRepo"))))) {
            return true;
        }
        if (project.hasProperty("netflixossPublishCandidatesToMavenCentral")) {
            return Boolean.parseBoolean(String.valueOf(project.property("netflixossPublishCandidatesToMavenCentral")));
        }
        return false;
    }

    public static final /* synthetic */ void access$configureMavenCentralPomVerification(MavenCentralPublishingPlugin $this, Project project) {
        $this.configureMavenCentralPomVerification(project);
    }

    public static final /* synthetic */ String access$getStagingProfileId(MavenCentralPublishingPlugin $this, Project project) {
        return $this.getStagingProfileId(project);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnebula/plugin/publishing/MavenCentralPublishingPlugin$Companion;", "", "()V", "closeAndPromoteRepositoryTaskName", "", "nebulaMavenPublishPluginId", "nebulaPublicationName", "sonatypeOssRepositoryUrl", "nebula-oss-publishing-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

