/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.publishing;

import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nebula.plugin.publishing.MavenCentralPublishingPlugin;
import nebula.plugin.publishing.NebulaOssPublishingExtension;
import nebula.plugin.publishing.NebulaOssRepositoriesPlugin;
import nebula.plugin.publishing.NebulaSigningPlugin;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J*\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0016\u0010\u001e\u001a\u0004\u0018\u00010\n*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lnebula/plugin/publishing/NebulaOssPublishingPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/provider/ProviderFactory;)V", "apply", "", "project", "findPropertyValue", "", "envVariableName", "namespacedPropertyName", "propertyName", "projectExecutionHasTask", "", "task", "readEnvVariable", "setDefaultNetflixOssRepository", "extension", "Lnebula/plugin/publishing/NebulaOssPublishingExtension;", "setExtensionDefaults", "nebulaOssPublishingExtension", "setMavenCentralCredentials", "setNetflixOssCredentials", "setNetflixOssRepositoryBaseUrl", "setPackageGroup", "setSigningKey", "setSigningPassword", "setStagingProfileId", "prop", "s", "Companion", "nebula-oss-publishing-plugin"})
@SourceDebugExtension(value={"SMAP\nNebulaOssPublishingPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NebulaOssPublishingPlugin.kt\nnebula/plugin/publishing/NebulaOssPublishingPlugin\n+ 2 GradleApiKotlinDslExtensions29.kt\norg/gradle/kotlin/dsl/GradleApiKotlinDslExtensions29Kt\n*L\n1#1,228:1\n41#2:229\n41#2:230\n41#2:231\n*S KotlinDebug\n*F\n+ 1 NebulaOssPublishingPlugin.kt\nnebula/plugin/publishing/NebulaOssPublishingPlugin\n*L\n42#1:229\n43#1:230\n44#1:231\n*E\n"})
public class NebulaOssPublishingPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProviderFactory providerFactory;
    @NotNull
    public static final String netflixOssDefaultRepositoryBaseUrl = "https://artifacts-oss.netflix.net/artifactory";
    @NotNull
    public static final String netflixOssGradlePluginsRepository = "gradle-plugins";
    @NotNull
    public static final String netflixOssSnapshotsRepository = "maven-oss-snapshots";
    @NotNull
    public static final String netflixOssCandidatesRepository = "maven-oss-candidates";
    @NotNull
    public static final String netflixOssReleasesRepository = "maven-oss-releases";
    @NotNull
    public static final String signingKeyFileLocation = "secrets/signing-key";
    @NotNull
    public static final String netflixDefaultStagingProfile = "e84fb1d021017";

    @Inject
    public NebulaOssPublishingPlugin(@NotNull ProviderFactory providerFactory) {
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        this.providerFactory = providerFactory;
    }

    public void apply(@NotNull Project project) {
        PluginManager $this$apply$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        NebulaOssPublishingExtension nebulaOssPublishingExtension = (NebulaOssPublishingExtension)project.getRootProject().getExtensions().findByType(NebulaOssPublishingExtension.class);
        if (nebulaOssPublishingExtension == null) {
            nebulaOssPublishingExtension = (NebulaOssPublishingExtension)project.getRootProject().getExtensions().create("nebulaOssPublishing", NebulaOssPublishingExtension.class, new Object[0]);
        }
        Intrinsics.checkNotNullExpressionValue((Object)nebulaOssPublishingExtension, (String)"project.rootProject.exte\u2026ingExtension::class.java)");
        NebulaOssPublishingExtension nebulaOssPublishingExtension2 = nebulaOssPublishingExtension;
        this.setExtensionDefaults(nebulaOssPublishingExtension2, project);
        PluginManager pluginManager = project.getPluginManager();
        Intrinsics.checkNotNullExpressionValue((Object)pluginManager, (String)"project.pluginManager");
        PluginManager pluginManager2 = pluginManager;
        Class type$iv = NebulaSigningPlugin.class;
        boolean $i$f$apply = false;
        $this$apply$iv.apply(type$iv);
        PluginManager pluginManager3 = project.getPluginManager();
        Intrinsics.checkNotNullExpressionValue((Object)pluginManager3, (String)"project.pluginManager");
        $this$apply$iv = pluginManager3;
        type$iv = MavenCentralPublishingPlugin.class;
        $i$f$apply = false;
        $this$apply$iv.apply(type$iv);
        PluginManager pluginManager4 = project.getPluginManager();
        Intrinsics.checkNotNullExpressionValue((Object)pluginManager4, (String)"project.pluginManager");
        $this$apply$iv = pluginManager4;
        type$iv = NebulaOssRepositoriesPlugin.class;
        $i$f$apply = false;
        $this$apply$iv.apply(type$iv);
    }

    private final void setExtensionDefaults(NebulaOssPublishingExtension nebulaOssPublishingExtension, Project project) {
        this.setMavenCentralCredentials(nebulaOssPublishingExtension, project);
        this.setStagingProfileId(nebulaOssPublishingExtension, project);
        this.setPackageGroup(nebulaOssPublishingExtension, project);
        this.setSigningKey(nebulaOssPublishingExtension, project);
        this.setSigningPassword(nebulaOssPublishingExtension, project);
        this.setNetflixOssCredentials(nebulaOssPublishingExtension, project);
        this.setNetflixOssRepositoryBaseUrl(nebulaOssPublishingExtension, project);
        this.setDefaultNetflixOssRepository(nebulaOssPublishingExtension, project);
    }

    private final void setStagingProfileId(NebulaOssPublishingExtension extension, Project project) {
        String stagingProfileId;
        String string = this.findPropertyValue(project, "NETFLIX_OSS_SONATYPE_STAGING_PROFILE_ID", "sonatype.stagingProfileId", "sonatypeStagingProfileId");
        if (string == null) {
            string = netflixDefaultStagingProfile;
        }
        if (!(!StringsKt.isBlank((CharSequence)(stagingProfileId = string)))) {
            extension.getStagingProfileId().convention((Object)stagingProfileId);
        }
    }

    private final void setPackageGroup(NebulaOssPublishingExtension extension, Project project) {
        String packageGroup;
        String string = this.findPropertyValue(project, "NETFLIX_OSS_SONATYPE_PACKAGE_GROUP", "sonatype.packageGroup", "sonatypePackageGroup");
        if (string == null) {
            String[] stringArray = new String[]{"."};
            string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)StringsKt.split$default((CharSequence)project.getGroup().toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)2), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        }
        if (!StringsKt.isBlank((CharSequence)(packageGroup = string))) {
            extension.getPackageGroup().convention((Object)packageGroup);
        }
    }

    private final void setSigningKey(NebulaOssPublishingExtension extension, Project project) {
        File file = project.getRootProject().file((Object)signingKeyFileLocation);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.rootProject.file(signingKeyFileLocation)");
        File signingKeyFile = file;
        if (signingKeyFile.exists()) {
            extension.getSigningKey().convention((Object)FilesKt.readText$default((File)signingKeyFile, null, (int)1, null));
        } else {
            String signingKey = this.findPropertyValue(project, "NETFLIX_OSS_SIGNING_KEY", "sonatype.signingKey", "netflixOssSigningKey");
            CharSequence charSequence = signingKey;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                extension.getSigningKey().convention((Object)signingKey);
            }
        }
    }

    private final void setSigningPassword(NebulaOssPublishingExtension extension, Project project) {
        String signingPassword = this.findPropertyValue(project, "NETFLIX_OSS_SIGNING_PASSWORD", "sonatype.signingPassword", "netflixOssSigningPassword");
        CharSequence charSequence = signingPassword;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            extension.getSigningPassword().convention((Object)signingPassword);
        }
    }

    private final void setNetflixOssCredentials(NebulaOssPublishingExtension extension, Project project) {
        String netflixOssPassword;
        CharSequence charSequence;
        String netflixOssUsername = this.findPropertyValue(project, "NETFLIX_OSS_REPO_USERNAME", "netflixOss.username", "netflixOssUsername");
        CharSequence charSequence2 = netflixOssUsername;
        if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
            extension.getNetflixOssUsername().convention((Object)netflixOssUsername);
        }
        if (!((charSequence = (CharSequence)(netflixOssPassword = this.findPropertyValue(project, "NETFLIX_OSS_REPO_PASSWORD", "netflixOss.password", "netflixOssPassword"))) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            extension.getNetflixOssPassword().convention((Object)netflixOssPassword);
        }
    }

    private final void setMavenCentralCredentials(NebulaOssPublishingExtension extension, Project project) {
        String sonatypePassword;
        CharSequence charSequence;
        String sonatypeUsername = this.findPropertyValue(project, "NETFLIX_OSS_SONATYPE_USERNAME", "sonatype.username", "sonatypeUsername");
        CharSequence charSequence2 = sonatypeUsername;
        if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
            extension.getSonatypeUsername().convention((Object)sonatypeUsername);
        }
        if (!((charSequence = (CharSequence)(sonatypePassword = this.findPropertyValue(project, "NETFLIX_OSS_SONATYPE_PASSWORD", "sonatype.password", "sonatypePassword"))) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            extension.getSonatypePassword().convention((Object)sonatypePassword);
        }
    }

    private final void setNetflixOssRepositoryBaseUrl(NebulaOssPublishingExtension extension, Project project) {
        String repositoryBaseUrl = this.findPropertyValue(project, "NETFLIX_OSS_REPOSITORY_BASE_URL", "netflixOss.repositoryBaseUrl", "netflixOssRepositoryBaseUrl");
        CharSequence charSequence = repositoryBaseUrl;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            extension.getNetflixOssRepositoryBaseUrl().convention((Object)repositoryBaseUrl);
        } else {
            extension.getNetflixOssRepositoryBaseUrl().convention((Object)netflixOssDefaultRepositoryBaseUrl);
        }
    }

    private final void setDefaultNetflixOssRepository(NebulaOssPublishingExtension extension, Project project) {
        project.getRootProject().getPluginManager().withPlugin("nebula.plugin-plugin", new Action(extension){
            final /* synthetic */ NebulaOssPublishingExtension $extension;
            {
                this.$extension = $extension;
            }

            public final void execute(@NotNull AppliedPlugin $this$withPlugin) {
                Intrinsics.checkNotNullParameter((Object)$this$withPlugin, (String)"$this$withPlugin");
                this.$extension.getNetflixOssRepository().convention((Object)"gradle-plugins");
            }
        });
        project.getRootProject().getPluginManager().withPlugin("com.netflix.nebula.plugin-plugin", new Action(extension){
            final /* synthetic */ NebulaOssPublishingExtension $extension;
            {
                this.$extension = $extension;
            }

            public final void execute(@NotNull AppliedPlugin $this$withPlugin) {
                Intrinsics.checkNotNullParameter((Object)$this$withPlugin, (String)"$this$withPlugin");
                this.$extension.getNetflixOssRepository().convention((Object)"gradle-plugins");
            }
        });
        project.getRootProject().getPluginManager().withPlugin("nebula.netflixoss", new Action(this, project, extension){
            final /* synthetic */ NebulaOssPublishingPlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ NebulaOssPublishingExtension $extension;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$extension = $extension;
            }

            public final void execute(@NotNull AppliedPlugin $this$withPlugin) {
                Intrinsics.checkNotNullParameter((Object)$this$withPlugin, (String)"$this$withPlugin");
                if (NebulaOssPublishingPlugin.access$projectExecutionHasTask(this.this$0, this.$project, "snapshot") || NebulaOssPublishingPlugin.access$projectExecutionHasTask(this.this$0, this.$project, "devSnapshot") || NebulaOssPublishingPlugin.access$projectExecutionHasTask(this.this$0, this.$project, "immutableSnapshot")) {
                    this.$extension.getNetflixOssRepository().convention((Object)"maven-oss-snapshots");
                } else if (NebulaOssPublishingPlugin.access$projectExecutionHasTask(this.this$0, this.$project, "candidate")) {
                    this.$extension.getNetflixOssRepository().convention((Object)"maven-oss-candidates");
                } else if (NebulaOssPublishingPlugin.access$projectExecutionHasTask(this.this$0, this.$project, "final")) {
                    this.$extension.getNetflixOssRepository().convention((Object)"maven-oss-releases");
                }
            }
        });
        project.getRootProject().getPluginManager().withPlugin("com.netflix.nebula.netflixoss", new Action(this, project, extension){
            final /* synthetic */ NebulaOssPublishingPlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ NebulaOssPublishingExtension $extension;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$extension = $extension;
            }

            public final void execute(@NotNull AppliedPlugin $this$withPlugin) {
                Intrinsics.checkNotNullParameter((Object)$this$withPlugin, (String)"$this$withPlugin");
                if (NebulaOssPublishingPlugin.access$projectExecutionHasTask(this.this$0, this.$project, "snapshot") || NebulaOssPublishingPlugin.access$projectExecutionHasTask(this.this$0, this.$project, "devSnapshot") || NebulaOssPublishingPlugin.access$projectExecutionHasTask(this.this$0, this.$project, "immutableSnapshot")) {
                    this.$extension.getNetflixOssRepository().convention((Object)"maven-oss-snapshots");
                } else if (NebulaOssPublishingPlugin.access$projectExecutionHasTask(this.this$0, this.$project, "candidate")) {
                    this.$extension.getNetflixOssRepository().convention((Object)"maven-oss-candidates");
                } else if (NebulaOssPublishingPlugin.access$projectExecutionHasTask(this.this$0, this.$project, "final")) {
                    this.$extension.getNetflixOssRepository().convention((Object)"maven-oss-releases");
                }
            }
        });
    }

    private final boolean projectExecutionHasTask(Project project, String task) {
        return project.getGradle().getStartParameter().getTaskNames().contains(task) || project.getGradle().getStartParameter().getTaskNames().contains(':' + task);
    }

    private final String findPropertyValue(Project project, String envVariableName, String namespacedPropertyName, String propertyName) {
        String propertyValueFromEnv = this.readEnvVariable(envVariableName);
        return propertyValueFromEnv != null ? propertyValueFromEnv : (project.hasProperty(propertyName) ? this.prop(project, propertyName) : (project.hasProperty(namespacedPropertyName) ? this.prop(project, namespacedPropertyName) : null));
    }

    private final String readEnvVariable(String envVariableName) {
        Provider provider = this.providerFactory.environmentVariable(envVariableName).forUseAtConfigurationTime();
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"providerFactory.environm\u2026rUseAtConfigurationTime()");
        Provider envVariable = provider;
        return envVariable.isPresent() ? (String)envVariable.get() : null;
    }

    private final String prop(Project $this$prop, String s) {
        return (String)$this$prop.getProject().findProperty(s);
    }

    public static final /* synthetic */ boolean access$projectExecutionHasTask(NebulaOssPublishingPlugin $this, Project project, String task) {
        return $this.projectExecutionHasTask(project, task);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnebula/plugin/publishing/NebulaOssPublishingPlugin$Companion;", "", "()V", "netflixDefaultStagingProfile", "", "netflixOssCandidatesRepository", "netflixOssDefaultRepositoryBaseUrl", "netflixOssGradlePluginsRepository", "netflixOssReleasesRepository", "netflixOssSnapshotsRepository", "signingKeyFileLocation", "nebula-oss-publishing-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

