/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.publishing.pom;

import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nebula.plugin.publishing.pom.MavenCentralPomVerifier;
import nebula.plugin.publishing.pom.PomParser;
import org.apache.maven.model.Model;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0007R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lnebula/plugin/publishing/pom/VerifyPomForMavenCentralTask;", "Lorg/gradle/api/DefaultTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "pomFile", "Lorg/gradle/api/file/RegularFileProperty;", "getPomFile", "()Lorg/gradle/api/file/RegularFileProperty;", "verifyPom", "", "nebula-oss-publishing-plugin"})
public class VerifyPomForMavenCentralTask
extends DefaultTask {
    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    private final RegularFileProperty pomFile;

    @Inject
    public VerifyPomForMavenCentralTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        RegularFileProperty regularFileProperty = objects.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objects.fileProperty()");
        this.pomFile = regularFileProperty;
    }

    @NotNull
    public final RegularFileProperty getPomFile() {
        return this.pomFile;
    }

    @TaskAction
    public final void verifyPom() {
        Object object = this.pomFile.getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pomFile.asFile.get()");
        Model model = PomParser.Companion.parse((File)object);
        MavenCentralPomVerifier.Companion.verify(model);
    }
}

