/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.publishing.verification;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.Set;
import nebula.plugin.publishing.verification.StatusVerificationViolation;
import nebula.plugin.publishing.verification.VersionSelectorVerificationViolation;
import nebula.plugin.publishing.verification.ViolationsContainer;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;

public class VerificationReportGenerator
implements GroovyObject {
    private static final String INDENTATION = "    ";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public VerificationReportGenerator() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public String generateReport(Map<String, ViolationsContainer> violationsPerProject, String targetStatus) {
        StringBuilder builder = new StringBuilder();
        builder.append(StringGroovyMethods.plus((String)INDENTATION, (CharSequence)"\n"));
        if (this.hasAnyStatusViolations(violationsPerProject)) {
            this.generateStatusViolations(builder, targetStatus, violationsPerProject);
        }
        if (this.hasAnyVersionSelectorViolations(violationsPerProject)) {
            this.generateVersionSelectorViolations(builder, violationsPerProject);
        }
        builder.append(StringGroovyMethods.plus((String)INDENTATION, (CharSequence)"ATTENTION: If suggested steps for violations cannot be resolved you can ignore them using the following configurations.\n"));
        if (violationsPerProject.size() == 1) {
            this.singleModuleProjectIgnoreBlock(builder, violationsPerProject);
        } else {
            this.multiModuleProjectIgnoreBlock(builder, violationsPerProject);
        }
        return builder.toString();
    }

    private boolean hasAnyStatusViolations(Map<String, ViolationsContainer> violationsPerProject) {
        public final class _hasAnyStatusViolations_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _hasAnyStatusViolations_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((ViolationsContainer)((Map.Entry)it).getValue()).getStatusViolations().size() > 0;
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _hasAnyStatusViolations_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.any(violationsPerProject, (Closure)new _hasAnyStatusViolations_closure1(this, this));
    }

    private void generateStatusViolations(StringBuilder builder, String targetStatus, Map<String, ViolationsContainer> violationsPerProject) {
        Reference builder2 = new Reference((Object)builder);
        ((StringBuilder)builder2.get()).append(StringGroovyMethods.plus((String)INDENTATION, (CharSequence)new GStringImpl(new Object[]{targetStatus}, new String[]{"Following dependencies have incorrect status lower then your current project status '", "':\n"})));
        public final class _generateStatusViolations_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference builder;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _generateStatusViolations_closure2(Object _outerInstance, Object _thisObject, Reference builder) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.builder = reference = builder;
            }

            public Object doCall(Object key, Object value) {
                if (((ViolationsContainer)value).getStatusViolations().size() > 0) {
                    ((StringBuilder)this.builder.get()).append((CharSequence)new GStringImpl(new Object[]{VerificationReportGenerator.pfaccess$0(null), key}, new String[]{"\n", "Dependencies for ", ":\n"}));
                    public final class _closure13
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference builder;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure13(Object _outerInstance, Object _thisObject, Reference builder) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.builder = reference = builder;
                        }

                        public Object doCall(Object it) {
                            return ((StringBuilder)this.builder.get()).append(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)VerificationReportGenerator.pfaccess$0(null), (CharSequence)new GStringImpl(new Object[]{((StatusVerificationViolation)it).getId().getGroup(), ((StatusVerificationViolation)it).getId().getName(), ((StatusVerificationViolation)it).getId().getVersion()}, new String[]{"    '", ":", "' resolved to version '", "',"})), (CharSequence)new GStringImpl(new Object[]{((StatusVerificationViolation)it).getStatus(), ((StatusVerificationViolation)it).getStatusScheme()}, new String[]{" status: '", "' in status scheme: ", "\n"})));
                        }

                        @Generated
                        public StringBuilder getBuilder() {
                            return (StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.builder.get(), StringBuilder.class);
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure13.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    return DefaultGroovyMethods.each(((ViolationsContainer)value).getStatusViolations(), (Closure)new _closure13((Object)this, this.getThisObject(), this.builder));
                }
                return null;
            }

            @Generated
            public Object call(Object key, Object value) {
                return this.doCall(key, value);
            }

            @Generated
            public StringBuilder getBuilder() {
                return (StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.builder.get(), StringBuilder.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generateStatusViolations_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(violationsPerProject, (Closure)new _generateStatusViolations_closure2(this, this, builder2));
        ((StringBuilder)builder2.get()).append(StringGroovyMethods.plus((String)INDENTATION, (CharSequence)"HOW TO RESOLVE: https://github.com/nebula-plugins/nebula-publishing-plugin#your-dependency-has-a-lower-status-then-your-project-violation\n"));
        ((StringBuilder)builder2.get()).append(StringGroovyMethods.plus((String)INDENTATION, (CharSequence)"\n"));
    }

    private boolean hasAnyVersionSelectorViolations(Map<String, ViolationsContainer> violationsPerProject) {
        public final class _hasAnyVersionSelectorViolations_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _hasAnyVersionSelectorViolations_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ((ViolationsContainer)((Map.Entry)it).getValue()).getVersionSelectorViolations().size() > 0;
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _hasAnyVersionSelectorViolations_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.any(violationsPerProject, (Closure)new _hasAnyVersionSelectorViolations_closure3(this, this));
    }

    private void generateVersionSelectorViolations(StringBuilder builder, Map<String, ViolationsContainer> violationsPerProject) {
        Reference builder2 = new Reference((Object)builder);
        ((StringBuilder)builder2.get()).append(StringGroovyMethods.plus((String)INDENTATION, (CharSequence)"Following dependencies have version definition with patterns which resolves into unexpected version.\n"));
        public final class _generateVersionSelectorViolations_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference builder;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _generateVersionSelectorViolations_closure4(Object _outerInstance, Object _thisObject, Reference builder) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.builder = reference = builder;
            }

            public Object doCall(Object key, Object value) {
                if (((ViolationsContainer)value).getVersionSelectorViolations().size() > 0) {
                    ((StringBuilder)this.builder.get()).append((CharSequence)new GStringImpl(new Object[]{VerificationReportGenerator.pfaccess$0(null), key}, new String[]{"\n", "Dependencies for ", ":\n"}));
                    public final class _closure14
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference builder;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure14(Object _outerInstance, Object _thisObject, Reference builder) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.builder = reference = builder;
                        }

                        public Object doCall(Object it) {
                            return ((StringBuilder)this.builder.get()).append(StringGroovyMethods.plus((String)VerificationReportGenerator.pfaccess$0(null), (CharSequence)new GStringImpl(new Object[]{((VersionSelectorVerificationViolation)it).getDependency().getGroup(), ((VersionSelectorVerificationViolation)it).getDependency().getName(), ((VersionSelectorVerificationViolation)it).getDependency().getVersion()}, new String[]{"    '", ":", "' with requested version '", "'\n"})));
                        }

                        @Generated
                        public StringBuilder getBuilder() {
                            return (StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.builder.get(), StringBuilder.class);
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure14.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    return DefaultGroovyMethods.each(((ViolationsContainer)value).getVersionSelectorViolations(), (Closure)new _closure14((Object)this, this.getThisObject(), this.builder));
                }
                return null;
            }

            @Generated
            public Object call(Object key, Object value) {
                return this.doCall(key, value);
            }

            @Generated
            public StringBuilder getBuilder() {
                return (StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.builder.get(), StringBuilder.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generateVersionSelectorViolations_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(violationsPerProject, (Closure)new _generateVersionSelectorViolations_closure4(this, this, builder2));
        ((StringBuilder)builder2.get()).append(StringGroovyMethods.plus((String)INDENTATION, (CharSequence)"HOW TO RESOLVE: https://github.com/nebula-plugins/nebula-publishing-plugin#your-dependency-has-incorrect-subversion-definition\n"));
        ((StringBuilder)builder2.get()).append("\n");
    }

    private void singleModuleProjectIgnoreBlock(StringBuilder builder, Map<String, ViolationsContainer> violationsPerProject) {
        CallSite[] callSiteArray = VerificationReportGenerator.$getCallSiteArray();
        callSiteArray[0].call((Object)builder, callSiteArray[1].call((Object)INDENTATION, (Object)"Place following configuration at the end of your project build.gradle file\n\n"));
        callSiteArray[2].call((Object)builder, callSiteArray[3].call((Object)INDENTATION, (Object)"nebulaPublishVerification {\n"));
        Object violationContainer = callSiteArray[4].call(callSiteArray[5].call(violationsPerProject));
        public final class _singleModuleProjectIgnoreBlock_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _singleModuleProjectIgnoreBlock_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _singleModuleProjectIgnoreBlock_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _singleModuleProjectIgnoreBlock_closure5.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty(it));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _singleModuleProjectIgnoreBlock_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _singleModuleProjectIgnoreBlock_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "module";
                stringArray[1] = "id";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _singleModuleProjectIgnoreBlock_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_singleModuleProjectIgnoreBlock_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _singleModuleProjectIgnoreBlock_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Set modulesForIgnore = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].call(callSiteArray[7].callGetProperty(violationContainer), (Object)new _singleModuleProjectIgnoreBlock_closure5(this, this)), Set.class);
        public final class _singleModuleProjectIgnoreBlock_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _singleModuleProjectIgnoreBlock_closure6(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _singleModuleProjectIgnoreBlock_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _singleModuleProjectIgnoreBlock_closure6.$getCallSiteArray();
                return callSiteArray[0].call(DefaultModuleIdentifier.class, callSiteArray[1].callGetProperty(callSiteArray[2].callGetProperty(it)), callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(it)));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _singleModuleProjectIgnoreBlock_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _singleModuleProjectIgnoreBlock_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "newId";
                stringArray[1] = "group";
                stringArray[2] = "dependency";
                stringArray[3] = "name";
                stringArray[4] = "dependency";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _singleModuleProjectIgnoreBlock_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_singleModuleProjectIgnoreBlock_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _singleModuleProjectIgnoreBlock_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        modulesForIgnore = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].call((Object)modulesForIgnore, callSiteArray[9].call(callSiteArray[10].callGetProperty(violationContainer), (Object)new _singleModuleProjectIgnoreBlock_closure6(this, this))), Set.class);
        public final class _singleModuleProjectIgnoreBlock_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _singleModuleProjectIgnoreBlock_closure7(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _singleModuleProjectIgnoreBlock_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _singleModuleProjectIgnoreBlock_closure7.$getCallSiteArray();
                return callSiteArray[0].call(ScriptBytecodeAdapter.getField(_singleModuleProjectIgnoreBlock_closure7.class, VerificationReportGenerator.class, (String)"INDENTATION"), (Object)new GStringImpl(new Object[]{it}, new String[]{"    ignore('", "')\n"}));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _singleModuleProjectIgnoreBlock_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _singleModuleProjectIgnoreBlock_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "plus";
                return new CallSiteArray(_singleModuleProjectIgnoreBlock_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _singleModuleProjectIgnoreBlock_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[11].call((Object)builder, callSiteArray[12].call(callSiteArray[13].call((Object)modulesForIgnore, (Object)new _singleModuleProjectIgnoreBlock_closure7(this, this)), (Object)""));
        callSiteArray[14].call((Object)builder, callSiteArray[15].call((Object)INDENTATION, (Object)"}\n"));
    }

    private void multiModuleProjectIgnoreBlock(StringBuilder builder, Map<String, ViolationsContainer> violationsPerProject) {
        CallSite[] callSiteArray = VerificationReportGenerator.$getCallSiteArray();
        callSiteArray[16].call((Object)builder, callSiteArray[17].call((Object)INDENTATION, (Object)"Place following configuration at the end of your root project build.gradle file\n\n"));
        callSiteArray[18].call((Object)builder, callSiteArray[19].call((Object)INDENTATION, (Object)"allprojects {\n"));
        callSiteArray[20].call((Object)builder, callSiteArray[21].call((Object)INDENTATION, (Object)"    nebulaPublishVerification {\n"));
        Object violationsContainers = callSiteArray[22].call(violationsPerProject);
        public final class _multiModuleProjectIgnoreBlock_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _multiModuleProjectIgnoreBlock_closure8(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _multiModuleProjectIgnoreBlock_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _multiModuleProjectIgnoreBlock_closure8.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _multiModuleProjectIgnoreBlock_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _multiModuleProjectIgnoreBlock_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "statusViolations";
                return new CallSiteArray(_multiModuleProjectIgnoreBlock_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _multiModuleProjectIgnoreBlock_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _multiModuleProjectIgnoreBlock_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _multiModuleProjectIgnoreBlock_closure9(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _multiModuleProjectIgnoreBlock_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _multiModuleProjectIgnoreBlock_closure9.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty(it));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _multiModuleProjectIgnoreBlock_closure9.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _multiModuleProjectIgnoreBlock_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "module";
                stringArray[1] = "id";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _multiModuleProjectIgnoreBlock_closure9.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_multiModuleProjectIgnoreBlock_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _multiModuleProjectIgnoreBlock_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Set modulesForIgnore = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].call(callSiteArray[24].call(callSiteArray[25].call(callSiteArray[26].call(violationsContainers, (Object)new _multiModuleProjectIgnoreBlock_closure8(this, this))), (Object)new _multiModuleProjectIgnoreBlock_closure9(this, this))), Set.class);
        public final class _multiModuleProjectIgnoreBlock_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _multiModuleProjectIgnoreBlock_closure10(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _multiModuleProjectIgnoreBlock_closure10.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _multiModuleProjectIgnoreBlock_closure10.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _multiModuleProjectIgnoreBlock_closure10.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _multiModuleProjectIgnoreBlock_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "versionSelectorViolations";
                return new CallSiteArray(_multiModuleProjectIgnoreBlock_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _multiModuleProjectIgnoreBlock_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _multiModuleProjectIgnoreBlock_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _multiModuleProjectIgnoreBlock_closure11(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _multiModuleProjectIgnoreBlock_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _multiModuleProjectIgnoreBlock_closure11.$getCallSiteArray();
                return callSiteArray[0].call(DefaultModuleIdentifier.class, callSiteArray[1].callGetProperty(callSiteArray[2].callGetProperty(it)), callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(it)));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _multiModuleProjectIgnoreBlock_closure11.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _multiModuleProjectIgnoreBlock_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "newId";
                stringArray[1] = "group";
                stringArray[2] = "dependency";
                stringArray[3] = "name";
                stringArray[4] = "dependency";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _multiModuleProjectIgnoreBlock_closure11.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_multiModuleProjectIgnoreBlock_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _multiModuleProjectIgnoreBlock_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        modulesForIgnore = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].call((Object)modulesForIgnore, callSiteArray[28].call(callSiteArray[29].call(callSiteArray[30].call(callSiteArray[31].call(violationsContainers, (Object)new _multiModuleProjectIgnoreBlock_closure10(this, this))), (Object)new _multiModuleProjectIgnoreBlock_closure11(this, this)))), Set.class);
        public final class _multiModuleProjectIgnoreBlock_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _multiModuleProjectIgnoreBlock_closure12(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _multiModuleProjectIgnoreBlock_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _multiModuleProjectIgnoreBlock_closure12.$getCallSiteArray();
                return callSiteArray[0].call(ScriptBytecodeAdapter.getField(_multiModuleProjectIgnoreBlock_closure12.class, VerificationReportGenerator.class, (String)"INDENTATION"), (Object)new GStringImpl(new Object[]{it}, new String[]{"        ignore('", "')\n"}));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _multiModuleProjectIgnoreBlock_closure12.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _multiModuleProjectIgnoreBlock_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "plus";
                return new CallSiteArray(_multiModuleProjectIgnoreBlock_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _multiModuleProjectIgnoreBlock_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[32].call((Object)builder, callSiteArray[33].call(callSiteArray[34].call((Object)modulesForIgnore, (Object)new _multiModuleProjectIgnoreBlock_closure12(this, this)), (Object)""));
        callSiteArray[35].call((Object)builder, callSiteArray[36].call((Object)INDENTATION, (Object)"    }\n"));
        callSiteArray[37].call((Object)builder, callSiteArray[38].call((Object)INDENTATION, (Object)"}\n"));
    }

    public static /* synthetic */ String pfaccess$0(VerificationReportGenerator $that) {
        return ShortTypeHandling.castToString((Object)ScriptBytecodeAdapter.getField(VerificationReportGenerator.class, VerificationReportGenerator.class, (String)"INDENTATION"));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != VerificationReportGenerator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "append";
        stringArray[1] = "plus";
        stringArray[2] = "append";
        stringArray[3] = "plus";
        stringArray[4] = "first";
        stringArray[5] = "values";
        stringArray[6] = "collect";
        stringArray[7] = "statusViolations";
        stringArray[8] = "plus";
        stringArray[9] = "collect";
        stringArray[10] = "versionSelectorViolations";
        stringArray[11] = "append";
        stringArray[12] = "join";
        stringArray[13] = "collect";
        stringArray[14] = "append";
        stringArray[15] = "plus";
        stringArray[16] = "append";
        stringArray[17] = "plus";
        stringArray[18] = "append";
        stringArray[19] = "plus";
        stringArray[20] = "append";
        stringArray[21] = "plus";
        stringArray[22] = "values";
        stringArray[23] = "toSet";
        stringArray[24] = "collect";
        stringArray[25] = "flatten";
        stringArray[26] = "collect";
        stringArray[27] = "plus";
        stringArray[28] = "toSet";
        stringArray[29] = "collect";
        stringArray[30] = "flatten";
        stringArray[31] = "collect";
        stringArray[32] = "append";
        stringArray[33] = "join";
        stringArray[34] = "collect";
        stringArray[35] = "append";
        stringArray[36] = "plus";
        stringArray[37] = "append";
        stringArray[38] = "plus";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[39];
        VerificationReportGenerator.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(VerificationReportGenerator.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = VerificationReportGenerator.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

