/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.publishing.verification;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import nebula.plugin.publishing.verification.StatusVerificationViolation;
import nebula.plugin.publishing.verification.VersionSelectorVerificationViolation;
import nebula.plugin.publishing.verification.ViolationsContainer;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;

public class VerificationReportGenerator
implements GroovyObject {
    private static final String INDENTATION = "    ";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public VerificationReportGenerator() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public String generateReport(Map<String, ViolationsContainer> violationsPerProject, String targetStatus) {
        StringBuilder builder = new StringBuilder();
        builder.append(StringGroovyMethods.plus((String)INDENTATION, (CharSequence)"\n"));
        if (this.hasAnyStatusViolations(violationsPerProject)) {
            this.generateStatusViolations(builder, targetStatus, violationsPerProject);
        }
        if (this.hasAnyVersionSelectorViolations(violationsPerProject)) {
            this.generateVersionSelectorViolations(builder, violationsPerProject);
        }
        builder.append(StringGroovyMethods.plus((String)INDENTATION, (CharSequence)"ATTENTION: If suggested steps for violations cannot be resolved you can ignore them using the following configurations.\n"));
        if (violationsPerProject.size() == 1) {
            this.singleModuleProjectIgnoreBlock(builder, violationsPerProject);
        } else {
            this.multiModuleProjectIgnoreBlock(builder, violationsPerProject);
        }
        return builder.toString();
    }

    private boolean hasAnyStatusViolations(Map<String, ViolationsContainer> violationsPerProject) {
        public final class _hasAnyStatusViolations_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _hasAnyStatusViolations_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Object it) {
                return ((ViolationsContainer)((Map.Entry)it).getValue()).getStatusViolations().size() > 0;
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _hasAnyStatusViolations_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return DefaultGroovyMethods.any(violationsPerProject, (Closure)new _hasAnyStatusViolations_closure1(this, this));
    }

    private void generateStatusViolations(StringBuilder builder, String targetStatus, Map<String, ViolationsContainer> violationsPerProject) {
        Reference builder2 = new Reference((Object)builder);
        ((StringBuilder)builder2.get()).append(StringGroovyMethods.plus((String)INDENTATION, (CharSequence)new GStringImpl(new Object[]{targetStatus}, new String[]{"Following dependencies have incorrect status lower then your current project status '", "':\n"})));
        public final class _generateStatusViolations_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference builder;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _generateStatusViolations_closure2(Object _outerInstance, Object _thisObject, Reference builder) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.builder = reference = builder;
            }

            public List<StatusVerificationViolation> doCall(Object key, Object value) {
                if (((ViolationsContainer)value).getStatusViolations().size() > 0) {
                    ((StringBuilder)((Object)IndyInterface.bootstrap("cast", "()", 0, this.builder.get()))).append((CharSequence)new GStringImpl(new Object[]{VerificationReportGenerator.pfaccess$0(null), key}, new String[]{"\n", "Dependencies for ", ":\n"}));
                    public final class _closure13
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference builder;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure13(Object _outerInstance, Object _thisObject, Reference builder) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.builder = reference = builder;
                        }

                        public StringBuilder doCall(Object it) {
                            return ((StringBuilder)((Object)IndyInterface.bootstrap("cast", "()", 0, this.builder.get()))).append(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)VerificationReportGenerator.pfaccess$0(null), (CharSequence)new GStringImpl(new Object[]{((StatusVerificationViolation)it).getId().getGroup(), ((StatusVerificationViolation)it).getId().getName(), ((StatusVerificationViolation)it).getId().getVersion()}, new String[]{"    '", ":", "' resolved to version '", "',"})), (CharSequence)new GStringImpl(new Object[]{((StatusVerificationViolation)it).getStatus(), ((StatusVerificationViolation)it).getStatusScheme()}, new String[]{" status: '", "' in status scheme: ", "\n"})));
                        }

                        @Generated
                        public StringBuilder getBuilder() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.builder.get());
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public StringBuilder doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure13.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return DefaultGroovyMethods.each(((ViolationsContainer)value).getStatusViolations(), (Closure)new _closure13((Object)this, this.getThisObject(), this.builder));
                }
                return null;
            }

            @Generated
            public List<StatusVerificationViolation> call(Object key, Object value) {
                return this.doCall(key, value);
            }

            @Generated
            public StringBuilder getBuilder() {
                return IndyInterface.bootstrap("cast", "()", 0, this.builder.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generateStatusViolations_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        DefaultGroovyMethods.each(violationsPerProject, (Closure)new _generateStatusViolations_closure2(this, this, builder2));
        ((StringBuilder)builder2.get()).append(StringGroovyMethods.plus((String)INDENTATION, (CharSequence)"HOW TO RESOLVE: https://github.com/nebula-plugins/nebula-publishing-plugin#your-dependency-has-a-lower-status-then-your-project-violation\n"));
        ((StringBuilder)builder2.get()).append(StringGroovyMethods.plus((String)INDENTATION, (CharSequence)"\n"));
    }

    private boolean hasAnyVersionSelectorViolations(Map<String, ViolationsContainer> violationsPerProject) {
        public final class _hasAnyVersionSelectorViolations_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _hasAnyVersionSelectorViolations_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Object it) {
                return ((ViolationsContainer)((Map.Entry)it).getValue()).getVersionSelectorViolations().size() > 0;
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _hasAnyVersionSelectorViolations_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return DefaultGroovyMethods.any(violationsPerProject, (Closure)new _hasAnyVersionSelectorViolations_closure3(this, this));
    }

    private void generateVersionSelectorViolations(StringBuilder builder, Map<String, ViolationsContainer> violationsPerProject) {
        Reference builder2 = new Reference((Object)builder);
        ((StringBuilder)builder2.get()).append(StringGroovyMethods.plus((String)INDENTATION, (CharSequence)"Following dependencies have version definition with patterns which resolves into unexpected version.\n"));
        public final class _generateVersionSelectorViolations_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference builder;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _generateVersionSelectorViolations_closure4(Object _outerInstance, Object _thisObject, Reference builder) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.builder = reference = builder;
            }

            public List<VersionSelectorVerificationViolation> doCall(Object key, Object value) {
                if (((ViolationsContainer)value).getVersionSelectorViolations().size() > 0) {
                    ((StringBuilder)((Object)IndyInterface.bootstrap("cast", "()", 0, this.builder.get()))).append((CharSequence)new GStringImpl(new Object[]{VerificationReportGenerator.pfaccess$0(null), key}, new String[]{"\n", "Dependencies for ", ":\n"}));
                    public final class _closure14
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference builder;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure14(Object _outerInstance, Object _thisObject, Reference builder) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.builder = reference = builder;
                        }

                        public StringBuilder doCall(Object it) {
                            return ((StringBuilder)((Object)IndyInterface.bootstrap("cast", "()", 0, this.builder.get()))).append(StringGroovyMethods.plus((String)VerificationReportGenerator.pfaccess$0(null), (CharSequence)new GStringImpl(new Object[]{((VersionSelectorVerificationViolation)it).getDependency().getGroup(), ((VersionSelectorVerificationViolation)it).getDependency().getName(), ((VersionSelectorVerificationViolation)it).getDependency().getVersion()}, new String[]{"    '", ":", "' with requested version '", "'\n"})));
                        }

                        @Generated
                        public StringBuilder getBuilder() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.builder.get());
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public StringBuilder doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure14.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return DefaultGroovyMethods.each(((ViolationsContainer)value).getVersionSelectorViolations(), (Closure)new _closure14((Object)this, this.getThisObject(), this.builder));
                }
                return null;
            }

            @Generated
            public List<VersionSelectorVerificationViolation> call(Object key, Object value) {
                return this.doCall(key, value);
            }

            @Generated
            public StringBuilder getBuilder() {
                return IndyInterface.bootstrap("cast", "()", 0, this.builder.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generateVersionSelectorViolations_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        DefaultGroovyMethods.each(violationsPerProject, (Closure)new _generateVersionSelectorViolations_closure4(this, this, builder2));
        ((StringBuilder)builder2.get()).append(StringGroovyMethods.plus((String)INDENTATION, (CharSequence)"HOW TO RESOLVE: https://github.com/nebula-plugins/nebula-publishing-plugin#your-dependency-has-incorrect-subversion-definition\n"));
        ((StringBuilder)builder2.get()).append("\n");
    }

    private void singleModuleProjectIgnoreBlock(StringBuilder builder, Map<String, ViolationsContainer> violationsPerProject) {
        IndyInterface.bootstrap("invoke", "append", 0, builder, IndyInterface.bootstrap("invoke", "plus", 0, INDENTATION, "Place following configuration at the end of your project build.gradle file\n\n"));
        IndyInterface.bootstrap("invoke", "append", 0, builder, IndyInterface.bootstrap("invoke", "plus", 0, INDENTATION, "nebulaPublishVerification {\n"));
        CallSite violationContainer = IndyInterface.bootstrap("invoke", "first", 0, IndyInterface.bootstrap("invoke", "values", 0, violationsPerProject));
        public final class _singleModuleProjectIgnoreBlock_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _singleModuleProjectIgnoreBlock_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "module", 0, IndyInterface.bootstrap("getProperty", "id", 0, it));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _singleModuleProjectIgnoreBlock_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite modulesForIgnore = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "statusViolations", 0, violationContainer), new _singleModuleProjectIgnoreBlock_closure5(this, this)));
        public final class _singleModuleProjectIgnoreBlock_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _singleModuleProjectIgnoreBlock_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "newId", 0, DefaultModuleIdentifier.class, IndyInterface.bootstrap("getProperty", "group", 0, IndyInterface.bootstrap("getProperty", "dependency", 0, it)), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "dependency", 0, it)));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _singleModuleProjectIgnoreBlock_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        modulesForIgnore = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, modulesForIgnore, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "versionSelectorViolations", 0, violationContainer), new _singleModuleProjectIgnoreBlock_closure6(this, this))));
        public final class _singleModuleProjectIgnoreBlock_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _singleModuleProjectIgnoreBlock_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "plus", 0, ScriptBytecodeAdapter.getField(_singleModuleProjectIgnoreBlock_closure7.class, VerificationReportGenerator.class, (String)"INDENTATION"), new GStringImpl(new Object[]{it}, new String[]{"    ignore('", "')\n"}));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _singleModuleProjectIgnoreBlock_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "append", 0, builder, IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("invoke", "collect", 0, modulesForIgnore, new _singleModuleProjectIgnoreBlock_closure7(this, this)), ""));
        IndyInterface.bootstrap("invoke", "append", 0, builder, IndyInterface.bootstrap("invoke", "plus", 0, INDENTATION, "}\n"));
    }

    private void multiModuleProjectIgnoreBlock(StringBuilder builder, Map<String, ViolationsContainer> violationsPerProject) {
        IndyInterface.bootstrap("invoke", "append", 0, builder, IndyInterface.bootstrap("invoke", "plus", 0, INDENTATION, "Place following configuration at the end of your root project build.gradle file\n\n"));
        IndyInterface.bootstrap("invoke", "append", 0, builder, IndyInterface.bootstrap("invoke", "plus", 0, INDENTATION, "allprojects {\n"));
        IndyInterface.bootstrap("invoke", "append", 0, builder, IndyInterface.bootstrap("invoke", "plus", 0, INDENTATION, "    nebulaPublishVerification {\n"));
        CallSite violationsContainers = IndyInterface.bootstrap("invoke", "values", 0, violationsPerProject);
        public final class _multiModuleProjectIgnoreBlock_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _multiModuleProjectIgnoreBlock_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "statusViolations", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _multiModuleProjectIgnoreBlock_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _multiModuleProjectIgnoreBlock_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _multiModuleProjectIgnoreBlock_closure9(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "module", 0, IndyInterface.bootstrap("getProperty", "id", 0, it));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _multiModuleProjectIgnoreBlock_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite modulesForIgnore = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toSet", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "flatten", 0, IndyInterface.bootstrap("invoke", "collect", 0, violationsContainers, new _multiModuleProjectIgnoreBlock_closure8(this, this))), new _multiModuleProjectIgnoreBlock_closure9(this, this))));
        public final class _multiModuleProjectIgnoreBlock_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _multiModuleProjectIgnoreBlock_closure10(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "versionSelectorViolations", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _multiModuleProjectIgnoreBlock_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _multiModuleProjectIgnoreBlock_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _multiModuleProjectIgnoreBlock_closure11(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "newId", 0, DefaultModuleIdentifier.class, IndyInterface.bootstrap("getProperty", "group", 0, IndyInterface.bootstrap("getProperty", "dependency", 0, it)), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "dependency", 0, it)));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _multiModuleProjectIgnoreBlock_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        modulesForIgnore = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, modulesForIgnore, IndyInterface.bootstrap("invoke", "toSet", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "flatten", 0, IndyInterface.bootstrap("invoke", "collect", 0, violationsContainers, new _multiModuleProjectIgnoreBlock_closure10(this, this))), new _multiModuleProjectIgnoreBlock_closure11(this, this)))));
        public final class _multiModuleProjectIgnoreBlock_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _multiModuleProjectIgnoreBlock_closure12(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "plus", 0, ScriptBytecodeAdapter.getField(_multiModuleProjectIgnoreBlock_closure12.class, VerificationReportGenerator.class, (String)"INDENTATION"), new GStringImpl(new Object[]{it}, new String[]{"        ignore('", "')\n"}));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _multiModuleProjectIgnoreBlock_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "append", 0, builder, IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("invoke", "collect", 0, modulesForIgnore, new _multiModuleProjectIgnoreBlock_closure12(this, this)), ""));
        IndyInterface.bootstrap("invoke", "append", 0, builder, IndyInterface.bootstrap("invoke", "plus", 0, INDENTATION, "    }\n"));
        IndyInterface.bootstrap("invoke", "append", 0, builder, IndyInterface.bootstrap("invoke", "plus", 0, INDENTATION, "}\n"));
    }

    public static /* synthetic */ String pfaccess$0(VerificationReportGenerator $that) {
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getField(VerificationReportGenerator.class, VerificationReportGenerator.class, (String)"INDENTATION"));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != VerificationReportGenerator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }
}

