/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.release;

import com.github.zafarkhaja.semver.Version;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.List;
import nebula.plugin.release.FeatureFlags;
import nebula.plugin.release.VersionSanitizerUtil;
import nebula.plugin.release.git.base.ReleasePluginExtension;
import nebula.plugin.release.git.base.ReleaseVersion;
import nebula.plugin.release.git.base.TagStrategy;
import nebula.plugin.release.git.base.VersionStrategy;
import nebula.plugin.release.git.opinion.TimestampUtil;
import nebula.plugin.release.git.semver.NearestVersion;
import nebula.plugin.release.git.semver.NearestVersionLocator;
import org.ajoberstar.grgit.Grgit;
import org.ajoberstar.grgit.Tag;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverrideStrategies
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public OverrideStrategies() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != OverrideStrategies.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(OverrideStrategies.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, OverrideStrategies.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(OverrideStrategies.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static class ReleaseLastTagStrategy
    implements VersionStrategy,
    GroovyObject {
        private static final String PROPERTY_NAME = "release.useLastTag";
        private static final String NOT_SUPPLIED = "release-strategy-is-not-supplied";
        private static final Logger logger;
        private Project project;
        private String propertyName;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public ReleaseLastTagStrategy(Project project, String propertyName) {
            String string;
            Project project2;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.project = project2 = project;
            this.propertyName = string = propertyName;
        }

        @Generated
        public ReleaseLastTagStrategy(Project project) {
            this(project, PROPERTY_NAME);
        }

        @Override
        public String getName() {
            return "use-last-tag";
        }

        @Override
        public boolean selector(Project project, Grgit grgit) {
            Boolean shouldSelect = project.hasProperty(this.propertyName) ? StringGroovyMethods.toBoolean((String)DefaultGroovyMethods.toString((Object)project.property(this.propertyName))) : Boolean.valueOf(false);
            Boolean bl = shouldSelect;
            if (bl == null ? false : bl) {
                boolean bl2 = false;
                project.getTasks().getByName("release").setEnabled(bl2);
            }
            return DefaultTypeTransformation.booleanUnbox((Object)shouldSelect);
        }

        @Override
        public ReleaseVersion infer(Project project, Grgit grgit) {
            Reference grgit2 = new Reference((Object)grgit);
            TagStrategy tagStrategy = ((ReleasePluginExtension)project.getExtensions().getByType(ReleasePluginExtension.class)).getTagStrategy();
            NearestVersion locate = new NearestVersionLocator(tagStrategy).locate((Grgit)grgit2.get());
            String releaseStage = null;
            try {
                Object object = project.property("release.stage");
                releaseStage = ShortTypeHandling.castToString((Object)object);
            }
            catch (MissingPropertyException e) {
                String string;
                releaseStage = string = NOT_SUPPLIED;
                logger.debug("ExtraPropertiesExtension 'release.stage' was not supplied", (Object)e.getMessage());
                logger.info("Note: It is recommended to supply a release strategy of <snapshot|immutableSnapshot|devSnapshot|candidate|final> to make 'useLastTag' most explicit. Please add one to your list of tasks.");
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)releaseStage, (Object)"dev") || ScriptBytecodeAdapter.compareEqual((Object)releaseStage, (Object)"snapshot") || ScriptBytecodeAdapter.compareEqual((Object)releaseStage, (Object)"SNAPSHOT")) {
                throw (Throwable)new GradleException("Cannot use useLastTag with snapshot, immutableSnapshot and devSnapshot tasks");
            }
            if (locate.getDistanceFromAny() == 0) {
                if (ScriptBytecodeAdapter.compareEqual((Object)releaseStage, (Object)NOT_SUPPLIED) && (locate.getAny().toString().contains("-dev.") || locate.getAny().toString().contains("-SNAPSHOT") || locate.getAny().toString().contains("-snapshot."))) {
                    throw (Throwable)new GradleException("Current commit has a snapshot, immutableSnapshot or devSnapshot tag. 'useLastTag' requires a prerelease or final tag.");
                }
                Version version = locate.getAny();
                String preReleaseVersion = version.getPreReleaseVersion();
                if (ScriptBytecodeAdapter.compareEqual((Object)releaseStage, (Object)"rc") && !ScriptBytecodeAdapter.matchRegex((Object)preReleaseVersion, (Object)"rc\\.\\d+")) {
                    throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{version}, new String[]{"Current tag (", ") does not appear to be a pre-release version. A pre-release version MAY be denoted by appending a hyphen and a series of dot separated identifiers immediately following the patch version. For more information, please refer to https://semver.org/"})));
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)releaseStage, (Object)"final") && DefaultTypeTransformation.booleanUnbox((Object)preReleaseVersion)) {
                    throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{version}, new String[]{"Current tag (", ") does not appear to be a final version. final task can not be used with prerelease versions. A pre-release version MAY be denoted by appending a hyphen and a series of dot separated identifiers immediately following the patch version.  For more information, please refer to https://semver.org/"})));
                }
                String inferredVersion = locate.getAny().toString();
                if (VersionSanitizerUtil.hasSanitizeFlag(project)) {
                    String string;
                    inferredVersion = string = VersionSanitizerUtil.sanitize(inferredVersion);
                }
                logger.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{inferredVersion, ScriptBytecodeAdapter.compareEqual((Object)releaseStage, (Object)NOT_SUPPLIED) ? "a non-supplied release strategy" : new GStringImpl(new Object[]{releaseStage}, new String[]{"", " release strategy"})}, new String[]{"Using version ", " with ", ""})));
                return new ReleaseVersion(inferredVersion, null, false);
            }
            public final class _infer_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference grgit;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _infer_closure1(Object _outerInstance, Object _thisObject, Reference grgit) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.grgit = reference = grgit;
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.compareEqual((Object)((Tag)it).getCommit(), (Object)((Grgit)this.grgit.get()).head());
                }

                public Grgit getGrgit() {
                    return (Grgit)ScriptBytecodeAdapter.castToType((Object)this.grgit.get(), Grgit.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _infer_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            List headTags = DefaultGroovyMethods.findAll((List)((Grgit)grgit2.get()).getTag().list(), (Closure)new _infer_closure1(this, this, grgit2));
            if (headTags.isEmpty()) {
                throw (Throwable)new GradleException("Current commit does not have a tag");
            }
            public final class _infer_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _infer_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ((Tag)it).getName();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _infer_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.collect((Iterable)headTags, (Closure)new _infer_closure2(this, this))}, new String[]{"Current commit has following tags: ", " but they were not recognized as valid versions"})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ReleaseLastTagStrategy.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ReleaseLastTagStrategy.class, OverrideStrategies.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ReleaseLastTagStrategy.class, OverrideStrategies.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, OverrideStrategies.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, OverrideStrategies.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ReleaseLastTagStrategy.class, OverrideStrategies.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ReleaseLastTagStrategy.class, OverrideStrategies.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        static {
            Logger logger;
            ReleaseLastTagStrategy.logger = logger = LoggerFactory.getLogger(ReleaseLastTagStrategy.class);
        }

        @Generated
        public static String getPROPERTY_NAME() {
            return PROPERTY_NAME;
        }

        @Generated
        public Project getProject() {
            return this.project;
        }

        @Generated
        public void setProject(Project project) {
            this.project = project;
        }

        @Generated
        public String getPropertyName() {
            return this.propertyName;
        }

        @Generated
        public void setPropertyName(String string) {
            this.propertyName = string;
        }
    }

    public static class GradlePropertyStrategy
    implements VersionStrategy,
    GroovyObject {
        private static final String PROPERTY_NAME = "release.version";
        private Project project;
        private String propertyName;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public GradlePropertyStrategy(Project project, String propertyName) {
            String string;
            Project project2;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.project = project2 = project;
            this.propertyName = string = propertyName;
        }

        @Generated
        public GradlePropertyStrategy(Project project) {
            this(project, PROPERTY_NAME);
        }

        @Override
        public String getName() {
            return "gradle-properties";
        }

        @Override
        public boolean selector(Project project, Grgit grgit) {
            return project.hasProperty(this.propertyName);
        }

        @Override
        public ReleaseVersion infer(Project project, Grgit grgit) {
            String requestedVersion = DefaultGroovyMethods.toString((Object)project.property(this.propertyName));
            if (requestedVersion == null || requestedVersion.isEmpty()) {
                throw (Throwable)new GradleException("Supplied release.version is empty");
            }
            if (VersionSanitizerUtil.hasSanitizeFlag(project)) {
                String string;
                requestedVersion = string = VersionSanitizerUtil.sanitize(requestedVersion.toString());
            }
            return new ReleaseVersion(requestedVersion, null, true);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != GradlePropertyStrategy.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(GradlePropertyStrategy.class, OverrideStrategies.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(GradlePropertyStrategy.class, OverrideStrategies.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, OverrideStrategies.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, OverrideStrategies.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(GradlePropertyStrategy.class, OverrideStrategies.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(GradlePropertyStrategy.class, OverrideStrategies.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public static String getPROPERTY_NAME() {
            return PROPERTY_NAME;
        }

        @Generated
        public Project getProject() {
            return this.project;
        }

        @Generated
        public void setProject(Project project) {
            this.project = project;
        }

        @Generated
        public String getPropertyName() {
            return this.propertyName;
        }

        @Generated
        public void setPropertyName(String string) {
            this.propertyName = string;
        }
    }

    public static class NoCommitStrategy
    implements VersionStrategy,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public NoCommitStrategy() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public String getName() {
            return "no-commit";
        }

        @Override
        public boolean selector(Project project, Grgit grgit) {
            try {
                grgit.describe();
            }
            catch (RefNotFoundException ignore) {
                boolean bl = true;
                return bl;
            }
            return false;
        }

        @Override
        public ReleaseVersion infer(Project project, Grgit grgit) {
            boolean replaceDevSnapshots = FeatureFlags.isDevSnapshotReplacementEnabled(project);
            if (replaceDevSnapshots) {
                return new ReleaseVersion(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{TimestampUtil.getUTCFormattedTimestamp()}, new String[]{"0.1.0-snapshot.", ".uncommitted"})), null, false);
            }
            return new ReleaseVersion("0.1.0-dev.0.uncommitted", null, false);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NoCommitStrategy.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(NoCommitStrategy.class, OverrideStrategies.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(NoCommitStrategy.class, OverrideStrategies.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, OverrideStrategies.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, OverrideStrategies.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(NoCommitStrategy.class, OverrideStrategies.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(NoCommitStrategy.class, OverrideStrategies.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

