/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eventbus.filter.lang.infix;

import com.google.common.base.Predicate;
import com.netflix.eventbus.spi.EventFilter;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class InfixEventFilter
implements EventFilter {
    public static final String INFIX_LANGUAGE_NAME = "infix";
    private final Predicate<Object> predicate;
    private final String original;

    public InfixEventFilter(Predicate<Object> predicate, String original) {
        this.predicate = predicate;
        this.original = original;
    }

    public InfixEventFilter(Predicate<Object> predicate) {
        this.predicate = predicate;
        this.original = null;
    }

    public boolean apply(@Nullable Object input) {
        return this.predicate.apply(input);
    }

    @Override
    public String getLanguage() {
        return INFIX_LANGUAGE_NAME;
    }

    @Override
    public String serialize() {
        return this.original;
    }

    public int hashCode() {
        return this.original != null ? this.original.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InfixEventFilter");
        sb.append("{input=").append(StringUtils.abbreviate((String)this.original, (int)256));
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InfixEventFilter that = (InfixEventFilter)o;
        return !(this.predicate != null ? !this.predicate.equals(that.predicate) : that.predicate != null);
    }
}

