/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client.config;

import com.netflix.client.config.PropertyResolver;
import com.netflix.config.ConfigurationManager;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchaiusPropertyResolver
implements PropertyResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ArchaiusPropertyResolver.class);
    public static final ArchaiusPropertyResolver INSTANCE = new ArchaiusPropertyResolver();
    private final AbstractConfiguration config;
    private final CopyOnWriteArrayList<Runnable> actions = new CopyOnWriteArrayList();

    private ArchaiusPropertyResolver() {
        this.config = ConfigurationManager.getConfigInstance();
        ConfigurationManager.getConfigInstance().addConfigurationListener(new ConfigurationListener(){

            public void configurationChanged(ConfigurationEvent event) {
                if (!event.isBeforeUpdate()) {
                    ArchaiusPropertyResolver.this.actions.forEach(x$0 -> ArchaiusPropertyResolver.invokeAction(x$0));
                }
            }
        });
    }

    private static void invokeAction(Runnable action) {
        try {
            action.run();
        }
        catch (Exception e) {
            LOG.info("Failed to invoke action", (Throwable)e);
        }
    }

    public <T> Optional<T> get(String key, Class<T> type) {
        LOG.debug("Loading property {}", (Object)key);
        if (Integer.class.equals(type)) {
            return Optional.ofNullable(this.config.getInteger(key, null));
        }
        if (Boolean.class.equals(type)) {
            return Optional.ofNullable(this.config.getBoolean(key, null));
        }
        if (Float.class.equals(type)) {
            return Optional.ofNullable(this.config.getFloat(key, null));
        }
        if (Long.class.equals(type)) {
            return Optional.ofNullable(this.config.getLong(key, null));
        }
        if (Double.class.equals(type)) {
            return Optional.ofNullable(this.config.getDouble(key, null));
        }
        if (TimeUnit.class.equals(type)) {
            return Optional.ofNullable(TimeUnit.valueOf(this.config.getString(key, null)));
        }
        return Optional.ofNullable(this.config.getStringArray(key)).filter(ar -> ((String[])ar).length > 0).map(ar -> Arrays.stream(ar).collect(Collectors.joining(","))).map(value -> {
            if (type.equals(String.class)) {
                return value;
            }
            return PropertyResolver.resolveWithValueOf((Class)type, (String)value).orElseThrow(() -> new IllegalArgumentException("Unable to convert value to desired type " + type));
        });
    }

    public void forEach(String prefix, BiConsumer<String, String> consumer) {
        Optional.ofNullable(this.config.subset(prefix)).ifPresent(subconfig -> subconfig.getKeys().forEachRemaining(key -> {
            String value = this.config.getString(prefix + "." + key);
            consumer.accept((String)key, value);
        }));
    }

    public void onChange(Runnable action) {
        this.actions.add(action);
    }

    public int getActionCount() {
        return this.actions.size();
    }
}

