/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client.http;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.netflix.client.http.HttpHeaders;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CaseInsensitiveMultiMap
implements HttpHeaders {
    Multimap<String, Map.Entry<String, String>> map = ArrayListMultimap.create();

    @Override
    public String getFirstValue(String headerName) {
        Collection entries = this.map.get((Object)headerName.toLowerCase());
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        return (String)((Map.Entry)entries.iterator().next()).getValue();
    }

    @Override
    public List<String> getAllValues(String headerName) {
        Collection entries = this.map.get((Object)headerName.toLowerCase());
        ArrayList values = Lists.newArrayList();
        if (entries != null) {
            for (Map.Entry entry : entries) {
                values.add(entry.getValue());
            }
        }
        return values;
    }

    @Override
    public List<Map.Entry<String, String>> getAllHeaders() {
        Collection all = this.map.values();
        return new ArrayList<Map.Entry<String, String>>(all);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.map.containsKey((Object)name.toLowerCase());
    }

    public void addHeader(String name, String value) {
        if (this.getAllValues(name).contains(value)) {
            return;
        }
        AbstractMap.SimpleEntry<String, String> entry = new AbstractMap.SimpleEntry<String, String>(name, value);
        this.map.put((Object)name.toLowerCase(), entry);
    }

    Map<String, Collection<String>> asMap() {
        ArrayListMultimap result = ArrayListMultimap.create();
        Collection all = this.map.values();
        for (Map.Entry entry : all) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result.asMap();
    }
}

