/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.netflix.client.ClientFactory;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.loadbalancer.BaseLoadBalancer;
import com.netflix.loadbalancer.DummyPing;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.LoadBalancerExecutor;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ServerListFilter;
import com.netflix.loadbalancer.ZoneAwareLoadBalancer;
import java.util.List;

public class LoadBalancerBuilder<T extends Server> {
    private IClientConfig config = DefaultClientConfigImpl.getClientConfigWithDefaultValues();
    private RetryHandler errorHandler = RetryHandler.DEFAULT;
    private ServerListFilter serverListFilter;
    private IRule rule;
    private IPing ping = new DummyPing();
    private ServerList serverListImpl;

    private LoadBalancerBuilder() {
    }

    public static <T extends Server> LoadBalancerBuilder<T> newBuilder() {
        return new LoadBalancerBuilder<T>();
    }

    public LoadBalancerBuilder<T> withClientConfig(IClientConfig config) {
        this.config = config;
        return this;
    }

    public LoadBalancerBuilder<T> withLoadBalancerExecutorRetryHandler(RetryHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public LoadBalancerBuilder<T> withRule(IRule rule) {
        this.rule = rule;
        return this;
    }

    public LoadBalancerBuilder<T> withPing(IPing ping) {
        this.ping = ping;
        return this;
    }

    public LoadBalancerBuilder<T> withDynamicServerList(ServerList<T> serverListImpl) {
        this.serverListImpl = serverListImpl;
        return this;
    }

    public LoadBalancerBuilder<T> withServerListFilter(ServerListFilter<T> serverListFilter) {
        this.serverListFilter = serverListFilter;
        return this;
    }

    public BaseLoadBalancer buildFixedServerListLoadBalancer(List<T> servers) {
        if (this.rule == null) {
            this.rule = LoadBalancerBuilder.createRuleFromConfig(this.config);
        }
        BaseLoadBalancer lb = new BaseLoadBalancer(this.config, this.rule, this.ping);
        lb.setServersList(servers);
        return lb;
    }

    private static IRule createRuleFromConfig(IClientConfig config) {
        IRule rule;
        String ruleClassName = (String)config.get(IClientConfigKey.Keys.NFLoadBalancerRuleClassName);
        if (ruleClassName == null) {
            throw new IllegalArgumentException("NFLoadBalancerRuleClassName is not specified in the config");
        }
        try {
            rule = (IRule)ClientFactory.instantiateInstanceWithClientConfig(ruleClassName, config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return rule;
    }

    private static ServerList<Server> createServerListFromConfig(IClientConfig config) {
        ServerList list;
        String serverListClassName = (String)config.get(IClientConfigKey.Keys.NIWSServerListClassName);
        if (serverListClassName == null) {
            throw new IllegalArgumentException("NIWSServerListClassName is not specified in the config");
        }
        try {
            list = (ServerList)ClientFactory.instantiateInstanceWithClientConfig(serverListClassName, config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    public ZoneAwareLoadBalancer<T> buildDynamicServerListLoadBalancer() {
        if (this.serverListImpl == null) {
            this.serverListImpl = LoadBalancerBuilder.createServerListFromConfig(this.config);
        }
        if (this.rule == null) {
            this.rule = LoadBalancerBuilder.createRuleFromConfig(this.config);
        }
        return new ZoneAwareLoadBalancer(this.config, this.rule, this.ping, this.serverListImpl, this.serverListFilter);
    }

    public ILoadBalancer buildLoadBalancerFromConfigWithReflection() {
        ILoadBalancer lb;
        String loadBalancerClassName = (String)this.config.get(CommonClientConfigKey.NFLoadBalancerClassName);
        if (loadBalancerClassName == null) {
            throw new IllegalArgumentException("NFLoadBalancerClassName is not specified in the IClientConfig");
        }
        try {
            lb = (ILoadBalancer)ClientFactory.instantiateInstanceWithClientConfig(loadBalancerClassName, this.config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return lb;
    }

    public LoadBalancerExecutor buildDynamicServerListLoadBalancerExecutor() {
        ZoneAwareLoadBalancer<T> lb = this.buildDynamicServerListLoadBalancer();
        LoadBalancerExecutor executor = new LoadBalancerExecutor(lb, this.config, this.errorHandler);
        return executor;
    }

    public LoadBalancerExecutor buildFixedServerListLoadBalancerExecutor(List<T> servers) {
        BaseLoadBalancer lb = this.buildFixedServerListLoadBalancer(servers);
        LoadBalancerExecutor executor = new LoadBalancerExecutor(lb, this.config, this.errorHandler);
        return executor;
    }
}

