/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.client;

import com.google.common.base.Preconditions;
import com.netflix.client.ClientException;
import com.netflix.client.ClientRequest;
import com.netflix.client.IClient;
import com.netflix.client.IClientConfigAware;
import com.netflix.client.IResponse;
import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.LoadBalancerContext;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import com.netflix.loadbalancer.reactive.LoadBalancerExecutable;
import com.netflix.loadbalancer.reactive.LoadBalancerRetrySameServerCommand;
import java.net.URI;

public abstract class AbstractLoadBalancerAwareClient<S extends ClientRequest, T extends IResponse>
extends LoadBalancerContext
implements IClient<S, T>,
IClientConfigAware {
    public AbstractLoadBalancerAwareClient(ILoadBalancer lb) {
        super(lb);
    }

    public AbstractLoadBalancerAwareClient(ILoadBalancer lb, IClientConfig clientConfig) {
        super(lb, clientConfig);
    }

    @Deprecated
    protected boolean isCircuitBreakerException(Throwable e) {
        if (this.getRetryHandler() != null) {
            return this.getRetryHandler().isCircuitTrippingException(e);
        }
        return false;
    }

    @Deprecated
    protected boolean isRetriableException(Throwable e) {
        if (this.getRetryHandler() != null) {
            return this.getRetryHandler().isRetriableException(e, true);
        }
        return false;
    }

    protected T executeOnSingleServer(S request, IClientConfig requestConfig) throws ClientException {
        String host = request.getUri().getHost();
        Preconditions.checkNotNull((Object)host);
        int port = request.getUri().getPort();
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"port is undefined");
        Server server = new Server(host, port);
        RequestSpecificRetryHandler handler = this.getRequestSpecificRetryHandler(request, requestConfig);
        LoadBalancerRetrySameServerCommand command = new LoadBalancerRetrySameServerCommand(this, (RetryHandler)handler);
        LoadBalancerExecutable executable = new LoadBalancerExecutable<T>((ClientRequest)request, requestConfig){
            final /* synthetic */ ClientRequest val$request;
            final /* synthetic */ IClientConfig val$requestConfig;
            {
                this.val$request = clientRequest;
                this.val$requestConfig = iClientConfig;
            }

            @Override
            public T run(Server server) throws Exception {
                return AbstractLoadBalancerAwareClient.this.execute(this.val$request, this.val$requestConfig);
            }
        };
        try {
            return (T)((IResponse)command.retryWithSameServer(server, executable));
        }
        catch (Exception e) {
            if (e instanceof ClientException) {
                throw (ClientException)e;
            }
            throw new ClientException((Throwable)e);
        }
    }

    public T executeWithLoadBalancer(S request) throws ClientException {
        return this.executeWithLoadBalancer(request, null);
    }

    public T executeWithLoadBalancer(S request, IClientConfig requestConfig) throws ClientException {
        RequestSpecificRetryHandler handler = this.getRequestSpecificRetryHandler(request, requestConfig);
        LoadBalancerCommand runnableCommand = new LoadBalancerCommand<T>(this, (RetryHandler)handler, request.getUri(), null, (ClientRequest)request, requestConfig){
            final /* synthetic */ ClientRequest val$request;
            final /* synthetic */ IClientConfig val$requestConfig;
            {
                this.val$request = clientRequest;
                this.val$requestConfig = iClientConfig;
                super(x0, x1, x2, x3);
            }

            @Override
            public T run(Server server) throws Exception {
                URI finalUri = AbstractLoadBalancerAwareClient.this.reconstructURIWithServer(server, this.val$request.getUri());
                ClientRequest requestForServer = this.val$request.replaceUri(finalUri);
                return AbstractLoadBalancerAwareClient.this.execute(requestForServer, this.val$requestConfig);
            }
        };
        try {
            return (T)((IResponse)runnableCommand.execute());
        }
        catch (Exception e) {
            if (e instanceof ClientException) {
                throw (ClientException)e;
            }
            throw new ClientException((Throwable)e);
        }
    }

    public abstract RequestSpecificRetryHandler getRequestSpecificRetryHandler(S var1, IClientConfig var2);

    @Deprecated
    protected boolean isRetriable(S request) {
        if (request.isRetriable()) {
            return true;
        }
        boolean retryOkayOnOperation = this.okToRetryOnAllOperations;
        IClientConfig overriddenClientConfig = request.getOverrideConfig();
        if (overriddenClientConfig != null) {
            retryOkayOnOperation = overriddenClientConfig.getPropertyAsBoolean(CommonClientConfigKey.RequestSpecificRetryOn, this.okToRetryOnAllOperations);
        }
        return retryOkayOnOperation;
    }
}

