/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.Server;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.stats.distribution.DataAccumulator;
import com.netflix.stats.distribution.DataDistribution;
import com.netflix.stats.distribution.DataPublisher;
import com.netflix.stats.distribution.Distribution;
import com.netflix.util.MeasuredRate;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ServerStats {
    private static final int DEFAULT_PUBLISH_INTERVAL = 60000;
    private static final int DEFAULT_BUFFER_SIZE = 60000;
    private final DynamicIntProperty connectionFailureThreshold;
    private final DynamicIntProperty circuitTrippedTimeoutFactor;
    private final DynamicIntProperty maxCircuitTrippedTimeout;
    private static final DynamicIntProperty activeRequestsCountTimeout = DynamicPropertyFactory.getInstance().getIntProperty("niws.loadbalancer.serverStats.activeRequestsCount.effectiveWindowSeconds", 600);
    private static final double[] PERCENTS = ServerStats.makePercentValues();
    private DataDistribution dataDist = new DataDistribution(1, PERCENTS);
    private DataPublisher publisher = null;
    private final Distribution responseTimeDist = new Distribution();
    int bufferSize = 60000;
    int publishInterval = 60000;
    long failureCountSlidingWindowInterval = 1000L;
    private MeasuredRate serverFailureCounts = new MeasuredRate(this.failureCountSlidingWindowInterval);
    private MeasuredRate requestCountInWindow = new MeasuredRate(300000L);
    Server server;
    AtomicLong totalRequests = new AtomicLong();
    @VisibleForTesting
    AtomicInteger successiveConnectionFailureCount = new AtomicInteger(0);
    @VisibleForTesting
    AtomicInteger activeRequestsCount = new AtomicInteger(0);
    private volatile long lastConnectionFailedTimestamp;
    private volatile long lastActiveRequestsCountChangeTimestamp;
    private AtomicLong totalCircuitBreakerBlackOutPeriod = new AtomicLong(0L);
    private volatile long lastAccessedTimestamp;
    private volatile long firstConnectionTimestamp = 0L;

    public ServerStats() {
        this.connectionFailureThreshold = DynamicPropertyFactory.getInstance().getIntProperty("niws.loadbalancer.default.connectionFailureCountThreshold", 3);
        this.circuitTrippedTimeoutFactor = DynamicPropertyFactory.getInstance().getIntProperty("niws.loadbalancer.default.circuitTripTimeoutFactorSeconds", 10);
        this.maxCircuitTrippedTimeout = DynamicPropertyFactory.getInstance().getIntProperty("niws.loadbalancer.default.circuitTripMaxTimeoutSeconds", 30);
    }

    public ServerStats(LoadBalancerStats lbStats) {
        this.maxCircuitTrippedTimeout = lbStats.getCircuitTripMaxTimeoutSeconds();
        this.circuitTrippedTimeoutFactor = lbStats.getCircuitTrippedTimeoutFactor();
        this.connectionFailureThreshold = lbStats.getConnectionFailureCountThreshold();
    }

    public void initialize(Server server) {
        this.serverFailureCounts = new MeasuredRate(this.failureCountSlidingWindowInterval);
        this.requestCountInWindow = new MeasuredRate(300000L);
        if (this.publisher == null) {
            this.dataDist = new DataDistribution(this.getBufferSize(), PERCENTS);
            this.publisher = new DataPublisher((DataAccumulator)this.dataDist, this.getPublishIntervalMillis());
            this.publisher.start();
        }
        this.server = server;
    }

    private int getBufferSize() {
        return this.bufferSize;
    }

    private long getPublishIntervalMillis() {
        return this.publishInterval;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setPublishInterval(int publishInterval) {
        this.publishInterval = publishInterval;
    }

    private static double[] makePercentValues() {
        Percent[] percents = Percent.values();
        double[] p = new double[percents.length];
        for (int i = 0; i < percents.length; ++i) {
            p[i] = percents[i].getValue();
        }
        return p;
    }

    public long getFailureCountSlidingWindowInterval() {
        return this.failureCountSlidingWindowInterval;
    }

    public void setFailureCountSlidingWindowInterval(long failureCountSlidingWindowInterval) {
        this.failureCountSlidingWindowInterval = failureCountSlidingWindowInterval;
    }

    public void addToFailureCount() {
        this.serverFailureCounts.increment();
    }

    public long getFailureCount() {
        long count = 0L;
        count = this.serverFailureCounts.getCurrentCount();
        return count;
    }

    public void noteResponseTime(double msecs) {
        this.dataDist.noteValue(msecs);
        this.responseTimeDist.noteValue(msecs);
    }

    public void incrementNumRequests() {
        this.totalRequests.incrementAndGet();
    }

    public void incrementActiveRequestsCount() {
        long currentTime;
        this.activeRequestsCount.incrementAndGet();
        this.requestCountInWindow.increment();
        this.lastActiveRequestsCountChangeTimestamp = currentTime = System.currentTimeMillis();
        this.lastAccessedTimestamp = currentTime;
        if (this.firstConnectionTimestamp == 0L) {
            this.firstConnectionTimestamp = currentTime;
        }
    }

    public void decrementActiveRequestsCount() {
        if (this.activeRequestsCount.decrementAndGet() < 0) {
            this.activeRequestsCount.set(0);
        }
        this.lastActiveRequestsCountChangeTimestamp = System.currentTimeMillis();
    }

    public int getActiveRequestsCount() {
        return this.getActiveRequestsCount(System.currentTimeMillis());
    }

    public int getActiveRequestsCount(long currentTime) {
        int count = this.activeRequestsCount.get();
        if (count == 0) {
            return 0;
        }
        if (currentTime - this.lastActiveRequestsCountChangeTimestamp > (long)(activeRequestsCountTimeout.get() * 1000) || count < 0) {
            this.activeRequestsCount.set(0);
            return 0;
        }
        return count;
    }

    public long getMeasuredRequestsCount() {
        return this.requestCountInWindow.getCount();
    }

    @Monitor(name="ActiveRequestsCount", type=DataSourceType.GAUGE)
    public int getMonitoredActiveRequestsCount() {
        return this.activeRequestsCount.get();
    }

    @Monitor(name="CircuitBreakerTripped", type=DataSourceType.GAUGE)
    public boolean isCircuitBreakerTripped() {
        return this.isCircuitBreakerTripped(System.currentTimeMillis());
    }

    public boolean isCircuitBreakerTripped(long currentTime) {
        long circuitBreakerTimeout = this.getCircuitBreakerTimeout();
        if (circuitBreakerTimeout <= 0L) {
            return false;
        }
        return circuitBreakerTimeout > currentTime;
    }

    private long getCircuitBreakerTimeout() {
        long blackOutPeriod = this.getCircuitBreakerBlackoutPeriod();
        if (blackOutPeriod <= 0L) {
            return 0L;
        }
        return this.lastConnectionFailedTimestamp + blackOutPeriod;
    }

    private long getCircuitBreakerBlackoutPeriod() {
        int threshold;
        int failureCount = this.successiveConnectionFailureCount.get();
        if (failureCount < (threshold = this.connectionFailureThreshold.get())) {
            return 0L;
        }
        int diff = failureCount - threshold > 16 ? 16 : failureCount - threshold;
        int blackOutSeconds = (1 << diff) * this.circuitTrippedTimeoutFactor.get();
        if (blackOutSeconds > this.maxCircuitTrippedTimeout.get()) {
            blackOutSeconds = this.maxCircuitTrippedTimeout.get();
        }
        return (long)blackOutSeconds * 1000L;
    }

    public void incrementSuccessiveConnectionFailureCount() {
        this.lastConnectionFailedTimestamp = System.currentTimeMillis();
        this.successiveConnectionFailureCount.incrementAndGet();
        this.totalCircuitBreakerBlackOutPeriod.addAndGet(this.getCircuitBreakerBlackoutPeriod());
    }

    public void clearSuccessiveConnectionFailureCount() {
        this.successiveConnectionFailureCount.set(0);
    }

    @Monitor(name="SuccessiveConnectionFailureCount", type=DataSourceType.GAUGE)
    public int getSuccessiveConnectionFailureCount() {
        return this.successiveConnectionFailureCount.get();
    }

    @Monitor(name="OverallResponseTimeMillisAvg", type=DataSourceType.INFORMATIONAL, description="Average total time for a request, in milliseconds")
    public double getResponseTimeAvg() {
        return this.responseTimeDist.getMean();
    }

    @Monitor(name="OverallResponseTimeMillisMax", type=DataSourceType.INFORMATIONAL, description="Max total time for a request, in milliseconds")
    public double getResponseTimeMax() {
        return this.responseTimeDist.getMaximum();
    }

    @Monitor(name="OverallResponseTimeMillisMin", type=DataSourceType.INFORMATIONAL, description="Min total time for a request, in milliseconds")
    public double getResponseTimeMin() {
        return this.responseTimeDist.getMinimum();
    }

    @Monitor(name="OverallResponseTimeMillisStdDev", type=DataSourceType.INFORMATIONAL, description="Standard Deviation in total time to handle a request, in milliseconds")
    public double getResponseTimeStdDev() {
        return this.responseTimeDist.getStdDev();
    }

    @Monitor(name="ResponseTimePercentileNumValues", type=DataSourceType.GAUGE, description="The number of data points used to compute the currently reported percentile values")
    public int getResponseTimePercentileNumValues() {
        return this.dataDist.getSampleSize();
    }

    @Monitor(name="ResponseTimePercentileWhen", type=DataSourceType.INFORMATIONAL, description="The time the percentile values were computed")
    public String getResponseTimePercentileTime() {
        return this.dataDist.getTimestamp();
    }

    @Monitor(name="ResponseTimePercentileWhenMillis", type=DataSourceType.COUNTER, description="The time the percentile values were computed in milliseconds since the epoch")
    public long getResponseTimePercentileTimeMillis() {
        return this.dataDist.getTimestampMillis();
    }

    @Monitor(name="ResponseTimeMillisAvg", type=DataSourceType.GAUGE, description="Average total time for a request in the recent time slice, in milliseconds")
    public double getResponseTimeAvgRecent() {
        return this.dataDist.getMean();
    }

    @Monitor(name="ResponseTimeMillis10Percentile", type=DataSourceType.INFORMATIONAL, description="10th percentile in total time to handle a request, in milliseconds")
    public double getResponseTime10thPercentile() {
        return this.getResponseTimePercentile(Percent.TEN);
    }

    @Monitor(name="ResponseTimeMillis25Percentile", type=DataSourceType.INFORMATIONAL, description="25th percentile in total time to handle a request, in milliseconds")
    public double getResponseTime25thPercentile() {
        return this.getResponseTimePercentile(Percent.TWENTY_FIVE);
    }

    @Monitor(name="ResponseTimeMillis50Percentile", type=DataSourceType.INFORMATIONAL, description="50th percentile in total time to handle a request, in milliseconds")
    public double getResponseTime50thPercentile() {
        return this.getResponseTimePercentile(Percent.FIFTY);
    }

    @Monitor(name="ResponseTimeMillis75Percentile", type=DataSourceType.INFORMATIONAL, description="75th percentile in total time to handle a request, in milliseconds")
    public double getResponseTime75thPercentile() {
        return this.getResponseTimePercentile(Percent.SEVENTY_FIVE);
    }

    @Monitor(name="ResponseTimeMillis90Percentile", type=DataSourceType.INFORMATIONAL, description="90th percentile in total time to handle a request, in milliseconds")
    public double getResponseTime90thPercentile() {
        return this.getResponseTimePercentile(Percent.NINETY);
    }

    @Monitor(name="ResponseTimeMillis95Percentile", type=DataSourceType.GAUGE, description="95th percentile in total time to handle a request, in milliseconds")
    public double getResponseTime95thPercentile() {
        return this.getResponseTimePercentile(Percent.NINETY_FIVE);
    }

    @Monitor(name="ResponseTimeMillis98Percentile", type=DataSourceType.INFORMATIONAL, description="98th percentile in total time to handle a request, in milliseconds")
    public double getResponseTime98thPercentile() {
        return this.getResponseTimePercentile(Percent.NINETY_EIGHT);
    }

    @Monitor(name="ResponseTimeMillis99Percentile", type=DataSourceType.GAUGE, description="99th percentile in total time to handle a request, in milliseconds")
    public double getResponseTime99thPercentile() {
        return this.getResponseTimePercentile(Percent.NINETY_NINE);
    }

    @Monitor(name="ResponseTimeMillis99_5Percentile", type=DataSourceType.GAUGE, description="99.5th percentile in total time to handle a request, in milliseconds")
    public double getResponseTime99point5thPercentile() {
        return this.getResponseTimePercentile(Percent.NINETY_NINE_POINT_FIVE);
    }

    public long getTotalRequestsCount() {
        return this.totalRequests.get();
    }

    private double getResponseTimePercentile(Percent p) {
        return this.dataDist.getPercentiles()[p.ordinal()];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Server:" + this.server + ";");
        sb.append("\tZone:" + this.server.getZone() + ";");
        sb.append("\tTotal Requests:" + this.totalRequests + ";");
        sb.append("\tSuccessive connection failure:" + this.getSuccessiveConnectionFailureCount() + ";");
        if (this.isCircuitBreakerTripped()) {
            sb.append("\tBlackout until: " + new Date(this.getCircuitBreakerTimeout()) + ";");
        }
        sb.append("\tTotal blackout seconds:" + this.totalCircuitBreakerBlackOutPeriod.get() / 1000L + ";");
        sb.append("\tLast connection made:" + new Date(this.lastAccessedTimestamp) + ";");
        if (this.lastConnectionFailedTimestamp > 0L) {
            sb.append("\tLast connection failure: " + new Date(this.lastConnectionFailedTimestamp) + ";");
        }
        sb.append("\tFirst connection made: " + new Date(this.firstConnectionTimestamp) + ";");
        sb.append("\tActive Connections:" + this.getMonitoredActiveRequestsCount() + ";");
        sb.append("\ttotal failure count in last (" + this.failureCountSlidingWindowInterval + ") msecs:" + this.getFailureCount() + ";");
        sb.append("\taverage resp time:" + this.getResponseTimeAvg() + ";");
        sb.append("\t90 percentile resp time:" + this.getResponseTime90thPercentile() + ";");
        sb.append("\t95 percentile resp time:" + this.getResponseTime95thPercentile() + ";");
        sb.append("\tmin resp time:" + this.getResponseTimeMin() + ";");
        sb.append("\tmax resp time:" + this.getResponseTimeMax() + ";");
        sb.append("\tstddev resp time:" + this.getResponseTimeStdDev());
        sb.append("]\n");
        return sb.toString();
    }

    public static void main(String[] args) {
        ServerStats ss = new ServerStats();
        ss.setBufferSize(1000);
        ss.setPublishInterval(1000);
        ss.initialize(new Server("stonse", 80));
        Random r = new Random(1459834L);
        for (int i = 0; i < 99; ++i) {
            double rl = r.nextDouble() * 25.2;
            ss.noteResponseTime(rl);
            ss.incrementNumRequests();
            try {
                Thread.sleep(100L);
                System.out.println("ServerStats:avg:" + ss.getResponseTimeAvg());
                System.out.println("ServerStats:90 percentile:" + ss.getResponseTime90thPercentile());
                System.out.println("ServerStats:90 percentile:" + ss.getResponseTimePercentileNumValues());
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        System.out.println("done ---");
        ss.publisher.stop();
        System.out.println("ServerStats:" + ss);
    }

    private static enum Percent {
        TEN(10.0),
        TWENTY_FIVE(25.0),
        FIFTY(50.0),
        SEVENTY_FIVE(75.0),
        NINETY(90.0),
        NINETY_FIVE(95.0),
        NINETY_EIGHT(98.0),
        NINETY_NINE(99.0),
        NINETY_NINE_POINT_FIVE(99.5);

        private double val;

        private Percent(double val) {
            this.val = val;
        }

        public double getValue() {
            return this.val;
        }
    }
}

