/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer.reactive;

import com.netflix.client.RetryHandler;
import com.netflix.loadbalancer.LoadBalancerContext;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.reactive.CommandToObservableConverter;
import com.netflix.loadbalancer.reactive.LoadBalancerExecutable;
import com.netflix.loadbalancer.reactive.LoadBalancerObservableCommand;
import com.netflix.loadbalancer.reactive.RxUtils;
import java.net.URI;
import rx.Observable;

public abstract class LoadBalancerCommand<T>
implements LoadBalancerExecutable<T> {
    private final LoadBalancerObservableCommand<T> observableCommand;
    private final URI loadBalancerURI;
    private final Object loadBalancerKey;
    private final LoadBalancerContext loadBalancerContext;
    private final RetryHandler retryHandler;

    public LoadBalancerCommand(LoadBalancerContext loadBalancerContext) {
        this(loadBalancerContext, null, null, null);
    }

    public LoadBalancerCommand(LoadBalancerContext loadBalancerContext, RetryHandler retryHandler) {
        this(loadBalancerContext, retryHandler, null, null);
    }

    public LoadBalancerCommand(LoadBalancerContext loadBalancerContext, RetryHandler retryHandler, URI loadBalancerURI, Object loadBalancerKey) {
        this.loadBalancerContext = loadBalancerContext;
        this.retryHandler = retryHandler;
        this.loadBalancerURI = loadBalancerURI;
        this.loadBalancerKey = loadBalancerKey;
        this.observableCommand = this.createObservableCommand();
    }

    private LoadBalancerObservableCommand<T> createObservableCommand() {
        return new LoadBalancerObservableCommand<T>(this.loadBalancerContext, this.retryHandler, this.loadBalancerURI, this.loadBalancerKey, null){

            @Override
            public Observable<T> call(Server server) {
                return CommandToObservableConverter.toObsevable(LoadBalancerCommand.this).call(server);
            }
        };
    }

    public T execute() throws Exception {
        return RxUtils.getSingleValueWithRealErrorCause(this.observableCommand.toObservable());
    }
}

