/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer.reactive;

import com.netflix.client.ClientException;
import com.netflix.client.RetryHandler;
import com.netflix.client.Utils;
import com.netflix.loadbalancer.LoadBalancerContext;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.reactive.ExecutionContextListenerInvoker;
import com.netflix.loadbalancer.reactive.ExecutionListener;
import com.netflix.loadbalancer.reactive.LoadBalancerObservable;
import com.netflix.loadbalancer.reactive.LoadBalancerRetrySameServerCommand;
import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.subscriptions.SerialSubscription;

public abstract class LoadBalancerObservableCommand<T>
extends LoadBalancerRetrySameServerCommand<T>
implements LoadBalancerObservable<T> {
    private static final Logger logger = LoggerFactory.getLogger(LoadBalancerObservableCommand.class);
    private final URI loadBalancerURI;
    private final Object loadBalancerKey;

    public LoadBalancerObservableCommand(LoadBalancerContext loadBalancerContext) {
        this(loadBalancerContext, null, null, null, null);
    }

    public LoadBalancerObservableCommand(LoadBalancerContext loadBalancerContext, RetryHandler retryHandler) {
        this(loadBalancerContext, retryHandler, null, null, null);
    }

    public LoadBalancerObservableCommand(LoadBalancerContext loadBalancerContext, RetryHandler retryHandler, ExecutionContextListenerInvoker<?, T> listenerInvoker) {
        this(loadBalancerContext, retryHandler, null, null, listenerInvoker);
    }

    public LoadBalancerObservableCommand(LoadBalancerContext loadBalancerContext, RetryHandler retryHandler, URI loadBalancerURI, Object loadBalancerKey, ExecutionContextListenerInvoker<?, T> listenerInvoker) {
        super(loadBalancerContext, retryHandler, listenerInvoker);
        this.loadBalancerURI = loadBalancerURI;
        this.loadBalancerKey = loadBalancerKey;
    }

    public Observable<T> toObservable() {
        Server server = null;
        try {
            server = this.loadBalancerContext.getServerFromLoadBalancer(this.loadBalancerURI, this.loadBalancerKey);
        }
        catch (Exception e) {
            return Observable.error((Throwable)e);
        }
        if (this.getRetryHandler().getMaxRetriesOnNextServer() == 0) {
            return this.retryWithSameServer(server, this.call(server));
        }
        return this.retryWithSameServer(server, this.call(server), 0).lift((Observable.Operator)new RetryNextServerOperator());
    }

    private class RetryNextServerOperator
    implements Observable.Operator<T, T> {
        private final AtomicInteger counter = new AtomicInteger();

        private RetryNextServerOperator() {
        }

        public Subscriber<? super T> call(final Subscriber<? super T> t1) {
            if (LoadBalancerObservableCommand.this.listenerInvoker != null && this.counter.get() == 0) {
                LoadBalancerObservableCommand.this.listenerInvoker.onExecutionStart();
            }
            SerialSubscription serialSubscription = new SerialSubscription();
            t1.add((Subscription)serialSubscription);
            Subscriber subscriber = new Subscriber<T>(){

                public void onCompleted() {
                    t1.onCompleted();
                }

                public void onError(Throwable e) {
                    Throwable finalThrowable;
                    boolean shouldRetry;
                    logger.debug("Get error during retry on next server", e);
                    if (e instanceof ExecutionListener.AbortExecutionException) {
                        t1.onError(e);
                        return;
                    }
                    int maxRetriesNextServer = LoadBalancerObservableCommand.this.getRetryHandler().getMaxRetriesOnNextServer();
                    boolean sameServerRetryExceededLimit = e instanceof ClientException && ((ClientException)e).getErrorType().equals((Object)ClientException.ErrorType.NUMBEROF_RETRIES_EXEEDED);
                    boolean bl = shouldRetry = maxRetriesNextServer > 0 && (sameServerRetryExceededLimit || LoadBalancerObservableCommand.this.getRetryHandler().isRetriableException(e, false));
                    if (shouldRetry && RetryNextServerOperator.this.counter.incrementAndGet() > maxRetriesNextServer) {
                        finalThrowable = new ClientException(ClientException.ErrorType.NUMBEROF_RETRIES_NEXTSERVER_EXCEEDED, "NUMBER_OF_RETRIES_NEXTSERVER_EXCEEDED :" + maxRetriesNextServer + " retries, while making a call with load balancer: " + Utils.getDeepestCause((Throwable)e).getMessage(), e);
                        shouldRetry = false;
                    } else {
                        finalThrowable = e;
                    }
                    if (shouldRetry) {
                        Server server = null;
                        try {
                            server = LoadBalancerObservableCommand.this.loadBalancerContext.getServerFromLoadBalancer(LoadBalancerObservableCommand.this.loadBalancerURI, LoadBalancerObservableCommand.this.loadBalancerKey);
                        }
                        catch (Exception ex) {
                            logger.error("Unexpected error", (Throwable)ex);
                            t1.onError((Throwable)ex);
                        }
                        LoadBalancerObservableCommand.this.retryWithSameServer(server, LoadBalancerObservableCommand.this.call(server), RetryNextServerOperator.this.counter.get()).lift((Observable.Operator)RetryNextServerOperator.this).unsafeSubscribe(t1);
                    } else {
                        if (LoadBalancerObservableCommand.this.listenerInvoker != null) {
                            LoadBalancerObservableCommand.this.listenerInvoker.onExecutionFailed(finalThrowable, LoadBalancerObservableCommand.this.executionInfo);
                        }
                        t1.onError(finalThrowable);
                    }
                }

                public void onNext(T t) {
                    t1.onNext(t);
                }
            };
            serialSubscription.set((Subscription)subscriber);
            return subscriber;
        }
    }
}

