/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer.reactive;

import com.netflix.client.ClientException;
import com.netflix.client.RetryHandler;
import com.netflix.loadbalancer.LoadBalancerContext;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerStats;
import com.netflix.loadbalancer.reactive.CommandToObservableConverter;
import com.netflix.loadbalancer.reactive.ExecutionContextListenerInvoker;
import com.netflix.loadbalancer.reactive.ExecutionInfo;
import com.netflix.loadbalancer.reactive.LoadBalancerExecutable;
import com.netflix.loadbalancer.reactive.LoadBalancerObservableCommand;
import com.netflix.loadbalancer.reactive.RxUtils;
import com.netflix.servo.monitor.Stopwatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.observers.SafeSubscriber;
import rx.subscriptions.SerialSubscription;

public class LoadBalancerRetrySameServerCommand<T> {
    private static final Logger logger = LoggerFactory.getLogger(LoadBalancerObservableCommand.class);
    protected final LoadBalancerContext loadBalancerContext;
    private final RetryHandler retryHandler;
    protected final ExecutionContextListenerInvoker<?, T> listenerInvoker;
    protected volatile ExecutionInfo executionInfo;

    public LoadBalancerRetrySameServerCommand(LoadBalancerContext loadBalancerContext) {
        this(loadBalancerContext, null);
    }

    public LoadBalancerRetrySameServerCommand(LoadBalancerContext loadBalancerContext, RetryHandler retryHandler) {
        this(loadBalancerContext, retryHandler, null);
    }

    public LoadBalancerRetrySameServerCommand(LoadBalancerContext loadBalancerContext, RetryHandler retryHandler, ExecutionContextListenerInvoker<?, T> listenerInvoker) {
        this.loadBalancerContext = loadBalancerContext;
        this.retryHandler = retryHandler;
        this.listenerInvoker = listenerInvoker;
    }

    protected final RetryHandler getRetryHandler() {
        return this.retryHandler != null ? this.retryHandler : this.loadBalancerContext.getRetryHandler();
    }

    public Observable<T> retryWithSameServer(Server server, Observable<T> forServer) {
        return forServer.lift((Observable.Operator)new RetrySameServerOperator(server, forServer));
    }

    public T retryWithSameServer(Server server, LoadBalancerExecutable<T> executable) throws Exception {
        Observable<T> result = this.retryWithSameServer(server, CommandToObservableConverter.toObsevable(executable).call(server));
        return RxUtils.getSingleValueWithRealErrorCause(result);
    }

    Observable<T> retryWithSameServer(Server server, Observable<T> forServer, int numberServersTried) {
        return forServer.lift((Observable.Operator)new RetrySameServerOperator(server, forServer, numberServersTried));
    }

    private class RetrySameServerOperator
    implements Observable.Operator<T, T> {
        private final Server server;
        private final Observable<T> singleHostObservable;
        private final RetryHandler errorHandler;
        private final AtomicInteger counter;
        private final int numberServersAttempted;
        private final boolean invokeOnStartAndEnd;

        RetrySameServerOperator(Server server, Observable<T> singleHostObservable, int numberServersAttempted) {
            this.errorHandler = LoadBalancerRetrySameServerCommand.this.getRetryHandler();
            this.counter = new AtomicInteger();
            this.server = server;
            this.singleHostObservable = singleHostObservable;
            this.numberServersAttempted = numberServersAttempted;
            this.invokeOnStartAndEnd = false;
        }

        RetrySameServerOperator(Server server, Observable<T> singleHostObservable) {
            this.errorHandler = LoadBalancerRetrySameServerCommand.this.getRetryHandler();
            this.counter = new AtomicInteger();
            this.server = server;
            this.singleHostObservable = singleHostObservable;
            this.numberServersAttempted = 0;
            this.invokeOnStartAndEnd = true;
        }

        public Subscriber<? super T> call(final Subscriber<? super T> t1) {
            if (LoadBalancerRetrySameServerCommand.this.listenerInvoker != null) {
                LoadBalancerRetrySameServerCommand.this.executionInfo = ExecutionInfo.create(this.server, this.counter.get(), this.numberServersAttempted);
                if (this.invokeOnStartAndEnd && this.counter.get() == 0) {
                    LoadBalancerRetrySameServerCommand.this.listenerInvoker.onExecutionStart();
                }
                LoadBalancerRetrySameServerCommand.this.listenerInvoker.onStartWithServer(LoadBalancerRetrySameServerCommand.this.executionInfo);
            }
            SerialSubscription serialSubscription = new SerialSubscription();
            t1.add((Subscription)serialSubscription);
            final ServerStats serverStats = LoadBalancerRetrySameServerCommand.this.loadBalancerContext.getServerStats(this.server);
            LoadBalancerRetrySameServerCommand.this.loadBalancerContext.noteOpenConnection(serverStats);
            final Stopwatch tracer = LoadBalancerRetrySameServerCommand.this.loadBalancerContext.getExecuteTracer().start();
            Subscriber subscriber = new Subscriber<T>(){
                private volatile T entity;

                public void onCompleted() {
                    this.recordStats(this.entity, null);
                    if (LoadBalancerRetrySameServerCommand.this.listenerInvoker != null) {
                        LoadBalancerRetrySameServerCommand.this.executionInfo = ExecutionInfo.create(RetrySameServerOperator.this.server, RetrySameServerOperator.this.counter.get(), RetrySameServerOperator.this.numberServersAttempted);
                        LoadBalancerRetrySameServerCommand.this.listenerInvoker.onExecutionSuccess(this.entity, LoadBalancerRetrySameServerCommand.this.executionInfo);
                    }
                    t1.onCompleted();
                }

                public void onError(Throwable e) {
                    Throwable finalThrowable;
                    boolean shouldRetry;
                    logger.debug("Got error {} when executed on server {}", (Object)e, (Object)RetrySameServerOperator.this.server);
                    if (LoadBalancerRetrySameServerCommand.this.listenerInvoker != null) {
                        LoadBalancerRetrySameServerCommand.this.executionInfo = ExecutionInfo.create(RetrySameServerOperator.this.server, RetrySameServerOperator.this.counter.get(), RetrySameServerOperator.this.numberServersAttempted);
                        LoadBalancerRetrySameServerCommand.this.listenerInvoker.onExceptionWithServer(e, LoadBalancerRetrySameServerCommand.this.executionInfo);
                    }
                    this.recordStats(this.entity, e);
                    int maxRetries = RetrySameServerOperator.this.errorHandler.getMaxRetriesOnSameServer();
                    boolean bl = shouldRetry = maxRetries > 0 && RetrySameServerOperator.this.errorHandler.isRetriableException(e, true);
                    if (shouldRetry && !LoadBalancerRetrySameServerCommand.this.loadBalancerContext.handleSameServerRetry(RetrySameServerOperator.this.server, RetrySameServerOperator.this.counter.incrementAndGet(), maxRetries, e)) {
                        LoadBalancerRetrySameServerCommand.this.executionInfo = ExecutionInfo.create(RetrySameServerOperator.this.server, RetrySameServerOperator.this.counter.get(), RetrySameServerOperator.this.numberServersAttempted);
                        finalThrowable = new ClientException(ClientException.ErrorType.NUMBEROF_RETRIES_EXEEDED, "Number of retries exceeded max " + maxRetries + " retries, while making a call for: " + RetrySameServerOperator.this.server, e);
                        shouldRetry = false;
                    } else {
                        finalThrowable = e;
                    }
                    if (shouldRetry) {
                        RetrySameServerOperator.this.singleHostObservable.lift((Observable.Operator)RetrySameServerOperator.this).unsafeSubscribe(t1);
                    } else {
                        if (LoadBalancerRetrySameServerCommand.this.listenerInvoker != null && RetrySameServerOperator.this.invokeOnStartAndEnd) {
                            LoadBalancerRetrySameServerCommand.this.listenerInvoker.onExecutionFailed(finalThrowable, LoadBalancerRetrySameServerCommand.this.executionInfo);
                        }
                        t1.onError(finalThrowable);
                    }
                }

                public void onNext(T obj) {
                    this.entity = obj;
                    t1.onNext(obj);
                }

                private void recordStats(Object entity, Throwable exception) {
                    tracer.stop();
                    long duration = tracer.getDuration(TimeUnit.MILLISECONDS);
                    LoadBalancerRetrySameServerCommand.this.loadBalancerContext.noteRequestCompletion(serverStats, entity, exception, duration, RetrySameServerOperator.this.errorHandler);
                }
            };
            SafeSubscriber safeSubscriber = new SafeSubscriber(subscriber);
            serialSubscription.set((Subscription)safeSubscriber);
            return safeSubscriber;
        }
    }
}

