/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractLoadBalancerRule;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinRule
extends AbstractLoadBalancerRule {
    private AtomicLong nextIndexAI = new AtomicLong(0L);
    private static Logger log = LoggerFactory.getLogger(RoundRobinRule.class);
    static final boolean availableOnly = false;

    public RoundRobinRule() {
    }

    public RoundRobinRule(ILoadBalancer lb) {
        this();
        this.setLoadBalancer(lb);
    }

    public Server choose(ILoadBalancer lb, Object key) {
        if (lb == null) {
            log.warn("no load balancer");
            return null;
        }
        Server server = null;
        int index = 0;
        int count = 0;
        while (server == null && count++ < 10) {
            List<Server> upList = lb.getServerList(true);
            List<Server> allList = lb.getServerList(false);
            int upCount = upList.size();
            int serverCount = allList.size();
            if (upCount == 0 || serverCount == 0) {
                log.warn("No up servers available from load balancer: " + lb);
                return null;
            }
            index = (int)(this.nextIndexAI.incrementAndGet() % (long)serverCount);
            server = allList.get(index);
            if (server == null) {
                Thread.yield();
                continue;
            }
            if (server.isAlive() && server.isReadyToServe()) {
                return server;
            }
            server = null;
        }
        if (count >= 10) {
            log.warn("No available alive servers after 10 tries from load balancer: " + lb);
        }
        return server;
    }

    @Override
    public Server choose(Object key) {
        return this.choose(this.getLoadBalancer(), key);
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
    }
}

