/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.google.common.collect.ImmutableList;
import com.netflix.client.ClientFactory;
import com.netflix.client.IClientConfigAware;
import com.netflix.client.PrimeConnections;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractLoadBalancer;
import com.netflix.loadbalancer.AbstractLoadBalancerPing;
import com.netflix.loadbalancer.DummyPing;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IPingStrategy;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.RoundRobinRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerComparator;
import com.netflix.loadbalancer.ServerListChangeListener;
import com.netflix.loadbalancer.ServerStatusChangeListener;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitors;
import com.netflix.util.concurrent.ShutdownEnabledTimer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseLoadBalancer
extends AbstractLoadBalancer
implements PrimeConnections.PrimeConnectionListener,
IClientConfigAware {
    private static Logger logger = LoggerFactory.getLogger(BaseLoadBalancer.class);
    private static final IRule DEFAULT_RULE = new RoundRobinRule();
    private static final SerialPingStrategy DEFAULT_PING_STRATEGY = new SerialPingStrategy();
    private static final String DEFAULT_NAME = "default";
    private static final String PREFIX = "LoadBalancer_";
    protected IRule rule = DEFAULT_RULE;
    protected IPingStrategy pingStrategy = DEFAULT_PING_STRATEGY;
    protected IPing ping = null;
    @Monitor(name="LoadBalancer_AllServerList", type=DataSourceType.INFORMATIONAL)
    protected volatile List<Server> allServerList = Collections.synchronizedList(new ArrayList());
    @Monitor(name="LoadBalancer_UpServerList", type=DataSourceType.INFORMATIONAL)
    protected volatile List<Server> upServerList = Collections.synchronizedList(new ArrayList());
    protected ReadWriteLock allServerLock = new ReentrantReadWriteLock();
    protected ReadWriteLock upServerLock = new ReentrantReadWriteLock();
    protected String name = "default";
    protected Timer lbTimer = null;
    protected int pingIntervalSeconds = 10;
    protected int maxTotalPingTimeSeconds = 5;
    protected Comparator<Server> serverComparator = new ServerComparator();
    protected AtomicBoolean pingInProgress = new AtomicBoolean(false);
    protected LoadBalancerStats lbStats;
    private volatile Counter counter = Monitors.newCounter((String)"LoadBalancer_ChooseServer");
    private PrimeConnections primeConnections;
    private volatile boolean enablePrimingConnections = false;
    private IClientConfig config;
    private List<ServerListChangeListener> changeListeners = new CopyOnWriteArrayList<ServerListChangeListener>();
    private List<ServerStatusChangeListener> serverStatusListeners = new CopyOnWriteArrayList<ServerStatusChangeListener>();

    public BaseLoadBalancer() {
        this.name = DEFAULT_NAME;
        this.ping = null;
        this.setRule(DEFAULT_RULE);
        this.setupPingTask();
        this.lbStats = new LoadBalancerStats(DEFAULT_NAME);
    }

    public BaseLoadBalancer(String lbName, IRule rule, LoadBalancerStats lbStats) {
        this(lbName, rule, lbStats, null);
    }

    public BaseLoadBalancer(IPing ping, IRule rule) {
        this(DEFAULT_NAME, rule, new LoadBalancerStats(DEFAULT_NAME), ping);
    }

    public BaseLoadBalancer(IPing ping, IRule rule, IPingStrategy pingStrategy) {
        this(DEFAULT_NAME, rule, new LoadBalancerStats(DEFAULT_NAME), ping, pingStrategy);
    }

    public BaseLoadBalancer(String name, IRule rule, LoadBalancerStats stats, IPing ping) {
        this(name, rule, stats, ping, DEFAULT_PING_STRATEGY);
    }

    public BaseLoadBalancer(String name, IRule rule, LoadBalancerStats stats, IPing ping, IPingStrategy pingStrategy) {
        logger.debug("LoadBalancer [{}]:  initialized", (Object)name);
        this.name = name;
        this.ping = ping;
        this.pingStrategy = pingStrategy;
        this.setRule(rule);
        this.setupPingTask();
        this.lbStats = stats;
        this.init();
    }

    public BaseLoadBalancer(IClientConfig config) {
        this.initWithNiwsConfig(config);
    }

    public BaseLoadBalancer(IClientConfig config, IRule rule, IPing ping) {
        this.initWithConfig(config, rule, ping);
    }

    void initWithConfig(IClientConfig clientConfig, IRule rule, IPing ping) {
        String clientName;
        this.config = clientConfig;
        this.name = clientName = clientConfig.getClientName();
        int pingIntervalTime = Integer.parseInt("" + clientConfig.getProperty(CommonClientConfigKey.NFLoadBalancerPingInterval, (Object)Integer.parseInt("30")));
        int maxTotalPingTime = Integer.parseInt("" + clientConfig.getProperty(CommonClientConfigKey.NFLoadBalancerMaxTotalPingTime, (Object)Integer.parseInt("2")));
        this.setPingInterval(pingIntervalTime);
        this.setMaxTotalPingTime(maxTotalPingTime);
        this.setRule(rule);
        this.setPing(ping);
        this.setLoadBalancerStats(new LoadBalancerStats(clientName));
        rule.setLoadBalancer(this);
        if (ping instanceof AbstractLoadBalancerPing) {
            ((AbstractLoadBalancerPing)ping).setLoadBalancer(this);
        }
        logger.info("Client: {} instantiated a LoadBalancer: {}", (Object)this.name, (Object)this);
        boolean enablePrimeConnections = (Boolean)clientConfig.get(CommonClientConfigKey.EnablePrimeConnections, (Object)DefaultClientConfigImpl.DEFAULT_ENABLE_PRIME_CONNECTIONS);
        if (enablePrimeConnections) {
            this.setEnablePrimingConnections(true);
            PrimeConnections primeConnections = new PrimeConnections(this.getName(), clientConfig);
            this.setPrimeConnections(primeConnections);
        }
        this.init();
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        IPing ping;
        IRule rule;
        String ruleClassName = (String)clientConfig.getProperty(CommonClientConfigKey.NFLoadBalancerRuleClassName);
        String pingClassName = (String)clientConfig.getProperty(CommonClientConfigKey.NFLoadBalancerPingClassName);
        try {
            rule = (IRule)ClientFactory.instantiateInstanceWithClientConfig(ruleClassName, clientConfig);
            ping = (IPing)ClientFactory.instantiateInstanceWithClientConfig(pingClassName, clientConfig);
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing load balancer", e);
        }
        this.initWithConfig(clientConfig, rule, ping);
    }

    public void addServerListChangeListener(ServerListChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeServerListChangeListener(ServerListChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void addServerStatusChangeListener(ServerStatusChangeListener listener) {
        this.serverStatusListeners.add(listener);
    }

    public void removeServerStatusChangeListener(ServerStatusChangeListener listener) {
        this.serverStatusListeners.remove(listener);
    }

    public IClientConfig getClientConfig() {
        return this.config;
    }

    private boolean canSkipPing() {
        return this.ping == null || this.ping.getClass().getName().equals(DummyPing.class.getName());
    }

    void setupPingTask() {
        if (this.canSkipPing()) {
            return;
        }
        if (this.lbTimer != null) {
            this.lbTimer.cancel();
        }
        this.lbTimer = new ShutdownEnabledTimer("NFLoadBalancer-PingTimer-" + this.name, true);
        this.lbTimer.schedule((TimerTask)new PingTask(), 0L, (long)(this.pingIntervalSeconds * 1000));
        this.forceQuickPing();
    }

    void setName(String name) {
        this.name = name;
        if (this.lbStats == null) {
            this.lbStats = new LoadBalancerStats(name);
        } else {
            this.lbStats.setName(name);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public LoadBalancerStats getLoadBalancerStats() {
        return this.lbStats;
    }

    public void setLoadBalancerStats(LoadBalancerStats lbStats) {
        this.lbStats = lbStats;
    }

    public Lock lockAllServerList(boolean write) {
        Lock aproposLock = write ? this.allServerLock.writeLock() : this.allServerLock.readLock();
        aproposLock.lock();
        return aproposLock;
    }

    public Lock lockUpServerList(boolean write) {
        Lock aproposLock = write ? this.upServerLock.writeLock() : this.upServerLock.readLock();
        aproposLock.lock();
        return aproposLock;
    }

    public void setPingInterval(int pingIntervalSeconds) {
        if (pingIntervalSeconds < 1) {
            return;
        }
        this.pingIntervalSeconds = pingIntervalSeconds;
        if (logger.isDebugEnabled()) {
            logger.debug("LoadBalancer [{}]:  pingIntervalSeconds set to {}", (Object)this.name, (Object)this.pingIntervalSeconds);
        }
        this.setupPingTask();
    }

    public int getPingInterval() {
        return this.pingIntervalSeconds;
    }

    public void setMaxTotalPingTime(int maxTotalPingTimeSeconds) {
        if (maxTotalPingTimeSeconds < 1) {
            return;
        }
        this.maxTotalPingTimeSeconds = maxTotalPingTimeSeconds;
        logger.debug("LoadBalancer [{}]: maxTotalPingTime set to {}", (Object)this.name, (Object)this.maxTotalPingTimeSeconds);
    }

    public int getMaxTotalPingTime() {
        return this.maxTotalPingTimeSeconds;
    }

    public IPing getPing() {
        return this.ping;
    }

    public IRule getRule() {
        return this.rule;
    }

    public boolean isPingInProgress() {
        return this.pingInProgress.get();
    }

    public void setPing(IPing ping) {
        if (ping != null) {
            if (!ping.equals(this.ping)) {
                this.ping = ping;
                this.setupPingTask();
            }
        } else {
            this.ping = null;
            this.lbTimer.cancel();
        }
    }

    public void setRule(IRule rule) {
        this.rule = rule != null ? rule : new RoundRobinRule();
        if (this.rule.getLoadBalancer() != this) {
            this.rule.setLoadBalancer(this);
        }
    }

    public int getServerCount(boolean onlyAvailable) {
        if (onlyAvailable) {
            return this.upServerList.size();
        }
        return this.allServerList.size();
    }

    public void addServer(Server newServer) {
        if (newServer != null) {
            try {
                ArrayList<Server> newList = new ArrayList<Server>();
                newList.addAll(this.allServerList);
                newList.add(newServer);
                this.setServersList(newList);
            }
            catch (Exception e) {
                logger.error("LoadBalancer [{}]: Error adding newServer {}", new Object[]{this.name, newServer.getHost(), e});
            }
        }
    }

    @Override
    public void addServers(List<Server> newServers) {
        if (newServers != null && newServers.size() > 0) {
            try {
                ArrayList<Server> newList = new ArrayList<Server>();
                newList.addAll(this.allServerList);
                newList.addAll(newServers);
                this.setServersList(newList);
            }
            catch (Exception e) {
                logger.error("LoadBalancer [{}]: Exception while adding Servers", (Object)this.name, (Object)e);
            }
        }
    }

    void addServers(Object[] newServers) {
        if (newServers != null && newServers.length > 0) {
            try {
                ArrayList<Server> newList = new ArrayList<Server>();
                newList.addAll(this.allServerList);
                for (Object server : newServers) {
                    if (server == null) continue;
                    if (server instanceof String) {
                        server = new Server((String)server);
                    }
                    if (!(server instanceof Server)) continue;
                    newList.add((Server)server);
                }
                this.setServersList(newList);
            }
            catch (Exception e) {
                logger.error("LoadBalancer [{}]: Exception while adding Servers", (Object)this.name, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServersList(List lsrv) {
        Lock writeLock = this.allServerLock.writeLock();
        logger.debug("LoadBalancer [{}]: clearing server list (SET op)", (Object)this.name);
        ArrayList<Server> newServers = new ArrayList<Server>();
        writeLock.lock();
        try {
            ArrayList<Server> allServers = new ArrayList<Server>();
            for (Object server : lsrv) {
                if (server == null) continue;
                if (server instanceof String) {
                    server = new Server((String)server);
                }
                if (server instanceof Server) {
                    logger.debug("LoadBalancer [{}]:  addServer [{}]", (Object)this.name, (Object)((Server)server).getId());
                    allServers.add((Server)server);
                    continue;
                }
                throw new IllegalArgumentException("Type String or Server expected, instead found:" + server.getClass());
            }
            boolean listChanged = false;
            if (!this.allServerList.equals(allServers)) {
                listChanged = true;
                if (this.changeListeners != null && this.changeListeners.size() > 0) {
                    ImmutableList oldList = ImmutableList.copyOf(this.allServerList);
                    ImmutableList newList = ImmutableList.copyOf(allServers);
                    for (ServerListChangeListener l : this.changeListeners) {
                        try {
                            l.serverListChanged((List<Server>)oldList, (List<Server>)newList);
                        }
                        catch (Exception e) {
                            logger.error("LoadBalancer [{}]: Error invoking server list change listener", (Object)this.name, (Object)e);
                        }
                    }
                }
            }
            if (this.isEnablePrimingConnections()) {
                for (Server server : allServers) {
                    if (this.allServerList.contains(server)) continue;
                    server.setReadyToServe(false);
                    newServers.add(server);
                }
                if (this.primeConnections != null) {
                    this.primeConnections.primeConnectionsAsync(newServers, this);
                }
            }
            this.allServerList = allServers;
            if (this.canSkipPing()) {
                for (Server s : this.allServerList) {
                    s.setAlive(true);
                }
                this.upServerList = this.allServerList;
            } else if (listChanged) {
                this.forceQuickPing();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    void setServers(String srvString) {
        if (srvString != null) {
            try {
                String[] serverArr = srvString.split(",");
                ArrayList<Server> newList = new ArrayList<Server>();
                for (String serverString : serverArr) {
                    if (serverString == null || (serverString = serverString.trim()).length() <= 0) continue;
                    Server svr = new Server(serverString);
                    newList.add(svr);
                }
                this.setServersList(newList);
            }
            catch (Exception e) {
                logger.error("LoadBalancer [{}]: Exception while adding Servers", (Object)this.name, (Object)e);
            }
        }
    }

    public Server getServerByIndex(int index, boolean availableOnly) {
        try {
            return availableOnly ? this.upServerList.get(index) : this.allServerList.get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<Server> getServerList(boolean availableOnly) {
        return availableOnly ? this.getReachableServers() : this.getAllServers();
    }

    @Override
    public List<Server> getReachableServers() {
        return Collections.unmodifiableList(this.upServerList);
    }

    @Override
    public List<Server> getAllServers() {
        return Collections.unmodifiableList(this.allServerList);
    }

    @Override
    public List<Server> getServerList(AbstractLoadBalancer.ServerGroup serverGroup) {
        switch (serverGroup) {
            case ALL: {
                return this.allServerList;
            }
            case STATUS_UP: {
                return this.upServerList;
            }
            case STATUS_NOT_UP: {
                ArrayList<Server> notAvailableServers = new ArrayList<Server>(this.allServerList);
                ArrayList<Server> upServers = new ArrayList<Server>(this.upServerList);
                notAvailableServers.removeAll(upServers);
                return notAvailableServers;
            }
        }
        return new ArrayList<Server>();
    }

    public void cancelPingTask() {
        if (this.lbTimer != null) {
            this.lbTimer.cancel();
        }
    }

    private void notifyServerStatusChangeListener(Collection<Server> changedServers) {
        if (changedServers != null && !changedServers.isEmpty() && !this.serverStatusListeners.isEmpty()) {
            for (ServerStatusChangeListener listener : this.serverStatusListeners) {
                try {
                    listener.serverStatusChanged(changedServers);
                }
                catch (Exception e) {
                    logger.error("LoadBalancer [{}]: Error invoking server status change listener", (Object)this.name, (Object)e);
                }
            }
        }
    }

    private final Counter createCounter() {
        return Monitors.newCounter((String)"LoadBalancer_ChooseServer");
    }

    @Override
    public Server chooseServer(Object key) {
        if (this.counter == null) {
            this.counter = this.createCounter();
        }
        this.counter.increment();
        if (this.rule == null) {
            return null;
        }
        try {
            return this.rule.choose(key);
        }
        catch (Exception e) {
            throw new RuntimeException("Error choosing server for key " + key, e);
        }
    }

    public String choose(Object key) {
        if (this.rule == null) {
            return null;
        }
        try {
            Server svr = this.rule.choose(key);
            return svr == null ? null : svr.getId();
        }
        catch (Exception e) {
            throw new RuntimeException("Error choosing server", e);
        }
    }

    @Override
    public void markServerDown(Server server) {
        if (server == null || !server.isAlive()) {
            return;
        }
        logger.error("LoadBalancer [{}]:  markServerDown called on [{}]", (Object)this.name, (Object)server.getId());
        server.setAlive(false);
        this.notifyServerStatusChangeListener(Collections.singleton(server));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markServerDown(String id) {
        boolean triggered = false;
        if ((id = Server.normalizeId(id)) == null) {
            return;
        }
        Lock writeLock = this.upServerLock.writeLock();
        writeLock.lock();
        try {
            ArrayList<Server> changedServers = new ArrayList<Server>();
            for (Server svr : this.upServerList) {
                if (!svr.isAlive() || !svr.getId().equals(id)) continue;
                triggered = true;
                svr.setAlive(false);
                changedServers.add(svr);
            }
            if (triggered) {
                logger.error("LoadBalancer [{}]:  markServerDown called for server [{}]", (Object)this.name, (Object)id);
                this.notifyServerStatusChangeListener(changedServers);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public void forceQuickPing() {
        if (this.canSkipPing()) {
            return;
        }
        logger.debug("LoadBalancer [{}]:  forceQuickPing invoking", (Object)this.name);
        try {
            new Pinger(this.pingStrategy).runPinger();
        }
        catch (Exception e) {
            logger.error("LoadBalancer [{}]: Error running forceQuickPing()", (Object)this.name, (Object)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{NFLoadBalancer:name=").append(this.getName()).append(",current list of Servers=").append(this.allServerList).append(",Load balancer stats=").append(this.lbStats.toString()).append("}");
        return sb.toString();
    }

    protected void init() {
        Monitors.registerObject((String)(PREFIX + this.name), (Object)this);
        Monitors.registerObject((String)("Rule_" + this.name), (Object)this.getRule());
        if (this.enablePrimingConnections && this.primeConnections != null) {
            this.primeConnections.primeConnections(this.getReachableServers());
        }
    }

    public final PrimeConnections getPrimeConnections() {
        return this.primeConnections;
    }

    public final void setPrimeConnections(PrimeConnections primeConnections) {
        this.primeConnections = primeConnections;
    }

    @Override
    public void primeCompleted(Server s, Throwable lastException) {
        s.setReadyToServe(true);
    }

    public boolean isEnablePrimingConnections() {
        return this.enablePrimingConnections;
    }

    public final void setEnablePrimingConnections(boolean enablePrimingConnections) {
        this.enablePrimingConnections = enablePrimingConnections;
    }

    public void shutdown() {
        this.cancelPingTask();
        if (this.primeConnections != null) {
            this.primeConnections.shutdown();
        }
        Monitors.unregisterObject((String)(PREFIX + this.name), (Object)this);
        Monitors.unregisterObject((String)("Rule_" + this.name), (Object)this.getRule());
    }

    private static class SerialPingStrategy
    implements IPingStrategy {
        private SerialPingStrategy() {
        }

        @Override
        public boolean[] pingServers(IPing ping, Server[] servers) {
            int numCandidates = servers.length;
            boolean[] results = new boolean[numCandidates];
            logger.debug("LoadBalancer:  PingTask executing [{}] servers configured", (Object)numCandidates);
            for (int i = 0; i < numCandidates; ++i) {
                results[i] = false;
                try {
                    if (ping == null) continue;
                    results[i] = ping.isAlive(servers[i]);
                    continue;
                }
                catch (Exception e) {
                    logger.error("Exception while pinging Server: '{}'", (Object)servers[i], (Object)e);
                }
            }
            return results;
        }
    }

    class Pinger {
        private final IPingStrategy pingerStrategy;

        public Pinger(IPingStrategy pingerStrategy) {
            this.pingerStrategy = pingerStrategy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runPinger() throws Exception {
            if (!BaseLoadBalancer.this.pingInProgress.compareAndSet(false, true)) {
                return;
            }
            Server[] allServers = null;
            boolean[] results = null;
            Lock allLock = null;
            Lock upLock = null;
            try {
                allLock = BaseLoadBalancer.this.allServerLock.readLock();
                allLock.lock();
                allServers = BaseLoadBalancer.this.allServerList.toArray(new Server[BaseLoadBalancer.this.allServerList.size()]);
                allLock.unlock();
                int numCandidates = allServers.length;
                results = this.pingerStrategy.pingServers(BaseLoadBalancer.this.ping, allServers);
                ArrayList<Server> newUpList = new ArrayList<Server>();
                ArrayList<Server> changedServers = new ArrayList<Server>();
                for (int i = 0; i < numCandidates; ++i) {
                    boolean isAlive = results[i];
                    Server svr = allServers[i];
                    boolean oldIsAlive = svr.isAlive();
                    svr.setAlive(isAlive);
                    if (oldIsAlive != isAlive) {
                        changedServers.add(svr);
                        logger.debug("LoadBalancer [{}]:  Server [{}] status changed to {}", new Object[]{BaseLoadBalancer.this.name, svr.getId(), isAlive ? "ALIVE" : "DEAD"});
                    }
                    if (!isAlive) continue;
                    newUpList.add(svr);
                }
                upLock = BaseLoadBalancer.this.upServerLock.writeLock();
                upLock.lock();
                BaseLoadBalancer.this.upServerList = newUpList;
                upLock.unlock();
                BaseLoadBalancer.this.notifyServerStatusChangeListener(changedServers);
            }
            finally {
                BaseLoadBalancer.this.pingInProgress.set(false);
            }
        }
    }

    class PingTask
    extends TimerTask {
        PingTask() {
        }

        @Override
        public void run() {
            try {
                new Pinger(BaseLoadBalancer.this.pingStrategy).runPinger();
            }
            catch (Exception e) {
                logger.error("LoadBalancer [{}]: Error pinging", (Object)BaseLoadBalancer.this.name, (Object)e);
            }
        }
    }
}

