/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.client.config.Property;
import com.netflix.loadbalancer.AbstractServerPredicate;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.PredicateKey;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import com.netflix.loadbalancer.ZoneSnapshot;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoneAvoidancePredicate
extends AbstractServerPredicate {
    private static final Logger logger = LoggerFactory.getLogger(ZoneAvoidancePredicate.class);
    private static final IClientConfigKey<Double> TRIGGERING_LOAD_PER_SERVER_THRESHOLD = new CommonClientConfigKey<Double>("ZoneAwareNIWSDiscoveryLoadBalancer.%s.triggeringLoadPerServerThreshold", Double.valueOf(0.2)){};
    private static final IClientConfigKey<Double> AVOID_ZONE_WITH_BLACKOUT_PERCENTAGE = new CommonClientConfigKey<Double>("ZoneAwareNIWSDiscoveryLoadBalancer.%s.avoidZoneWithBlackoutPercetage", Double.valueOf(0.99999)){};
    private static final IClientConfigKey<Boolean> ENABLED = new CommonClientConfigKey<Boolean>("niws.loadbalancer.zoneAvoidanceRule.enabled", Boolean.valueOf(true)){};
    private Property<Double> triggeringLoad = Property.of((Object)TRIGGERING_LOAD_PER_SERVER_THRESHOLD.defaultValue());
    private Property<Double> triggeringBlackoutPercentage = Property.of((Object)AVOID_ZONE_WITH_BLACKOUT_PERCENTAGE.defaultValue());
    private Property<Boolean> enabled = Property.of((Object)ENABLED.defaultValue());

    public ZoneAvoidancePredicate(IRule rule, IClientConfig clientConfig) {
        super(rule);
        this.initDynamicProperties(clientConfig);
    }

    public ZoneAvoidancePredicate(LoadBalancerStats lbStats, IClientConfig clientConfig) {
        super(lbStats);
        this.initDynamicProperties(clientConfig);
    }

    ZoneAvoidancePredicate(IRule rule) {
        super(rule);
    }

    private void initDynamicProperties(IClientConfig clientConfig) {
        if (clientConfig != null) {
            this.enabled = clientConfig.getGlobalProperty(ENABLED);
            this.triggeringLoad = clientConfig.getGlobalProperty(TRIGGERING_LOAD_PER_SERVER_THRESHOLD.format(new Object[]{clientConfig.getClientName()}));
            this.triggeringBlackoutPercentage = clientConfig.getGlobalProperty(AVOID_ZONE_WITH_BLACKOUT_PERCENTAGE.format(new Object[]{clientConfig.getClientName()}));
        }
    }

    public boolean apply(@Nullable PredicateKey input) {
        if (!((Boolean)this.enabled.getOrDefault()).booleanValue()) {
            return true;
        }
        String serverZone = input.getServer().getZone();
        if (serverZone == null) {
            return true;
        }
        LoadBalancerStats lbStats = this.getLBStats();
        if (lbStats == null) {
            return true;
        }
        if (lbStats.getAvailableZones().size() <= 1) {
            return true;
        }
        Map<String, ZoneSnapshot> zoneSnapshot = ZoneAvoidanceRule.createSnapshot(lbStats);
        if (!zoneSnapshot.keySet().contains(serverZone)) {
            return true;
        }
        logger.debug("Zone snapshots: {}", zoneSnapshot);
        Set<String> availableZones = ZoneAvoidanceRule.getAvailableZones(zoneSnapshot, (double)((Double)this.triggeringLoad.getOrDefault()), (double)((Double)this.triggeringBlackoutPercentage.getOrDefault()));
        logger.debug("Available zones: {}", availableZones);
        if (availableZones != null) {
            return availableZones.contains(input.getServer().getZone());
        }
        return false;
    }
}

