/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.netflix.client.IClientConfigAware;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.client.config.Property;
import com.netflix.loadbalancer.AbstractServerListFilter;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAffinityPredicate;
import com.netflix.loadbalancer.ZoneSnapshot;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitors;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoneAffinityServerListFilter<T extends Server>
extends AbstractServerListFilter<T>
implements IClientConfigAware {
    private static IClientConfigKey<String> ZONE = new CommonClientConfigKey<String>("@zone", ""){};
    private static IClientConfigKey<Double> MAX_LOAD_PER_SERVER = new CommonClientConfigKey<Double>("zoneAffinity.maxLoadPerServer", Double.valueOf(0.6)){};
    private static IClientConfigKey<Double> MAX_BLACKOUT_SERVER_PERCENTAGE = new CommonClientConfigKey<Double>("zoneAffinity.maxBlackOutServesrPercentage", Double.valueOf(0.8)){};
    private static IClientConfigKey<Integer> MIN_AVAILABLE_SERVERS = new CommonClientConfigKey<Integer>("zoneAffinity.minAvailableServers", Integer.valueOf(2)){};
    private boolean zoneAffinity;
    private boolean zoneExclusive;
    private Property<Double> activeReqeustsPerServerThreshold;
    private Property<Double> blackOutServerPercentageThreshold;
    private Property<Integer> availableServersThreshold;
    private Counter overrideCounter;
    private ZoneAffinityPredicate zoneAffinityPredicate;
    private static Logger logger = LoggerFactory.getLogger(ZoneAffinityServerListFilter.class);
    private String zone;

    @Deprecated
    public ZoneAffinityServerListFilter() {
    }

    public ZoneAffinityServerListFilter(IClientConfig niwsClientConfig) {
        this.initWithNiwsConfig(niwsClientConfig);
    }

    public void initWithNiwsConfig(IClientConfig niwsClientConfig) {
        this.zoneAffinity = (Boolean)niwsClientConfig.getOrDefault(CommonClientConfigKey.EnableZoneAffinity);
        this.zoneExclusive = (Boolean)niwsClientConfig.getOrDefault(CommonClientConfigKey.EnableZoneExclusivity);
        this.zone = (String)niwsClientConfig.getGlobalProperty(ZONE).getOrDefault();
        this.zoneAffinityPredicate = new ZoneAffinityPredicate(this.zone);
        this.activeReqeustsPerServerThreshold = niwsClientConfig.getDynamicProperty(MAX_LOAD_PER_SERVER);
        this.blackOutServerPercentageThreshold = niwsClientConfig.getDynamicProperty(MAX_BLACKOUT_SERVER_PERCENTAGE);
        this.availableServersThreshold = niwsClientConfig.getDynamicProperty(MIN_AVAILABLE_SERVERS);
        this.overrideCounter = Monitors.newCounter((String)"ZoneAffinity_OverrideCounter");
        Monitors.registerObject((Object)("NIWSServerListFilter_" + niwsClientConfig.getClientName()));
    }

    private boolean shouldEnableZoneAffinity(List<T> filtered) {
        if (!this.zoneAffinity && !this.zoneExclusive) {
            return false;
        }
        if (this.zoneExclusive) {
            return true;
        }
        LoadBalancerStats stats = this.getLoadBalancerStats();
        if (stats == null) {
            return this.zoneAffinity;
        }
        logger.debug("Determining if zone affinity should be enabled with given server list: {}", filtered);
        ZoneSnapshot snapshot = stats.getZoneSnapshot(filtered);
        double loadPerServer = snapshot.getLoadPerServer();
        int instanceCount = snapshot.getInstanceCount();
        int circuitBreakerTrippedCount = snapshot.getCircuitTrippedCount();
        if ((double)circuitBreakerTrippedCount / (double)instanceCount >= (Double)this.blackOutServerPercentageThreshold.getOrDefault() || loadPerServer >= (Double)this.activeReqeustsPerServerThreshold.getOrDefault() || instanceCount - circuitBreakerTrippedCount < (Integer)this.availableServersThreshold.getOrDefault()) {
            logger.debug("zoneAffinity is overriden. blackOutServerPercentage: {}, activeReqeustsPerServer: {}, availableServers: {}", new Object[]{(double)circuitBreakerTrippedCount / (double)instanceCount, loadPerServer, instanceCount - circuitBreakerTrippedCount});
            return false;
        }
        return true;
    }

    @Override
    public List<T> getFilteredListOfServers(List<T> servers) {
        if (this.zone != null && (this.zoneAffinity || this.zoneExclusive) && servers != null && servers.size() > 0) {
            ArrayList filteredServers = Lists.newArrayList((Iterable)Iterables.filter(servers, this.zoneAffinityPredicate.getServerOnlyPredicate()));
            if (this.shouldEnableZoneAffinity(filteredServers)) {
                return filteredServers;
            }
            if (this.zoneAffinity) {
                this.overrideCounter.increment();
            }
        }
        return servers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ZoneAffinityServerListFilter:");
        sb.append(", zone: ").append(this.zone).append(", zoneAffinity:").append(this.zoneAffinity);
        sb.append(", zoneExclusivity:").append(this.zoneExclusive);
        return sb.toString();
    }
}

