/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.client.config.Property;
import com.netflix.loadbalancer.AbstractServerPredicate;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.PredicateKey;
import com.netflix.loadbalancer.ServerStats;
import javax.annotation.Nullable;

public class AvailabilityPredicate
extends AbstractServerPredicate {
    private static final IClientConfigKey<Boolean> FILTER_CIRCUIT_TRIPPED = new CommonClientConfigKey<Boolean>("niws.loadbalancer.availabilityFilteringRule.filterCircuitTripped", Boolean.valueOf(true)){};
    private static final IClientConfigKey<Integer> DEFAULT_ACTIVE_CONNECTIONS_LIMIT = new CommonClientConfigKey<Integer>("niws.loadbalancer.availabilityFilteringRule.activeConnectionsLimit", Integer.valueOf(-1)){};
    private static final IClientConfigKey<Integer> ACTIVE_CONNECTIONS_LIMIT = new CommonClientConfigKey<Integer>("ActiveConnectionsLimit", Integer.valueOf(-1)){};
    private Property<Boolean> circuitBreakerFiltering = Property.of((Object)FILTER_CIRCUIT_TRIPPED.defaultValue());
    private Property<Integer> defaultActiveConnectionsLimit = Property.of((Object)DEFAULT_ACTIVE_CONNECTIONS_LIMIT.defaultValue());
    private Property<Integer> activeConnectionsLimit = Property.of((Object)ACTIVE_CONNECTIONS_LIMIT.defaultValue());

    public AvailabilityPredicate(IRule rule, IClientConfig clientConfig) {
        super(rule);
        this.initDynamicProperty(clientConfig);
    }

    public AvailabilityPredicate(LoadBalancerStats lbStats, IClientConfig clientConfig) {
        super(lbStats);
        this.initDynamicProperty(clientConfig);
    }

    AvailabilityPredicate(IRule rule) {
        super(rule);
    }

    private void initDynamicProperty(IClientConfig clientConfig) {
        if (clientConfig != null) {
            this.circuitBreakerFiltering = clientConfig.getGlobalProperty(FILTER_CIRCUIT_TRIPPED);
            this.defaultActiveConnectionsLimit = clientConfig.getGlobalProperty(DEFAULT_ACTIVE_CONNECTIONS_LIMIT);
            this.activeConnectionsLimit = clientConfig.getDynamicProperty(ACTIVE_CONNECTIONS_LIMIT);
        }
    }

    private int getActiveConnectionsLimit() {
        Integer limit = (Integer)this.activeConnectionsLimit.getOrDefault();
        if (limit == -1 && (limit = (Integer)this.defaultActiveConnectionsLimit.getOrDefault()) == -1) {
            limit = Integer.MAX_VALUE;
        }
        return limit;
    }

    public boolean apply(@Nullable PredicateKey input) {
        LoadBalancerStats stats = this.getLBStats();
        if (stats == null) {
            return true;
        }
        return !this.shouldSkipServer(stats.getSingleServerStat(input.getServer()));
    }

    private boolean shouldSkipServer(ServerStats stats) {
        return (Boolean)this.circuitBreakerFiltering.getOrDefault() != false && stats.isCircuitBreakerTripped() || stats.getActiveRequestsCount() >= this.getActiveConnectionsLimit();
    }
}

